/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.jst.web.webapp.model.handlers;

import java.util.Properties;
import org.jboss.tools.common.meta.action.impl.AbstractHandler;
import org.jboss.tools.common.meta.action.impl.SpecialWizardSupport;
import org.jboss.tools.common.model.XModelException;
import org.jboss.tools.common.model.XModelObject;
import org.jboss.tools.common.model.filesystems.FileSystemsHelper;
import org.jboss.tools.common.model.plugin.ModelMessages;
import org.jboss.tools.common.model.util.FindObjectHelper;
import org.jboss.tools.jst.web.model.helpers.WebAppHelper;
import org.jboss.tools.jst.web.webapp.model.WebAppConstants;

public class OpenServletHandler
extends AbstractHandler
implements WebAppConstants {
    public boolean isEnabled(XModelObject object) {
        return object != null && object.getAttributeValue("servlet-name") != null && object.getAttributeValue("servlet-name").length() > 0;
    }

    public void executeHandler(XModelObject object, Properties p) throws XModelException {
        if (!this.isEnabled(object)) {
            return;
        }
        XModelObject webxml = FileSystemsHelper.getFile((XModelObject)object);
        if (webxml != null) {
            String servletName = object.getAttributeValue("servlet-name");
            XModelObject servlet = WebAppHelper.findServlet(webxml, null, servletName);
            if (servlet != null) {
                FindObjectHelper.findModelObject((XModelObject)servlet, (int)FindObjectHelper.IN_EDITOR_ONLY);
            } else {
                String message = "Cannot find servlet " + servletName;
                object.getModel().getService().showDialog(ModelMessages.WARNING, message, new String[]{SpecialWizardSupport.CLOSE}, null, 2);
            }
        }
    }
}

