/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.jst.web.tld.model.handlers;

import java.util.Properties;
import org.jboss.tools.common.meta.XAdoptManager;
import org.jboss.tools.common.model.XModelException;
import org.jboss.tools.common.model.XModelObject;
import org.jboss.tools.jst.web.WebModelPlugin;
import org.jboss.tools.jst.web.tld.model.TLDUtil;
import org.jboss.tools.jst.web.tld.model.helpers.TLDToPaletteHelper;

public class JSPAdopt
implements XAdoptManager {
    TLDToPaletteHelper helper = new TLDToPaletteHelper();

    public boolean isAdoptable(XModelObject target, XModelObject object) {
        if (!this.isAcceptableTarget(target)) {
            return false;
        }
        return this.isAdoptableTag(object) || this.isAdoptableAttribute(object) || this.isAdoptableTaglib(object) || this.isAdoptableMacro(object) || this.isAdoptableGroup(object);
    }

    public void adopt(XModelObject target, XModelObject object, Properties p) throws XModelException {
        if (!this.isAcceptableTarget(target)) {
            return;
        }
        if (this.isAdoptableTag(object)) {
            this.adoptTag(target, object, p);
        } else if (this.isAdoptableAttribute(object)) {
            this.adoptAttribute(target, object, p);
        } else if (this.isAdoptableTaglib(object)) {
            this.adoptTaglib(target, object, p);
        } else if (this.isAdoptableMacro(object)) {
            this.adoptMacro(target, object, p);
        } else if (this.isAdoptableGroup(object)) {
            this.adoptGroup(target, object, p);
        }
    }

    private boolean isAcceptableTarget(XModelObject target) {
        String te = target.getModelEntity().getName();
        return te.equals("FileJSP") || te.startsWith("FileHTML") || target.getFileType() == 1;
    }

    protected boolean isAdoptableTaglib(XModelObject object) {
        return TLDUtil.isTaglib(object);
    }

    protected boolean isAdoptableTag(XModelObject object) {
        return TLDUtil.isTag(object);
    }

    protected boolean isAdoptableAttribute(XModelObject object) {
        return TLDUtil.isAttribute(object);
    }

    public void adoptTag(XModelObject target, XModelObject object, Properties p) {
        if (p == null) {
            return;
        }
        XModelObject macro = this.helper.createMacroByTag(object, target.getModel());
        if (macro == null) {
            return;
        }
        p.setProperty("start text", macro.getAttributeValue("start text"));
        p.setProperty("end text", macro.getAttributeValue("end text"));
        p.setProperty("automatically reformat tag body", macro.getAttributeValue("automatically reformat tag body"));
        p.setProperty("library uri", object.getParent().getAttributeValue("uri"));
        p.setProperty("default prefix", TLDToPaletteHelper.getTldName(object.getParent()));
        p.setProperty("tag name", macro.getAttributeValue("name"));
    }

    public void adoptAttribute(XModelObject target, XModelObject object, Properties p) {
        if (p == null) {
            return;
        }
        int c = -1;
        try {
            c = Integer.parseInt(p.getProperty("pos"));
        }
        catch (Exception e) {
            WebModelPlugin.getPluginLog().logError((Throwable)e);
        }
        if (c < 0) {
            return;
        }
        String text = p.getProperty("text");
        String pref = c == 0 || Character.isWhitespace(text.charAt(c - 1)) ? "" : " ";
        String start = String.valueOf(pref) + object.getAttributeValue("name") + "=\"|\"";
        p.setProperty("start text", start);
        char ch = c == text.length() ? (char)'\u0000' : text.charAt(c);
        String end = ch == '\u0000' || Character.isWhitespace(ch) || ch == '/' || ch == '>' ? "" : " ";
        p.setProperty("end text", end);
    }

    public void adoptTaglib(XModelObject target, XModelObject object, Properties p) {
        if (p == null) {
            return;
        }
        String uri = object.getAttributeValue("uri");
        String shortname = object.getAttributeValue("shortname");
        String start = "<%@ taglib uri=\"" + uri + "\" prefix=\"" + shortname + "\" %>";
        String overAttr = p.getProperty("context:attrName");
        if (overAttr != null && (overAttr.equals("xmlns") || overAttr.startsWith("xmlns:"))) {
            start = uri;
        }
        p.setProperty("start text", start);
    }

    boolean isAdoptableMacro(XModelObject target) {
        return target.getModelEntity().getName().startsWith("SharableMacro");
    }

    void adoptMacro(XModelObject target, XModelObject macro, Properties p) {
        String startText = macro.getAttributeValue("start text");
        p.setProperty("start text", startText);
        p.setProperty("end text", macro.getAttributeValue("end text"));
        p.setProperty("automatically reformat tag body", macro.getAttributeValue("automatically reformat tag body"));
        p.setProperty("library uri", macro.getParent().getAttributeValue("library uri"));
        p.setProperty("library version", macro.getParent().getAttributeValue("library version"));
        p.setProperty("default prefix", macro.getParent().getAttributeValue("default prefix"));
        String addTaglib = macro.getParent().getAttributeValue("add taglib");
        if (addTaglib != null) {
            p.setProperty("add taglib", addTaglib);
        }
        String name = macro.getAttributeValue("name");
        p.setProperty("palettePath", macro.getPath());
        if (this.isTagName(startText, name) && !this.isMobile(macro)) {
            p.setProperty("tag name", name);
        }
    }

    private boolean isMobile(XModelObject macro) {
        XModelObject o = macro;
        while (o != null) {
            String kind = o.getAttributeValue("element type");
            String name = o.getAttributeValue("name");
            if ("group".equals(kind) && "Mobile".equals(name)) {
                return true;
            }
            o = o.getParent();
        }
        return false;
    }

    private boolean isTagName(String s, String n) {
        if (n == null || n.length() == 0 || s == null) {
            return false;
        }
        n = n.toLowerCase();
        s = s.toLowerCase();
        int i = 0;
        while (i < n.length()) {
            char c = n.charAt(i);
            if (!Character.isJavaIdentifierPart(c) && c != '.' && c != ':') {
                return false;
            }
            ++i;
        }
        int q = s.indexOf(60);
        if (q < 0) {
            q = s.indexOf("${");
        }
        if (q < 0) {
            return false;
        }
        return s.indexOf(n, q) >= 0;
    }

    boolean isAdoptableGroup(XModelObject target) {
        return target.getModelEntity().getName().startsWith("SharableGroup");
    }

    void adoptGroup(XModelObject target, XModelObject group, Properties p) {
        String uri = group.getAttributeValue("library uri");
        String shortname = group.getAttributeValue("default prefix");
        String start = "<%@ taglib uri=\"" + uri + "\" prefix=\"" + shortname + "\" %>";
        p.setProperty("start text", start);
    }
}

