/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.jst.web.refactoring;

import java.util.Properties;
import org.eclipse.ltk.core.refactoring.CompositeChange;
import org.jboss.tools.common.model.XModelObject;
import org.jboss.tools.common.model.refactoring.RefactoringHelper;
import org.jboss.tools.common.model.util.XModelObjectLoaderUtil;
import org.jboss.tools.jst.web.messages.xpl.WebUIMessages;

public class WebRenameTLDWebAppChange
extends CompositeChange {
    XModelObject object;
    String newName;
    Properties replacements = new Properties();

    public WebRenameTLDWebAppChange(XModelObject object, String newName) {
        super(WebUIMessages.WEBXML_CHANGES);
        this.object = object;
        this.newName = newName;
        this.replacements.clear();
        String oldText = XModelObjectLoaderUtil.getResourcePath((XModelObject)object);
        if (object.getModel().getByPath("FileSystems/WEB-INF" + oldText) == object) {
            oldText = "/WEB-INF" + oldText;
        }
        int i = oldText.lastIndexOf("/");
        String newText = String.valueOf(oldText.substring(0, i + 1)) + newName;
        this.replacements.setProperty(oldText, newText);
        this.addChanges();
    }

    private void addChanges() {
        XModelObject[] xModelObjectArray;
        if (this.object == null) {
            return;
        }
        XModelObject webxml = this.object.getModel().getByPath("/web.xml");
        if (webxml == null) {
            xModelObjectArray = new XModelObject[]{};
        } else {
            XModelObject[] xModelObjectArray2 = new XModelObject[1];
            xModelObjectArray = xModelObjectArray2;
            xModelObjectArray2[0] = webxml;
        }
        XModelObject[] fs = xModelObjectArray;
        this.addChanges(fs);
    }

    private void addChanges(XModelObject[] objects) {
        int i = 0;
        while (i < objects.length) {
            RefactoringHelper.addChanges((XModelObject)objects[i], (Properties)this.replacements, (CompositeChange)this);
            ++i;
        }
    }
}

