/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.jst.web.project.handlers;

import java.util.Properties;
import org.eclipse.osgi.util.NLS;
import org.jboss.tools.common.meta.action.XActionInvoker;
import org.jboss.tools.common.meta.action.impl.DefaultWizardDataValidator;
import org.jboss.tools.common.meta.action.impl.SpecialWizardSupport;
import org.jboss.tools.common.meta.action.impl.WizardDataValidator;
import org.jboss.tools.common.model.XModel;
import org.jboss.tools.common.model.XModelException;
import org.jboss.tools.common.model.XModelObject;
import org.jboss.tools.common.model.options.PreferenceModelUtilities;
import org.jboss.tools.jst.web.messages.xpl.WebUIMessages;
import org.jboss.tools.jst.web.project.helpers.LibrarySets;

public class AddLibrarySetSupport
extends SpecialWizardSupport {
    protected DefaultWizardDataValidator validator = new LibrarySetValidator();
    String FORBIDDEN_INDICES = "\"\n\t*\\/:<>?|";

    public static String run() {
        XModel model = PreferenceModelUtilities.getPreferenceModel();
        String entity = "LibrarySet";
        String actionPath = "CreateActions.CreateLibrarySet";
        Properties p = new Properties();
        XActionInvoker.invoke((String)entity, (String)actionPath, (XModelObject)model.getRoot(), (Properties)p);
        return p.getProperty("name");
    }

    public void action(String name) throws XModelException {
        if (OK.equals(name) || FINISH.equals(name)) {
            this.execute();
            this.setFinished(true);
        } else if (CANCEL.equals(name)) {
            this.setFinished(true);
        }
    }

    protected void execute() throws XModelException {
        String name = this.extractStepData(0).getProperty("name");
        LibrarySets.getInstance().addLibrarySet(name);
        this.getProperties().setProperty("name", name);
    }

    public WizardDataValidator getValidator(int step) {
        this.validator.setSupport((SpecialWizardSupport)this, step);
        return this.validator;
    }

    class LibrarySetValidator
    extends DefaultWizardDataValidator {
        LibrarySetValidator() {
        }

        public void validate(Properties data) {
            this.message = null;
            super.validate(data);
            if (this.message != null) {
                return;
            }
            String name = data.getProperty("name");
            if (LibrarySets.getInstance().getLibrarySet(name) != null) {
                this.message = NLS.bind((String)WebUIMessages.LIBRARY_SET_ALREADY_EXISTS, (Object)name);
            } else if (name.equals(" .")) {
                this.message = WebUIMessages.LIBRARY_SET_NAME_MUST_BE_A_VALID_FOLDERNAME;
            } else if (name.endsWith(".") && name.indexOf(46) != name.lastIndexOf(46)) {
                this.message = WebUIMessages.LIBRARY_SET_NAME_MUST_BE_A_VALID_FOLDER_NAME;
            } else {
                int i = 0;
                while (i < AddLibrarySetSupport.this.FORBIDDEN_INDICES.length()) {
                    if (name.indexOf(AddLibrarySetSupport.this.FORBIDDEN_INDICES.charAt(i)) >= 0) {
                        this.message = NLS.bind((String)WebUIMessages.MUST_NOT_CONTAIN_CHARACTER, (Object)("" + AddLibrarySetSupport.this.FORBIDDEN_INDICES.charAt(i)));
                        return;
                    }
                    ++i;
                }
            }
        }
    }
}

