/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.jst.web.model.helpers;

import org.jboss.tools.common.meta.XModelEntity;
import org.jboss.tools.common.meta.action.impl.handlers.DefaultCreateHandler;
import org.jboss.tools.common.model.XModel;
import org.jboss.tools.common.model.XModelException;
import org.jboss.tools.common.model.XModelObject;
import org.jboss.tools.common.model.util.XModelObjectUtil;

public class WebAppHelper {
    public static String CONTEXT_PARAM_ENTITY = "WebAppContextParam";
    public static String FILTER_ENTITY = "WebAppFilter";
    public static String FILTER_30_ENTITY = "WebAppFilter30";
    public static String FILTER_MAPPING_ENTITY = "WebAppFilterMapping";
    public static String FILTER_MAPPING_24_ENTITY = "WebAppFilterMapping24";
    public static String LISTENER_ENTITY = "WebAppListener";
    public static String LISTENER_24_ENTITY = "WebAppListener24";
    public static String SERVLET_ENTITY = "WebAppServlet";
    public static String SERVLET_30_ENTITY = "WebAppServlet30";
    public static String SERVLET_MAPPING_ENTITY = "WebAppServletMapping";
    public static String TAGLIB_ENTITY = "WebAppTaglib";
    public static String ROLE_ENTITY = "WebAppSecurityRole";
    public static String FILTER_FOLDER = "Filters";
    public static String SERVLET_FOLDER = "Servlets";
    public static String JSP_CONFIG_FOLDER = "JSP Config";
    public static String ROLE_FOLDER = "Security Roles";

    public static XModelObject getWebApp(XModel model) {
        return model.getByPath("/web.xml");
    }

    public static String getServletVersion(XModelObject webxml) {
        if (webxml == null) {
            return "";
        }
        String entity = webxml.getModelEntity().getName();
        if (entity.equals("FileWebApp")) {
            return "2.3";
        }
        if (entity.equals("FileWebApp24")) {
            return "2.4";
        }
        if (entity.equals("FileWebApp25")) {
            return "2.5";
        }
        if (entity.equals("FileWebApp30")) {
            return "3.0";
        }
        return "2.4";
    }

    public static XModelObject getParentFile(XModelObject o) {
        while (o != null && o.getFileType() != 1) {
            o = o.getParent();
        }
        return o;
    }

    public static XModelObject[] getServlets(XModelObject webxml) {
        if (webxml == null) {
            return null;
        }
        XModelObject folder = webxml.getChildByPath(SERVLET_FOLDER);
        if (folder == null) {
            folder = webxml;
        }
        return folder.getChildren(WebAppHelper.getServletEntity(folder.getModelEntity()));
    }

    public static XModelObject[] getServletMappings(XModelObject webxml) {
        if (webxml == null) {
            return null;
        }
        XModelObject folder = webxml.getChildByPath(SERVLET_FOLDER);
        if (folder == null) {
            folder = webxml;
        }
        return folder.getChildren(SERVLET_MAPPING_ENTITY);
    }

    public static XModelObject findServlet(XModelObject webxml, String className, String servletName) {
        if (webxml == null) {
            return null;
        }
        XModelObject[] s = WebAppHelper.getServlets(webxml);
        int i = 0;
        while (i < s.length) {
            if (className != null && className.equals(s[i].getAttributeValue("servlet-class"))) {
                return s[i];
            }
            if (servletName != null && servletName.equals(s[i].getAttributeValue("servlet-name"))) {
                return s[i];
            }
            ++i;
        }
        return null;
    }

    public static XModelObject findOrCreateServlet(XModelObject webxml, String className, String servletName, int loadOnStartUp) throws XModelException {
        if (webxml == null) {
            return null;
        }
        XModelObject s = WebAppHelper.findServlet(webxml, className, servletName);
        if (s == null) {
            XModelObject folder = webxml.getChildByPath(SERVLET_FOLDER);
            if (folder == null) {
                folder = webxml;
            }
            s = webxml.getModel().createModelObject(WebAppHelper.getServletEntity(folder.getModelEntity()), null);
            s.setAttributeValue("servlet-name", servletName);
            s.setAttributeValue("servlet-class", className);
            DefaultCreateHandler.addCreatedObject((XModelObject)folder, (XModelObject)s, (int)-1);
        }
        if (loadOnStartUp >= 0 && s.getAttributeValue("load-on-startup").length() == 0) {
            s.getModel().changeObjectAttribute(s, "load-on-startup", "" + loadOnStartUp);
        }
        return s;
    }

    public static String getServletEntity(XModelEntity folder) {
        if (folder != null && folder.getChild(SERVLET_30_ENTITY) != null) {
            return SERVLET_30_ENTITY;
        }
        return SERVLET_ENTITY;
    }

    public static XModelObject findServletMapping(XModelObject webxml, String servletName) {
        if (webxml == null) {
            return null;
        }
        XModelObject[] s = WebAppHelper.getServletMappings(webxml);
        int i = 0;
        while (i < s.length) {
            if (servletName != null && servletName.equals(s[i].getAttributeValue("servlet-name"))) {
                return s[i];
            }
            ++i;
        }
        return null;
    }

    public static XModelObject findOrCreateServletMapping(XModelObject webxml, String servletName) throws XModelException {
        if (webxml == null) {
            return null;
        }
        XModelObject s = WebAppHelper.findServletMapping(webxml, servletName);
        if (s == null) {
            XModelObject folder = webxml.getChildByPath(SERVLET_FOLDER);
            if (folder == null) {
                folder = webxml;
            }
            s = webxml.getModel().createModelObject(SERVLET_MAPPING_ENTITY, null);
            s.setAttributeValue("servlet-name", servletName);
            s.setAttributeValue("url-pattern", "*.jsf");
            DefaultCreateHandler.addCreatedObject((XModelObject)folder, (XModelObject)s, (int)-1);
        }
        return s;
    }

    public static XModelObject findWebAppInitParam(XModelObject servlet, String name) {
        if (servlet == null) {
            return null;
        }
        XModelObject[] init = servlet.getChildren("WebAppInitParam");
        int i = 0;
        while (i < init.length) {
            String n = init[i].getAttributeValue("param-name");
            if (n != null && n.equals(name)) {
                return init[i];
            }
            ++i;
        }
        return null;
    }

    public static XModelObject setWebAppInitParam(XModelObject servlet, String name, String value) throws XModelException {
        if (servlet == null) {
            return null;
        }
        XModelObject p = WebAppHelper.findWebAppInitParam(servlet, name);
        if (p == null) {
            p = WebAppHelper.createWebAppInitParam(servlet, name, value);
        } else {
            servlet.getModel().changeObjectAttribute(p, "param-value", value);
        }
        return p;
    }

    public static XModelObject appendToWebAppInitParam(XModelObject servlet, String name, String valuePart) throws XModelException {
        if (servlet == null) {
            return null;
        }
        XModelObject p = WebAppHelper.findWebAppInitParam(servlet, name);
        if (p == null) {
            p = WebAppHelper.createWebAppInitParam(servlet, name, valuePart);
        } else {
            String oldValue = p.getAttributeValue("param-value");
            if (oldValue.length() == 0 || ("," + oldValue + ",").indexOf("," + valuePart + ",") < 0) {
                String newValue = oldValue.length() > 0 ? String.valueOf(oldValue) + "," + valuePart : valuePart;
                servlet.getModel().changeObjectAttribute(p, "param-value", newValue);
            }
        }
        return p;
    }

    private static XModelObject createWebAppInitParam(XModelObject servlet, String name, String value) throws XModelException {
        if (servlet == null) {
            return null;
        }
        XModelObject p = servlet.getModel().createModelObject("WebAppInitParam", null);
        p.setAttributeValue("param-name", name);
        p.setAttributeValue("param-value", value);
        DefaultCreateHandler.addCreatedObject((XModelObject)servlet, (XModelObject)p, (int)-1);
        return p;
    }

    public static String[] getWebAppInitParamValueList(XModelObject servlet, String name) {
        if (servlet == null) {
            return new String[0];
        }
        XModelObject p = WebAppHelper.findWebAppInitParam(servlet, name);
        if (p == null) {
            return new String[0];
        }
        return XModelObjectUtil.asStringArray((String)p.getAttributeValue("param-value"));
    }

    public static XModelObject findWebAppContextParam(XModelObject webxml, String name) {
        if (webxml == null) {
            return null;
        }
        XModelObject folder = webxml.getChildByPath("Context Params");
        if (folder == null) {
            folder = webxml;
        }
        return folder.getChildByPath(name);
    }

    public static XModelObject setWebAppContextParam(XModelObject webxml, String name, String value) throws XModelException {
        if (webxml == null) {
            return null;
        }
        XModelObject p = WebAppHelper.findWebAppContextParam(webxml, name);
        if (p == null) {
            p = WebAppHelper.createWebAppContextParam(webxml, name, value);
        } else {
            webxml.getModel().changeObjectAttribute(p, "param-value", value);
        }
        return p;
    }

    public static XModelObject appendToWebAppContextParam(XModelObject webxml, String name, String valuePart) throws XModelException {
        if (webxml == null) {
            return null;
        }
        XModelObject p = WebAppHelper.findWebAppContextParam(webxml, name);
        if (p == null) {
            p = WebAppHelper.createWebAppContextParam(webxml, name, valuePart);
        } else {
            String oldValue = p.getAttributeValue("param-value");
            if (oldValue.length() == 0 || ("," + oldValue + ",").indexOf("," + valuePart + ",") < 0) {
                String newValue = oldValue.length() > 0 ? String.valueOf(oldValue) + "," + valuePart : valuePart;
                webxml.getModel().changeObjectAttribute(p, "param-value", newValue);
            }
        }
        return p;
    }

    private static XModelObject createWebAppContextParam(XModelObject webxml, String name, String value) throws XModelException {
        if (webxml == null) {
            return null;
        }
        XModelObject folder = webxml.getChildByPath("Context Params");
        if (folder == null) {
            folder = webxml;
        }
        XModelObject p = folder.getModel().createModelObject(CONTEXT_PARAM_ENTITY, null);
        p.setAttributeValue("param-name", name);
        p.setAttributeValue("param-value", value);
        DefaultCreateHandler.addCreatedObject((XModelObject)folder, (XModelObject)p, (int)-1);
        return p;
    }

    public static String[] getWebAppContextParamValueList(XModelObject webxml, String name) {
        if (webxml == null) {
            return new String[0];
        }
        XModelObject p = WebAppHelper.findWebAppContextParam(webxml, name);
        if (p == null) {
            return new String[0];
        }
        return XModelObjectUtil.asStringArray((String)p.getAttributeValue("param-value"));
    }

    public static XModelObject[] getFilters(XModelObject webxml) {
        if (webxml == null) {
            return null;
        }
        XModelObject folder = webxml.getChildByPath(FILTER_FOLDER);
        if (folder == null) {
            folder = webxml;
        }
        if (folder.getModelEntity().getChild(FILTER_30_ENTITY) != null) {
            return folder.getChildren(FILTER_30_ENTITY);
        }
        return folder.getChildren(FILTER_ENTITY);
    }

    public static XModelObject[] getFilterMappings(XModelObject webxml) {
        if (webxml == null) {
            return null;
        }
        XModelObject folder = webxml.getChildByPath(FILTER_FOLDER);
        if (folder == null) {
            folder = webxml;
        }
        String entity = folder.getModelEntity().getChild(FILTER_MAPPING_24_ENTITY) != null ? FILTER_MAPPING_24_ENTITY : FILTER_MAPPING_ENTITY;
        return folder.getChildren(entity);
    }

    public static XModelObject findFilterByClass(XModelObject webxml, String cls) {
        XModelObject[] os = WebAppHelper.getFilters(webxml);
        int i = 0;
        while (i < os.length) {
            String c = os[i].getAttributeValue("filter-class");
            if (cls.equals(c)) {
                return os[i];
            }
            ++i;
        }
        return null;
    }

    public static XModelObject findFilter(XModelObject webxml, String filterName) {
        XModelObject[] os = WebAppHelper.getFilters(webxml);
        int i = 0;
        while (i < os.length) {
            String c = os[i].getAttributeValue("filter-name");
            if (filterName.equals(c)) {
                return os[i];
            }
            ++i;
        }
        return null;
    }

    public static XModelObject findFilterMapping(XModelObject webxml, String name) {
        XModelObject folder = webxml.getChildByPath(FILTER_FOLDER);
        if (folder == null) {
            folder = webxml;
        }
        String entity = folder != webxml && folder.getModelEntity().getName().endsWith("24") ? FILTER_MAPPING_24_ENTITY : FILTER_MAPPING_ENTITY;
        XModelObject[] os = folder.getChildren(entity);
        int i = 0;
        while (i < os.length) {
            String c = os[i].getAttributeValue("filter-name");
            if (name.equals(c)) {
                return os[i];
            }
            ++i;
        }
        return null;
    }

    public static XModelObject getJSPConfig(XModelObject webxml) {
        if (webxml == null) {
            return null;
        }
        XModelObject folder = webxml.getChildByPath("JSP Config");
        return folder != null ? folder : webxml;
    }

    public static XModelObject[] getTaglibs(XModelObject webxml) {
        if (webxml == null) {
            return null;
        }
        XModelObject folder = webxml.getChildByPath("JSP Config");
        if (folder == null) {
            folder = webxml;
        }
        return folder.getChildren(TAGLIB_ENTITY);
    }

    public static XModelObject[] getRoles(XModelObject webxml) {
        XModelObject folder = webxml.getChildByPath(ROLE_FOLDER);
        if (folder == null) {
            folder = webxml;
        }
        return folder.getChildren(ROLE_ENTITY);
    }

    public static XModelObject findRole(XModelObject webxml, String name) {
        XModelObject[] cs = WebAppHelper.getRoles(webxml);
        int i = 0;
        while (i < cs.length) {
            if (name.equals(cs[i].getAttributeValue("role-name"))) {
                return cs[i];
            }
            ++i;
        }
        return null;
    }
}

