/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.jst.web.browser;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.jboss.tools.common.model.XModelObject;
import org.jboss.tools.common.model.util.XModelObjectCache;
import org.jboss.tools.jst.web.browser.IBrowserContext;

public class BrowserHistory {
    IBrowserContext context;
    int size = 5;
    ArrayList<String> items = new ArrayList();
    Map<String, XModelObjectCache> map = new HashMap<String, XModelObjectCache>();
    Set<String> justUrls = new HashSet<String>();

    public BrowserHistory(IBrowserContext context) {
        this.context = context;
    }

    public void add(XModelObject o, String url) {
        this.validate();
        if (o == null || url == null) {
            return;
        }
        if (this.items.indexOf(url) >= 0) {
            this.items.remove(url);
        }
        this.items.add(0, url);
        this.map.put(url, new XModelObjectCache(o));
        while (this.items.size() > this.size) {
            String s = this.items.remove(this.size);
            if (s == null) continue;
            this.map.remove(s);
        }
    }

    public void add(String url) {
        if (this.items.indexOf(url) >= 0) {
            this.items.remove(url);
        }
        this.items.add(0, url);
        this.justUrls.add(url);
        this.map.remove(url);
    }

    public boolean isJustUrl(String url) {
        return this.justUrls.contains(url);
    }

    public XModelObject getRunObject(String url) {
        XModelObjectCache c = this.map.get(url);
        return c == null ? null : c.getObject();
    }

    public String[] items() {
        this.validate();
        if (this.items.size() < 1) {
            return new String[0];
        }
        ArrayList<String> l = new ArrayList<String>();
        int i = 0;
        while (i < this.items.size()) {
            String url = this.items.get(i).toString();
            if (!url.equals(this.context.getLastRunURL())) {
                l.add(url);
            }
            ++i;
        }
        return l.toArray(new String[0]);
    }

    public String[] getAllItems() {
        this.validate();
        return this.items.toArray(new String[0]);
    }

    void validate() {
        HashSet<String> urls = new HashSet<String>();
        int i = this.items.size() - 1;
        while (i >= 0) {
            String s = this.items.get(i).toString();
            if (!this.isJustUrl(s)) {
                XModelObject o = this.getRunObject(s);
                String p = this.context.computeURL(o);
                if (p == null || urls.contains(p) || p.startsWith("%server%")) {
                    this.items.remove(i);
                    this.map.remove(s);
                } else if (!s.equals(p)) {
                    this.items.set(i, p);
                    this.map.put(p, this.map.remove(s));
                }
                urls.add(p);
            }
            --i;
        }
    }
}

