/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.cdi.ui.wizard;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Properties;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.dialogs.WizardNewFileCreationPage;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.internal.dialogs.DialogUtil;
import org.eclipse.ui.internal.ide.IDEWorkbenchPlugin;
import org.eclipse.ui.internal.ide.misc.ContainerSelectionGroup;
import org.eclipse.ui.internal.ide.misc.ResourceAndContainerGroup;
import org.eclipse.ui.internal.wizards.newresource.ResourceMessages;
import org.eclipse.ui.wizards.newresource.BasicNewResourceWizard;
import org.jboss.tools.cdi.core.CDICorePlugin;
import org.jboss.tools.cdi.core.CDIImages;
import org.jboss.tools.cdi.core.CDIVersion;
import org.jboss.tools.cdi.ui.CDIUIMessages;
import org.jboss.tools.cdi.ui.CDIUIPlugin;
import org.jboss.tools.common.model.filesystems.impl.FileAnyImpl;
import org.jboss.tools.common.model.options.PreferenceModelUtilities;
import org.jboss.tools.common.model.project.ProjectHome;
import org.jboss.tools.common.model.util.EclipseResourceUtil;
import org.jboss.tools.common.ui.widget.editor.IFieldEditor;
import org.jboss.tools.common.ui.widget.editor.SwtFieldEditorFactory;

public class NewBeansXMLCreationWizard
extends BasicNewResourceWizard {
    public static final String WIZARD_ID = "org.jboss.tools.cdi.ui.wizard.NewBeansXMLCreationWizard";
    private WizardNewBeansXMLFileCreationPage mainPage;
    private boolean fOpenEditorOnFinish = true;

    public void setVersion(CDIVersion version) {
        this.mainPage.versionEditor.setValue((Object)version.toString());
    }

    public String getVersion() {
        return this.mainPage.versionEditor.getValueAsString();
    }

    public void addPages() {
        super.addPages();
        this.mainPage = new WizardNewBeansXMLFileCreationPage("newFilePage1", this.getSelection());
        this.mainPage.setTitle(CDIUIMessages.NEW_BEANS_XML_WIZARD_PAGE_NAME);
        this.mainPage.setDescription(CDIUIMessages.NEW_BEANS_XML_WIZARD_DESCRIPTION);
        this.mainPage.setImageDescriptor(CDIImages.getImageDescriptor((String)"wizard/CDIBeansXMLWizBan.png"));
        this.mainPage.setFileName("beans.xml");
        this.addPage((IWizardPage)this.mainPage);
    }

    public void init(IWorkbench workbench, IStructuredSelection currentSelection) {
        super.init(workbench, currentSelection);
        this.setWindowTitle(CDIUIMessages.NEW_BEANS_XML_WIZARD_TITLE);
        this.setNeedsProgressMonitor(true);
    }

    protected void initializeDefaultPageImageDescriptor() {
        ImageDescriptor desc = IDEWorkbenchPlugin.getIDEImageDescriptor((String)"wizban/newfile_wiz.png");
        this.setDefaultPageImageDescriptor(desc);
    }

    public boolean isOpenEditorAfterFinish() {
        return this.fOpenEditorOnFinish;
    }

    public void setOpenEditorAfterFinish(boolean set) {
        this.fOpenEditorOnFinish = set;
    }

    public boolean performFinish() {
        IFile file = this.mainPage.createNewFile();
        if (file == null) {
            return false;
        }
        this.selectAndReveal((IResource)file);
        if (this.fOpenEditorOnFinish) {
            IWorkbenchWindow dw = this.getWorkbench().getActiveWorkbenchWindow();
            try {
                IWorkbenchPage page;
                if (dw != null && (page = dw.getActivePage()) != null) {
                    IDE.openEditor((IWorkbenchPage)page, (IFile)file, (boolean)true);
                }
            }
            catch (PartInitException e) {
                DialogUtil.openError((Shell)dw.getShell(), (String)ResourceMessages.FileResource_errorMessage, (String)e.getMessage(), (PartInitException)e);
            }
        }
        return true;
    }

    public static IPath getContainerForBeansXML(IProject p) {
        IPath path = ProjectHome.getWebInfPath((IProject)p);
        if (path == null) {
            boolean needMetaInf = false;
            Set fs = EclipseResourceUtil.getSourceFolders((IProject)p);
            for (IFolder f : fs) {
                IFolder fm = f.getFolder("META-INF");
                IPath pth = fm.getFullPath();
                if (path == null) {
                    path = pth;
                    needMetaInf = !fm.exists();
                    continue;
                }
                if (!needMetaInf || !fm.exists()) continue;
                path = pth;
                needMetaInf = false;
            }
        }
        return path;
    }

    public static IPath getContainerWithExistingBeansXML(IProject p) {
        IFile f;
        IPath path = ProjectHome.getWebInfPath((IProject)p);
        if (path != null && (f = p.getParent().getFile(path.append("beans.xml"))).exists()) {
            return path;
        }
        Set fs = EclipseResourceUtil.getSourceFolders((IProject)p);
        for (IFolder f2 : fs) {
            IFolder fm = f2.getFolder("META-INF");
            if (!fm.exists() || !fm.getFile("beans.xml").exists()) continue;
            return fm.getFullPath();
        }
        return null;
    }

    class WizardNewBeansXMLFileCreationPage
    extends WizardNewFileCreationPage {
        IFieldEditor versionEditor;

        public WizardNewBeansXMLFileCreationPage(String pageName, IStructuredSelection selection) {
            super(pageName, selection);
            this.versionEditor = null;
        }

        public void createControl(Composite parent) {
            super.createControl(parent);
            this.validatePage();
        }

        protected void initialPopulateContainerNameField() {
            super.initialPopulateContainerNameField();
            if (!NewBeansXMLCreationWizard.this.selection.isEmpty() && NewBeansXMLCreationWizard.this.selection instanceof IStructuredSelection) {
                Object o = NewBeansXMLCreationWizard.this.selection.getFirstElement();
                IResource r = null;
                if (o instanceof IResource) {
                    r = (IResource)o;
                } else if (o instanceof IAdaptable) {
                    r = (IResource)((IAdaptable)o).getAdapter(IResource.class);
                }
                if (r != null) {
                    boolean needMetaInf = false;
                    IPath current = this.getContainerFullPath();
                    IProject p = r.getProject();
                    IPath path = NewBeansXMLCreationWizard.getContainerWithExistingBeansXML(p);
                    if (path == null) {
                        path = ProjectHome.getWebInfPath((IProject)p);
                    }
                    if (current != null && current.equals((Object)path)) {
                        return;
                    }
                    if (path == null) {
                        Set fs = EclipseResourceUtil.getSourceFolders((IProject)p);
                        for (IFolder f : fs) {
                            IPath pth;
                            IFolder fm = f.getFolder("META-INF");
                            if (!fm.exists()) {
                                needMetaInf = true;
                                fm = f;
                            }
                            if ((pth = fm.getFullPath()).equals((Object)current) && !needMetaInf) {
                                return;
                            }
                            if (path != null && !pth.equals((Object)current)) continue;
                            path = pth;
                        }
                    }
                    if (path != null) {
                        this.setContainerFullPath(path);
                        if (needMetaInf) {
                            String value = path.append("META-INF").toString();
                            try {
                                this.setContainerValue(value);
                            }
                            catch (NoSuchFieldException e) {
                                CDIUIPlugin.getDefault().logError(e);
                            }
                            catch (IllegalAccessException e) {
                                CDIUIPlugin.getDefault().logError(e);
                            }
                        }
                    }
                }
            }
        }

        void setContainerValue(String value) throws NoSuchFieldException, IllegalAccessException {
            Field f = WizardNewFileCreationPage.class.getDeclaredField("resourceGroup");
            f.setAccessible(true);
            ResourceAndContainerGroup resourceGroup = (ResourceAndContainerGroup)f.get((Object)this);
            Field f2 = ResourceAndContainerGroup.class.getDeclaredField("containerGroup");
            f2.setAccessible(true);
            ContainerSelectionGroup containerGroup = (ContainerSelectionGroup)f2.get(resourceGroup);
            Field f3 = ContainerSelectionGroup.class.getDeclaredField("containerNameField");
            f3.setAccessible(true);
            Text text = (Text)f3.get(containerGroup);
            text.setText(value);
        }

        protected InputStream getInitialContents() {
            FileAnyImpl file = (FileAnyImpl)PreferenceModelUtilities.getPreferenceModel().createModelObject(this.getEntityName(), new Properties());
            return new ByteArrayInputStream(file.getAsText().getBytes());
        }

        String getEntityName() {
            String versionName = this.versionEditor.getValueAsString();
            if (versionName.equals(CDIVersion.CDI_1_0.toString())) {
                return "FileCDIBeans";
            }
            String expectedEntityName = "FileCDIBeans";
            int i = 0;
            while (i < versionName.length()) {
                char c = versionName.charAt(i);
                if (Character.isDigit(c)) {
                    expectedEntityName = String.valueOf(expectedEntityName) + c;
                }
                ++i;
            }
            if (PreferenceModelUtilities.getPreferenceModel().getMetaData().getEntity(expectedEntityName) != null) {
                return expectedEntityName;
            }
            String lastEntity = "FileCDIBeans";
            int lastVersion = 0;
            String[] stringArray = PreferenceModelUtilities.getPreferenceModel().getMetaData().entities();
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String suff;
                int vi;
                String e = stringArray[n2];
                if (e.startsWith("FileCDIBeans") && Character.isDigit(e.charAt(e.length() - 1)) && (vi = Integer.parseInt(suff = e.substring("FileCDIBeans".length()))) > lastVersion) {
                    lastEntity = e;
                    lastVersion = vi;
                }
                ++n2;
            }
            return lastEntity;
        }

        protected IStatus validateLinkedResource() {
            return Status.OK_STATUS;
        }

        protected void createLinkTarget() {
        }

        protected void createAdvancedControls(Composite parent) {
            Label separator = new Label(parent, 258);
            GridData sd = new GridData(768);
            separator.setLayoutData((Object)sd);
            ArrayList<String> versions = new ArrayList<String>();
            CDIVersion[] cDIVersionArray = CDIVersion.ALL_VERSIONS;
            int n = CDIVersion.ALL_VERSIONS.length;
            int n2 = 0;
            while (n2 < n) {
                CDIVersion v = cDIVersionArray[n2];
                versions.add(v.toString());
                ++n2;
            }
            this.versionEditor = SwtFieldEditorFactory.INSTANCE.createComboEditor("version", CDIUIMessages.VERSION_LABEL, versions, (Object)this.getInitialCDIVersion(), false, "");
            Composite c = new Composite(parent, 0);
            c.setLayoutData((Object)new GridData(768));
            GridLayout gl = new GridLayout(3, false);
            gl.marginWidth = 5;
            gl.marginHeight = 5;
            gl.verticalSpacing = 0;
            gl.horizontalSpacing = 5;
            c.setLayout((Layout)gl);
            this.versionEditor.doFillIntoGrid((Object)c);
        }

        String getInitialCDIVersion() {
            CDIVersion v;
            IProject p;
            IPath path = this.getContainerFullPath();
            if (path != null && (p = ResourcesPlugin.getWorkspace().getRoot().getProject(path.segment(0))) != null && CDICorePlugin.getCDI((IProject)p, (boolean)false) != null && (v = CDICorePlugin.getCDI((IProject)p, (boolean)true).getVersion()) != null) {
                return v.toString();
            }
            return CDIVersion.getLatestDefaultVersion().toString();
        }
    }
}

