/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.common.text.ext.util;

import java.util.StringTokenizer;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.Region;
import org.eclipse.wst.sse.core.internal.provisional.IndexedRegion;
import org.eclipse.wst.xml.core.internal.document.AttrImpl;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMAttr;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMNode;
import org.jboss.tools.common.text.ext.ExtensionsPlugin;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class Utils {
    public static String trimQuotes(String word) {
        if (word == null) {
            return null;
        }
        String attrText = word;
        int bStart = 0;
        int bEnd = word.length() - 1;
        StringBuffer sb = new StringBuffer(attrText);
        while (bStart < bEnd && (sb.charAt(bStart) == '\'' || sb.charAt(bStart) == '\"' || Character.isWhitespace(sb.charAt(bStart)))) {
            ++bStart;
        }
        while (bEnd >= 0 && (sb.charAt(bEnd) == '\'' || sb.charAt(bEnd) == '\"' || Character.isWhitespace(sb.charAt(bEnd)))) {
            --bEnd;
        }
        if (++bEnd < bStart) {
            bEnd = bStart;
        }
        return sb.substring(bStart, bEnd);
    }

    public static Node findNodeForOffset(Node node, int offset) {
        return node instanceof IDOMNode ? Utils.findNodeForOffset((IDOMNode)node, offset) : null;
    }

    public static Node findNodeForOffset(IDOMNode node, int offset) {
        if (node == null) {
            return null;
        }
        if (!node.contains(offset)) {
            return null;
        }
        NodeList children = node.getChildNodes();
        int i = 0;
        while (i < children.getLength()) {
            IDOMNode child = (IDOMNode)children.item(i);
            if (child.contains(offset)) {
                return Utils.findNodeForOffset(child, offset);
            }
            ++i;
        }
        if (node.hasAttributes()) {
            NamedNodeMap attributes = node.getAttributes();
            int i2 = 0;
            while (i2 < attributes.getLength()) {
                IDOMNode attr = (IDOMNode)attributes.item(i2);
                if (attr.contains(offset)) {
                    return attr;
                }
                ++i2;
            }
        }
        return node;
    }

    public static String getParentAxisForNode(Document xmlDocument, Node node) {
        String axis = "";
        if (node == null) {
            return null;
        }
        Node parent = node instanceof Attr ? ((Attr)node).getOwnerElement() : node.getParentNode();
        while (parent instanceof Element) {
            String nodeName = parent.getNodeName();
            axis = "/" + nodeName + axis;
            parent = parent.getParentNode();
        }
        if (axis == null || axis.length() == 0) {
            axis = null;
        }
        return String.valueOf(axis) + "/";
    }

    public static String trimFilePath(String name) {
        if (name == null) {
            return null;
        }
        StringTokenizer st = new StringTokenizer(name.replace('\\', '/'), "/");
        String result = "";
        while (st.hasMoreTokens()) {
            String token = st.nextToken();
            if (".".equals(token)) continue;
            result = String.valueOf(result) + (result.length() == 0 ? token : "/" + token);
        }
        if (name.startsWith("/")) {
            result = "/" + result;
        }
        return result;
    }

    public static IPath getRelativePath(IPath base, IPath path) {
        Path relativePath = new Path("/");
        String last = path.lastSegment();
        IPath absolutePath = path.removeLastSegments(1);
        while (base.isPrefixOf(absolutePath)) {
            relativePath = new Path(last).append((IPath)relativePath);
            last = absolutePath.lastSegment();
            absolutePath = absolutePath.removeLastSegments(1);
        }
        return relativePath;
    }

    public static String getTrimmedValue(IDocument document, Attr attr) throws BadLocationException {
        if (!(attr instanceof IDOMAttr)) {
            return null;
        }
        IDOMAttr domAttr = (IDOMAttr)attr;
        return Utils.trimQuotes(document.get(domAttr.getValueRegionStartOffset(), domAttr.getEndOffset() - domAttr.getValueRegionStartOffset()));
    }

    public static IRegion getAttributeValueRegion(IDocument document, Attr attr) throws BadLocationException {
        if (!(attr instanceof IDOMAttr)) {
            return null;
        }
        IDOMAttr domAttr = (IDOMAttr)attr;
        String attrText = document.get(domAttr.getValueRegionStartOffset(), domAttr.getEndOffset() - domAttr.getValueRegionStartOffset());
        int bStart = 0;
        int bEnd = attrText.length() - 1;
        StringBuffer sb = new StringBuffer(attrText);
        while (bStart < bEnd && (sb.charAt(bStart) == '\'' || sb.charAt(bStart) == '\"' || Character.isWhitespace(sb.charAt(bStart)))) {
            ++bStart;
        }
        while (bEnd >= 0 && (sb.charAt(bEnd) == '\'' || sb.charAt(bEnd) == '\"' || Character.isWhitespace(sb.charAt(bEnd)))) {
            --bEnd;
        }
        if (++bEnd < bStart) {
            bEnd = bStart;
        }
        return new Region(domAttr.getValueRegionStartOffset() + bStart, bEnd - bStart);
    }

    public static String getAttributeValue(IDocument document, Node node, String attrName) {
        if (node == null || attrName == null || node.getAttributes() == null) {
            return null;
        }
        Attr attr = (Attr)node.getAttributes().getNamedItem(attrName);
        try {
            return Utils.getTrimmedValue(document, attr);
        }
        catch (BadLocationException x) {
            ExtensionsPlugin.getPluginLog().logError((Throwable)x);
            return null;
        }
    }

    public static int getValueStart(Node n) {
        return n instanceof IDOMAttr ? ((IDOMAttr)n).getValueRegionStartOffset() : (n instanceof IndexedRegion ? ((IndexedRegion)n).getStartOffset() : -1);
    }

    public static int getValueEnd(Node n) {
        return n instanceof IndexedRegion ? ((IndexedRegion)n).getEndOffset() : -1;
    }

    public static AttrNodePair findAttrNodePairForOffset(Node node, int offset) {
        return node instanceof IDOMNode ? Utils.findAttrNodePairForOffset((IDOMNode)node, offset) : null;
    }

    public static AttrNodePair findAttrNodePairForOffset(IDOMNode node, int offset) {
        if (node == null) {
            return null;
        }
        if (!node.contains(offset)) {
            return null;
        }
        NodeList children = node.getChildNodes();
        int i = 0;
        while (i < children.getLength()) {
            IDOMNode child = (IDOMNode)children.item(i);
            if (child.contains(offset)) {
                return Utils.findAttrNodePairForOffset(child, offset);
            }
            ++i;
        }
        if (node.hasAttributes()) {
            NamedNodeMap attributes = node.getAttributes();
            int i2 = 0;
            while (i2 < attributes.getLength()) {
                IDOMNode attr = (IDOMNode)attributes.item(i2);
                if (attr.contains(offset) && attr instanceof AttrImpl) {
                    return new AttrNodePair(node, (AttrImpl)attr);
                }
                ++i2;
            }
        }
        return new AttrNodePair(node, null);
    }

    public static class AttrNodePair {
        AttrImpl attribute;
        IDOMNode node;

        public AttrNodePair(IDOMNode node, AttrImpl attribute) {
            this.attribute = attribute;
            this.node = node;
        }

        public IDOMNode getNode() {
            return this.node;
        }

        public AttrImpl getAttribute() {
            return this.attribute;
        }
    }
}

