/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.common.text.ext.hyperlink;

import java.util.Arrays;
import java.util.Comparator;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.internal.core.JarEntryFile;
import org.eclipse.jdt.internal.ui.javaeditor.JarEntryEditorInput;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.hyperlink.IHyperlink;
import org.eclipse.ui.IEditorInput;
import org.eclipse.wst.common.componentcore.internal.ComponentResource;
import org.eclipse.wst.common.componentcore.internal.StructureEdit;
import org.eclipse.wst.common.componentcore.internal.WorkbenchComponent;
import org.eclipse.wst.sse.core.internal.provisional.IStructuredModel;
import org.jboss.tools.common.el.core.GlobalELReferenceList;
import org.jboss.tools.common.model.XModel;
import org.jboss.tools.common.model.XModelObject;
import org.jboss.tools.common.model.project.IModelNature;
import org.jboss.tools.common.model.util.EclipseResourceUtil;
import org.jboss.tools.common.resref.core.ResourceReference;
import org.jboss.tools.common.text.ext.hyperlink.xpl.AbstractBaseHyperlink;
import org.jboss.tools.common.text.ext.util.StructuredModelWrapper;
import org.jboss.tools.common.text.ext.util.Utils;

public abstract class AbstractHyperlink
extends AbstractBaseHyperlink
implements IHyperlink {
    public static final String DOLLAR_PREFIX = "${";
    private static final String SUFFIX = "}";
    public static final String SHARP_PREFIX = "#{";

    public static XModel getXModel(IFile file) {
        if (file == null) {
            return null;
        }
        XModelObject fs = EclipseResourceUtil.getObjectByResource((IResource)file);
        if (fs != null) {
            return fs.getModel();
        }
        fs = EclipseResourceUtil.createObjectForResource((IResource)file);
        if (fs != null) {
            return fs.getModel();
        }
        IProject project = file.getProject();
        IModelNature nature = EclipseResourceUtil.getModelNature((IProject)project);
        return nature == null ? null : nature.getModel();
    }

    protected IFile getFile() {
        StructuredModelWrapper smw = new StructuredModelWrapper();
        try {
            smw.init(this.getDocument());
            IFile iFile = smw.getFile();
            return iFile;
        }
        finally {
            smw.dispose();
        }
    }

    protected String getBaseLocation() {
        StructuredModelWrapper smw = new StructuredModelWrapper();
        try {
            smw.init(this.getDocument());
            String string = smw.getBaseLocation();
            return string;
        }
        finally {
            smw.dispose();
        }
    }

    protected XModel getXModel() {
        StructuredModelWrapper smw = new StructuredModelWrapper();
        try {
            smw.init(this.getDocument());
            XModel xModel = smw.getXModel();
            return xModel;
        }
        finally {
            smw.dispose();
        }
    }

    public static XModel getXModel(IStructuredModel structuredModel) {
        IFile f = AbstractHyperlink.getFile(structuredModel);
        if (f != null) {
            return AbstractHyperlink.getXModel(f);
        }
        if (structuredModel == null) {
            return null;
        }
        String wsRelativePath = structuredModel.getBaseLocation();
        if (wsRelativePath == null) {
            return null;
        }
        if (wsRelativePath.startsWith("/")) {
            XModelObject o;
            Path path;
            IResource r;
            do {
                int i;
                if ((i = wsRelativePath.lastIndexOf(47)) < 0) {
                    return null;
                }
                wsRelativePath = wsRelativePath.substring(0, i);
                path = new Path(wsRelativePath);
            } while ((r = ResourcesPlugin.getWorkspace().getRoot().findMember((IPath)path)) == null || !r.exists() || (o = EclipseResourceUtil.createObjectForResource((IResource)r)) == null);
            return o.getModel();
        }
        return null;
    }

    public static String getBaseLocation(IStructuredModel structuredModel) {
        if (structuredModel == null) {
            return null;
        }
        return structuredModel.getBaseLocation();
    }

    public static IFile getFile(IStructuredModel structuredModel) {
        Object path;
        if (structuredModel == null) {
            return null;
        }
        String wsRelativePath = structuredModel.getBaseLocation();
        if (wsRelativePath == null) {
            return null;
        }
        if (wsRelativePath.startsWith("/")) {
            path = new Path(wsRelativePath);
            IResource r = ResourcesPlugin.getWorkspace().getRoot().findMember((IPath)path);
            if (r != null && r.exists() && r instanceof IFile) {
                return (IFile)r;
            }
        }
        path = Platform.getLocation().append(wsRelativePath).toFile().getAbsolutePath();
        return EclipseResourceUtil.getFile((String)path);
    }

    @Override
    protected IRegion doGetHyperlinkRegion(int offset) {
        return this.hyperlinkRegion;
    }

    @Override
    protected abstract void doHyperlink(IRegion var1);

    protected IFile getFileFromProject(String fileName) {
        IFile documentFile = this.getFile();
        if (documentFile == null || !documentFile.isAccessible()) {
            return null;
        }
        fileName = this.findAndReplaceElVariable(fileName);
        IProject project = documentFile.getProject();
        String name = Utils.trimFilePath(fileName);
        IPath currentPath = documentFile.getLocation().removeLastSegments(1);
        IFile member = null;
        StructureEdit se = StructureEdit.getStructureEditForRead((IProject)project);
        if (se == null) {
            return null;
        }
        WorkbenchComponent[] modules = se.getWorkbenchModules();
        int i = 0;
        while (i < modules.length) {
            if (name.startsWith("/")) {
                member = this.findFileByAbsolutePath(project, modules[i], name);
            } else {
                member = this.findFileByRelativePath(project, modules[i], currentPath, name);
                if (member == null && name.length() > 0) {
                    member = this.findFileByAbsolutePath(project, modules[i], "/" + name);
                }
            }
            if (member != null && member instanceof IFile && member.exists()) {
                return member;
            }
            ++i;
        }
        return null;
    }

    protected String findAndReplaceElVariable(String fileName) {
        ResourceReference[] sortedReferences;
        IPath workspacePath = Platform.getLocation();
        ResourceReference[] gResources = GlobalELReferenceList.getInstance().getAllResources(workspacePath);
        String result = fileName;
        ResourceReference[] resourceReferenceArray = sortedReferences = this.sortReferencesByScope(gResources);
        int n = sortedReferences.length;
        int n2 = 0;
        while (n2 < n) {
            ResourceReference rf = resourceReferenceArray[n2];
            String dollarEl = DOLLAR_PREFIX + rf.getLocation() + SUFFIX;
            String sharpEl = SHARP_PREFIX + rf.getLocation() + SUFFIX;
            if (fileName.contains(dollarEl)) {
                result = result.replace(dollarEl, rf.getProperties());
            }
            if (fileName.contains(sharpEl)) {
                result = result.replace(sharpEl, rf.getProperties());
            }
            ++n2;
        }
        return result;
    }

    private ResourceReference[] sortReferencesByScope(ResourceReference[] references) {
        ResourceReference[] sortedReferences = (ResourceReference[])references.clone();
        Arrays.sort(sortedReferences, new Comparator<ResourceReference>(){

            @Override
            public int compare(ResourceReference r1, ResourceReference r2) {
                return r1.getScope() - r2.getScope();
            }
        });
        return sortedReferences;
    }

    private IFile findFileByRelativePath(IProject project, WorkbenchComponent module, IPath basePath, String path) {
        if (path == null || path.trim().length() == 0) {
            return null;
        }
        path = this.findAndReplaceElVariable(path);
        ComponentResource[] resources = module.findResourcesBySourcePath((IPath)new Path("/"), 0);
        IPath projectPath = project.getLocation();
        IFile member = null;
        int i = 0;
        while (resources != null && i < resources.length) {
            IPath webRootPath;
            IPath relativePath;
            IPath filePath;
            IPath runtimePath = resources[i].getRuntimePath();
            IPath sourcePath = resources[i].getSourcePath();
            member = project.getFile(sourcePath.append(filePath = (relativePath = Utils.getRelativePath(webRootPath = projectPath.append(sourcePath), basePath)).append(path)));
            if (member.exists()) {
                return member;
            }
            if (runtimePath.segmentCount() >= 1 && (member = project.getFile(runtimePath.append(filePath = (relativePath = Utils.getRelativePath(webRootPath = projectPath.append(runtimePath), basePath)).append(path)))).exists()) {
                return member;
            }
            ++i;
        }
        return null;
    }

    private IFile findFileByAbsolutePath(IProject project, WorkbenchComponent module, String path) {
        ComponentResource[] resources = module.findResourcesBySourcePath((IPath)new Path("/"), 0);
        path = this.findAndReplaceElVariable(path);
        IFile member = null;
        int i = 0;
        while (resources != null && i < resources.length) {
            IPath runtimePath = resources[i].getRuntimePath();
            IPath sourcePath = resources[i].getSourcePath();
            member = project.getFile(sourcePath.append(path));
            if (member.exists()) {
                return member;
            }
            if (runtimePath.segmentCount() >= 1 && (member = project.getFile(runtimePath.append(path))).exists()) {
                return member;
            }
            ++i;
        }
        return null;
    }

    protected IEditorInput createEditorInput(String fileString) {
        String jarName = fileString.substring(0, fileString.indexOf("!"));
        IFile[] fs = ResourcesPlugin.getWorkspace().getRoot().findFilesForLocation((IPath)new Path(jarName));
        if (fs == null || fs.length == 0) {
            return null;
        }
        IProject p = fs[0].getProject();
        IJavaProject jp = EclipseResourceUtil.getJavaProject((IProject)p);
        if (jp == null) {
            return null;
        }
        IPackageFragmentRoot root = jp.getPackageFragmentRoot((IResource)fs[0]);
        String entryName = fileString.substring(fileString.indexOf("!") + 2, fileString.length());
        JarEntryFile f = new JarEntryFile(entryName);
        f.setParent((Object)root);
        JarEntryEditorInput jarEditorInput = new JarEntryEditorInput((IStorage)f){

            public boolean equals(Object arg) {
                return ((Object)((Object)this)).toString().equals(arg.toString());
            }
        };
        return jarEditorInput;
    }

    public IFile getReadyToOpenFile() {
        return null;
    }
}

