/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.jst.web.ui.wizards.newfile;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ProjectScope;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Preferences;
import org.eclipse.core.runtime.preferences.IScopeContext;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.WizardNewFileCreationPage;
import org.eclipse.ui.ide.IDE;
import org.eclipse.wst.html.ui.internal.wizard.NewHTMLWizard;
import org.eclipse.wst.sse.core.utils.StringUtils;
import org.jboss.tools.common.meta.action.impl.SpecialWizardSupport;
import org.jboss.tools.common.model.XModelException;
import org.jboss.tools.common.model.ui.ModelUIPlugin;
import org.jboss.tools.common.model.ui.wizard.newfile.NewFileContextEx;
import org.jboss.tools.common.model.ui.wizard.newfile.NewXHTMLFileWizard;
import org.jboss.tools.jst.web.model.handlers.CreateJSPFileSupport;
import org.jboss.tools.jst.web.ui.Messages;
import org.jboss.tools.jst.web.ui.WebUiPlugin;
import org.jboss.tools.jst.web.ui.wizards.newfile.NewXHTMLFileWizardPage;
import org.jboss.tools.jst.web.ui.wizards.newfile.NewXHTMLTemplatesWizardPage;
import org.jboss.tools.jst.web.ui.wizards.newfile.NewXHTMLWizardSelectTagLibrariesPage;

public class NewXHTMLWizard
extends NewHTMLWizard {
    private static final String HTMLWizardNewFileCreationPage = "HTMLWizardNewFileCreationPage";
    private static final String NewHTMLTemplatesWizardPage = "NewHTMLTemplatesWizardPage";
    private WizardNewFileCreationPage fNewFilePage;
    private NewXHTMLTemplatesWizardPage fNewFileTemplatesPage;
    private NewXHTMLFileWizard newXHTMLFileWizard;
    private NewXHTMLWizardSelectTagLibrariesPage newXHTMLWizardSelectTagLibrariesPage;
    private IStructuredSelection fSelection;

    public void addPages() {
        super.addPages();
        this.fNewFilePage = new NewXHTMLFileWizardPage("XHTMLWizardNewFileCreationPage", (IStructuredSelection)new StructuredSelection(IDE.computeSelectedResources((IStructuredSelection)this.fSelection)));
        this.fNewFilePage.setTitle(Messages.UI_WIZARD_XHTML_NEW_TITLE);
        this.fNewFilePage.setDescription(Messages.UI_WIZARD_XHTML_NEW_Description);
        this.addPage((IWizardPage)this.fNewFilePage);
        NewFileContextEx newFileContext = this.newXHTMLFileWizard.getFileContext();
        CreateJSPFileSupport jspFileSupport = (CreateJSPFileSupport)newFileContext.getSupport();
        this.fNewFileTemplatesPage = new NewXHTMLTemplatesWizardPage(jspFileSupport);
        this.addPage((IWizardPage)this.fNewFileTemplatesPage);
        this.newXHTMLWizardSelectTagLibrariesPage = this.getURISelectionPage();
        if (jspFileSupport.getTaglibs() != null && jspFileSupport.getTaglibs().getDescriptions().length > 0) {
            this.addPage((IWizardPage)this.newXHTMLWizardSelectTagLibrariesPage);
        }
    }

    public void init(IWorkbench aWorkbench, IStructuredSelection aSelection) {
        super.init(aWorkbench, aSelection);
        this.fSelection = aSelection;
        this.setWindowTitle(Messages.UI_WIZARD_XHTML_NEW_TITLE);
        this.setNewXHTMLFileWizard(new NewXHTMLFileWizard());
        this.getNewXHTMLFileWizard().init(aWorkbench, aSelection);
    }

    public void addPage(IWizardPage page) {
        if (!NewHTMLTemplatesWizardPage.equalsIgnoreCase(page.getName()) && !HTMLWizardNewFileCreationPage.equalsIgnoreCase(page.getName())) {
            super.addPage(page);
        }
    }

    private NewXHTMLWizardSelectTagLibrariesPage getURISelectionPage() {
        SpecialWizardSupport support = this.getNewXHTMLFileWizard().getFileContext().getSupport();
        NewXHTMLWizardSelectTagLibrariesPage step = new NewXHTMLWizardSelectTagLibrariesPage(support, 1);
        try {
            support.setAttributeValue(0, "template", "");
            support.action(SpecialWizardSupport.NEXT);
        }
        catch (XModelException e) {
            ModelUIPlugin.getPluginLog().logError((Throwable)e);
        }
        step.setWizard((IWizard)this);
        return step;
    }

    public boolean performFinish() {
        IFile file;
        boolean performedOK = false;
        this.fNewFileTemplatesPage.saveLastSavedPreferences();
        String fileName = this.fNewFilePage.getFileName();
        if (fileName.lastIndexOf(46) == -1) {
            String newFileName = String.valueOf(fileName) + ".xhtml";
            this.fNewFilePage.setFileName(newFileName);
        }
        if ((file = this.fNewFilePage.createNewFile()) != null) {
            String templateString = this.fNewFileTemplatesPage.getTemplateString();
            try {
                NewFileContextEx newFileContext = this.newXHTMLFileWizard.getFileContext();
                CreateJSPFileSupport jspFileSupport = (CreateJSPFileSupport)newFileContext.getSupport();
                if (jspFileSupport.getAttributeValue(1, "taglibs").length() > 0) {
                    templateString = jspFileSupport.addTaglibs(templateString);
                }
            }
            catch (IOException ex) {
                WebUiPlugin.getDefault().logWarning("Problems with adding taglibs", ex);
            }
            if (templateString != null) {
                templateString = this.applyLineDelimiter(file, templateString);
                Preferences preference = WebUiPlugin.getDefault().getPluginPreferences();
                String charSet = preference.getString("outputCodeset");
                try {
                    ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
                    OutputStreamWriter outputStreamWriter = null;
                    outputStreamWriter = charSet == null || charSet.trim().equals("") ? new OutputStreamWriter(outputStream) : new OutputStreamWriter((OutputStream)outputStream, charSet);
                    outputStreamWriter.write(templateString);
                    outputStreamWriter.flush();
                    outputStreamWriter.close();
                    ByteArrayInputStream inputStream = new ByteArrayInputStream(outputStream.toByteArray());
                    file.setContents((InputStream)inputStream, true, false, null);
                    inputStream.close();
                }
                catch (Exception e) {
                    WebUiPlugin.getDefault().logWarning("Could not create contents for new HTML file", e);
                }
            }
            this.openEditor(file);
            performedOK = true;
        }
        return performedOK;
    }

    private String applyLineDelimiter(IFile file, String text) {
        String lineDelimiter = Platform.getPreferencesService().getString("org.eclipse.core.runtime", "line.separator", System.getProperty("line.separator"), new IScopeContext[]{new ProjectScope(file.getProject()), new InstanceScope()});
        String convertedText = StringUtils.replace((String)text, (String)"\r\n", (String)"\n");
        convertedText = StringUtils.replace((String)convertedText, (String)"\r", (String)"\n");
        convertedText = StringUtils.replace((String)convertedText, (String)"\n", (String)lineDelimiter);
        return convertedText;
    }

    private void openEditor(final IFile file) {
        if (file != null) {
            this.getShell().getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    try {
                        IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
                        IDE.openEditor((IWorkbenchPage)page, (IFile)file, (boolean)true);
                    }
                    catch (PartInitException e) {
                        WebUiPlugin.getDefault().logError(e.getMessage(), e);
                    }
                }
            });
        }
    }

    private NewXHTMLFileWizard getNewXHTMLFileWizard() {
        return this.newXHTMLFileWizard;
    }

    private void setNewXHTMLFileWizard(NewXHTMLFileWizard newXHTMLFileWizard) {
        this.newXHTMLFileWizard = newXHTMLFileWizard;
    }
}

