/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.jst.web.ui.wizards.newfile;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jst.jsp.core.internal.util.FacetModuleCoreSupport;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.dialogs.WizardNewFileCreationPage;
import org.eclipse.wst.common.project.facet.core.IFacetedProject;
import org.eclipse.wst.common.project.facet.core.IProjectFacet;
import org.eclipse.wst.common.project.facet.core.ProjectFacetsManager;
import org.eclipse.wst.html.core.internal.provisional.contenttype.ContentTypeIdForHTML;
import org.eclipse.wst.html.ui.internal.HTMLUIMessages;
import org.jboss.tools.common.web.WebUtils;
import org.jboss.tools.jst.web.ui.WebUiPlugin;

public class NewXHTMLFileWizardPage
extends WizardNewFileCreationPage {
    private static final String defaultName = "NewFile";
    private IContentType fContentType;
    private List fValidExtensions = null;

    public NewXHTMLFileWizardPage(String pageName, IStructuredSelection selection) {
        super(pageName, selection);
    }

    public void createControl(Composite parent) {
        super.createControl(parent);
        this.setFileName(this.computeDefaultFileName());
        this.setPageComplete(this.validatePage());
    }

    protected String computeDefaultFileName() {
        int count = 0;
        String fileName = this.addDefaultExtension(defaultName);
        IPath containerFullPath = this.getContainerFullPath();
        if (containerFullPath != null) {
            while (true) {
                IPath path = containerFullPath.append(fileName);
                if (!ResourcesPlugin.getWorkspace().getRoot().exists(path)) break;
                fileName = this.addDefaultExtension(defaultName + ++count);
            }
        }
        return fileName;
    }

    protected void initialPopulateContainerNameField() {
        super.initialPopulateContainerNameField();
        IPath fullPath = this.getContainerFullPath();
        IProject project = this.getProjectFromPath(fullPath);
        IPath[] webContentPaths = project != null ? WebUtils.getWebContentPaths((IProject)project) : null;
        boolean withinWebContent = false;
        int i = 0;
        while (webContentPaths != null && i < webContentPaths.length) {
            if (webContentPaths[i].isPrefixOf(fullPath)) {
                withinWebContent = true;
                break;
            }
            ++i;
        }
        if (withinWebContent && webContentPaths.length > 0) {
            this.setContainerFullPath(webContentPaths[0]);
        }
    }

    protected boolean validatePage() {
        this.setMessage(null);
        this.setErrorMessage(null);
        if (!super.validatePage()) {
            return false;
        }
        String fileName = this.getFileName();
        IPath fullPath = this.getContainerFullPath();
        if (fullPath != null && !fullPath.isEmpty() && fileName != null) {
            IProject project;
            if (!this.extensionValidForContentType(fileName)) {
                this.setErrorMessage(NLS.bind((String)HTMLUIMessages._ERROR_FILENAME_MUST_END_HTML, (Object)this.getValidExtensions().toString()));
                return false;
            }
            if (fileName.lastIndexOf(46) == -1) {
                String newFileName = this.addDefaultExtension(fileName);
                IPath resourcePath = fullPath.append(newFileName);
                IWorkspace workspace = ResourcesPlugin.getWorkspace();
                IStatus result = workspace.validatePath(resourcePath.toString(), 2);
                if (!result.isOK()) {
                    this.setErrorMessage(result.getMessage());
                    return false;
                }
                if (workspace.getRoot().getFolder(resourcePath).exists() || workspace.getRoot().getFile(resourcePath).exists()) {
                    this.setErrorMessage(HTMLUIMessages.ResourceGroup_nameExists);
                    return false;
                }
            }
            if ((project = this.getProjectFromPath(fullPath)) != null && this.isWebProject(project)) {
                IPath[] webContentPaths = FacetModuleCoreSupport.getAcceptableRootPaths((IProject)project);
                boolean isPrefix = false;
                int i = 0;
                while (!isPrefix && i < webContentPaths.length) {
                    isPrefix |= webContentPaths[i].isPrefixOf(fullPath);
                    ++i;
                }
                if (!isPrefix) {
                    this.setMessage(HTMLUIMessages._WARNING_FOLDER_MUST_BE_INSIDE_WEB_CONTENT, 2);
                }
            }
        }
        return true;
    }

    private IContentType getContentType() {
        if (this.fContentType == null) {
            this.fContentType = Platform.getContentTypeManager().getContentType(ContentTypeIdForHTML.ContentTypeID_HTML);
        }
        return this.fContentType;
    }

    private List getValidExtensions() {
        if (this.fValidExtensions == null) {
            IContentType type = this.getContentType();
            this.fValidExtensions = new ArrayList<String>(Arrays.asList(type.getFileSpecs(8)));
        }
        return this.fValidExtensions;
    }

    private boolean extensionValidForContentType(String fileName) {
        boolean valid = false;
        IContentType type = this.getContentType();
        if (fileName.lastIndexOf(46) != -1) {
            IContentType[] types = Platform.getContentTypeManager().findContentTypesFor(fileName);
            int i = 0;
            while (i < types.length && !valid) {
                valid = types[i].isKindOf(type);
                ++i;
            }
        } else {
            valid = true;
        }
        return valid;
    }

    String addDefaultExtension(String filename) {
        StringBuffer newFileName = new StringBuffer(filename);
        String ext = "xhtml";
        newFileName.append(".");
        newFileName.append(ext);
        return newFileName.toString();
    }

    private IProject getProjectFromPath(IPath path) {
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        IProject project = null;
        if (path != null) {
            project = workspace.validatePath(path.toString(), 4).isOK() ? workspace.getRoot().getProject(path.toString()) : workspace.getRoot().getFile(path).getProject();
        }
        return project;
    }

    private boolean isWebProject(IProject project) {
        IProjectFacet facet;
        IFacetedProject faceted;
        if (project == null) {
            return false;
        }
        boolean is = false;
        try {
            faceted = ProjectFacetsManager.create((IProject)project);
        }
        catch (CoreException e) {
            WebUiPlugin.getDefault().logError(e);
            return false;
        }
        if (ProjectFacetsManager.isProjectFacetDefined((String)"jst.web")) {
            facet = ProjectFacetsManager.getProjectFacet((String)"jst.web");
            boolean bl = is = is || faceted != null && faceted.hasProjectFacet(facet);
        }
        if (ProjectFacetsManager.isProjectFacetDefined((String)"wst.web")) {
            facet = ProjectFacetsManager.getProjectFacet((String)"wst.web");
            is = is || faceted != null && faceted.hasProjectFacet(facet);
        }
        return is;
    }
}

