/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.jst.web.ui.wizards.appregister;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.jboss.tools.common.meta.action.XEntityData;
import org.jboss.tools.common.meta.action.impl.XEntityDataImpl;
import org.jboss.tools.common.model.options.Preference;
import org.jboss.tools.common.model.ui.attribute.XAttributeSupport;
import org.jboss.tools.common.model.ui.util.ModelUtilities;
import org.jboss.tools.jst.web.project.helpers.NewWebProjectContext;
import org.jboss.tools.jst.web.ui.Messages;
import org.jboss.tools.jst.web.ui.wizards.appregister.AppRegisterComponent;

public class NewProjectRegisterPage
extends WizardPage {
    private static final String SERVLET_VERSION = "servletVersion";
    private NewWebProjectContext context;
    private XAttributeSupport support;
    AppRegisterComponent appRegister = new AppRegisterComponent();
    Preference servletPreference;
    private boolean lock = false;

    public NewProjectRegisterPage(NewWebProjectContext context, Preference servletPreference) {
        super(Messages.NewProjectRegisterPage_Register);
        this.context = context;
        this.servletPreference = servletPreference;
        this.initServletSupport();
        this.appRegister.setContext(context.getRegisterServerContext());
        this.appRegister.setEnabling(false);
        this.appRegister.init();
        this.initListeners();
    }

    public AppRegisterComponent getAppRegisterComponent() {
        return this.appRegister;
    }

    public void dispose() {
        super.dispose();
        if (this.support != null) {
            this.support.dispose();
        }
        this.support = null;
        if (this.appRegister != null) {
            this.appRegister.dispose();
        }
        this.appRegister = null;
    }

    private void initServletSupport() {
        String defaultServletVersion = this.servletPreference.getValue();
        XEntityDataImpl entityData = XEntityDataImpl.create((String[][])new String[][]{{"WebPrjCreateStepDirs", ""}, {SERVLET_VERSION, ""}});
        entityData.setValue(SERVLET_VERSION, defaultServletVersion);
        this.context.setServletVersion(defaultServletVersion);
        this.support = new XAttributeSupport(ModelUtilities.getPreferenceModel().getRoot(), (XEntityData)entityData);
        this.support.setLayout(this.getLayoutForSupport());
    }

    private Layout getLayoutForSupport() {
        GridLayout gridLayout = new GridLayout(2, false);
        gridLayout.marginHeight = 4;
        gridLayout.marginWidth = 4;
        gridLayout.horizontalSpacing = 10;
        gridLayout.verticalSpacing = 10;
        return gridLayout;
    }

    public void createControl(Composite parent) {
        this.initializeDialogUnits((Control)parent);
        Composite c = new Composite(parent, 0);
        c.setLayout((Layout)new GridLayout());
        Composite ch = this.support.createControl(c);
        ch.setLayoutData((Object)new GridData(768));
        Label label = new Label(c, 258);
        label.setLayoutData((Object)new GridData(768));
        ch = this.appRegister.createControl(c);
        ch.setLayoutData((Object)new GridData(768));
        this.setControl((Control)c);
    }

    public void setVisible(boolean visible) {
        if (visible) {
            this.lock = true;
            this.loadServletVersion();
            this.appRegister.loadApplicationName();
            this.lock = false;
        }
        this.setPageComplete(this.validatePage());
        super.setVisible(visible);
    }

    public void loadServletVersion() {
        int i;
        String prefServletVersion;
        String currentServletVersion = this.support.getPropertyEditorAdapterByName(SERVLET_VERSION).getStringValue(true);
        String vs = this.context.getServletVersion();
        if (vs != null && vs.length() > 0 && !vs.equals(currentServletVersion)) {
            this.context.setServletVersion(vs);
            this.support.getPropertyEditorAdapterByName(SERVLET_VERSION).setValue((Object)vs);
        }
        if (this.context != null && this.context.getProjectTemplate() != null && (prefServletVersion = this.context.getProjectTemplate().getProjectVersion().getPreferredServletVersion()) != null && (i = this.context.compareServletVersions(prefServletVersion, currentServletVersion)) > 0) {
            this.context.setServletVersion(prefServletVersion);
            this.support.getPropertyEditorAdapterByName(SERVLET_VERSION).setValue((Object)prefServletVersion);
        }
    }

    private boolean validatePage() {
        this.lock = true;
        try {
            this.appRegister.commit();
            String msg = this.appRegister.getErrorMessage();
            String wrn = null;
            if (msg == null) {
                wrn = this.context.validateServletVersion();
            }
            if (msg != null) {
                this.setErrorMessage(msg);
                return false;
            }
            if (wrn != null) {
                this.setErrorMessage(null);
                this.setMessage(wrn, 2);
            } else {
                this.setErrorMessage(null);
                this.setMessage(null);
            }
            return true;
        }
        finally {
            this.lock = false;
        }
    }

    private void initListeners() {
        this.support.getPropertyEditorAdapterByName(SERVLET_VERSION).addValueChangeListener((PropertyChangeListener)new InputChangeListener());
        this.appRegister.addPropertyChangeListener(new InputChangeListener());
    }

    class InputChangeListener
    implements PropertyChangeListener {
        InputChangeListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if (NewProjectRegisterPage.this.lock) {
                return;
            }
            NewProjectRegisterPage.this.context.setServletVersion(NewProjectRegisterPage.this.support.getPropertyEditorAdapterByName(NewProjectRegisterPage.SERVLET_VERSION).getStringValue(true));
            NewProjectRegisterPage.this.setPageComplete(NewProjectRegisterPage.this.validatePage());
        }
    }
}

