/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.jst.web.ui.palette.internal.html.html5.wizard;

import java.util.HashMap;
import java.util.Map;
import org.jboss.tools.common.model.ui.editors.dnd.DropWizardMessages;
import org.jboss.tools.common.model.ui.editors.dnd.IElementGenerator;
import org.jboss.tools.jst.web.ui.JSTWebUIImages;
import org.jboss.tools.jst.web.ui.palette.html.wizard.HTMLConstants;
import org.jboss.tools.jst.web.ui.palette.html.wizard.NewHTMLWidgetWizard;
import org.jboss.tools.jst.web.ui.palette.internal.html.html5.wizard.MenuitemsEditor;
import org.jboss.tools.jst.web.ui.palette.internal.html.html5.wizard.NewMenuitemWizardPage;

public class NewMenuitemWizard
extends NewHTMLWidgetWizard<NewMenuitemWizardPage>
implements HTMLConstants {
    static String prefix = "menuitem-";

    public NewMenuitemWizard() {
        this.setWindowTitle(DropWizardMessages.Wizard_Window_Title);
        this.setDefaultPageImageDescriptor(JSTWebUIImages.getInstance().getOrCreateImageDescriptor(JSTWebUIImages.MENUITEM_IMAGE));
    }

    @Override
    public NewMenuitemWizardPage createPage() {
        return new NewMenuitemWizardPage();
    }

    @Override
    protected void addContent(IElementGenerator.ElementNode parent) {
        IElementGenerator.ElementNode menuitem = parent.addChild("menuitem");
        this.addID(prefix, menuitem);
        HashMap<String, String> values = new HashMap<String, String>();
        String[] stringArray = MenuitemsEditor.DIALOG_PROPERTIES;
        int n = MenuitemsEditor.DIALOG_PROPERTIES.length;
        int n2 = 0;
        while (n2 < n) {
            String name = stringArray[n2];
            values.put(name, ((NewMenuitemWizardPage)this.page).getEditorValue(name));
            ++n2;
        }
        NewMenuitemWizard.fillMenuItem(menuitem, values);
    }

    static void fillMenuItem(IElementGenerator.ElementNode menuitem, Map<String, String> values) {
        String radiogroup;
        String icon;
        String label;
        String type = values.get("type");
        if (type != null && type.length() > 0) {
            menuitem.addAttribute("type", type);
        }
        if ((label = values.get("label")) != null) {
            menuitem.addAttribute("label", label);
        }
        if ("true".equals(values.get("default"))) {
            menuitem.addAttribute("default", "default");
        }
        if ("true".equals(values.get("disabled"))) {
            menuitem.addAttribute("disabled", "disabled");
        }
        if (!"command".equals(type) && "true".equals(values.get("checked"))) {
            menuitem.addAttribute("checked", "checked");
        }
        if ((icon = values.get("icon")) != null && icon.length() > 0) {
            menuitem.addAttribute("icon", icon);
        }
        if ("radio".equals(type) && (radiogroup = values.get("radiogroup")) != null && radiogroup.length() > 0) {
            menuitem.addAttribute("radiogroup", radiogroup);
        }
    }

    @Override
    protected void createBodyForBrowser(IElementGenerator.ElementNode body) {
        StringBuilder sb = new StringBuilder();
        sb.append("var event = new CustomEvent('show',{detail: {}, bubbles: false, cancelable: true});");
        sb.append("document.getElementById('mymenu').dispatchEvent(event);");
        body.addAttribute("onload", sb.toString());
        body.addAttribute("contextmenu", "mymenu");
        IElementGenerator.ElementNode menu = body.addChild("menu");
        menu.addAttribute("id", "mymenu");
        menu.addAttribute("label", "My Menu");
        menu.addAttribute("type", "context");
        this.addContent(menu);
    }
}

