/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.jst.web.ui.palette.internal.html.html5.wizard;

import org.jboss.tools.common.model.ui.editors.dnd.DropWizardMessages;
import org.jboss.tools.common.model.ui.editors.dnd.IElementGenerator;
import org.jboss.tools.jst.web.ui.JSTWebUIImages;
import org.jboss.tools.jst.web.ui.palette.html.wizard.HTMLConstants;
import org.jboss.tools.jst.web.ui.palette.html.wizard.NewHTMLWidgetWizard;
import org.jboss.tools.jst.web.ui.palette.html.wizard.WizardMessages;
import org.jboss.tools.jst.web.ui.palette.internal.html.html5.wizard.HTMLFieldEditorFactory;
import org.jboss.tools.jst.web.ui.palette.internal.html.html5.wizard.NewButtonWizardPage;

public class NewButtonWizard
extends NewHTMLWidgetWizard<NewButtonWizardPage>
implements HTMLConstants {
    public NewButtonWizard() {
        this.setWindowTitle(DropWizardMessages.Wizard_Window_Title);
        this.setDefaultPageImageDescriptor(JSTWebUIImages.getInstance().getOrCreateImageDescriptor(JSTWebUIImages.FORM_BUTTON_IMAGE));
    }

    @Override
    protected NewButtonWizardPage createPage() {
        return new NewButtonWizardPage();
    }

    @Override
    protected void addContent(IElementGenerator.ElementNode parent) {
        String value = ((NewButtonWizardPage)this.page).getEditorValue("value");
        String type = ((NewButtonWizardPage)this.page).getEditorValue("type");
        if (value.length() == 0) {
            if ("button".equals(type)) {
                value = "Input";
            } else if ("reset".equals(type)) {
                value = WizardMessages.buttonTypeResetLabel;
            } else if ("submit".equals(type)) {
                value = WizardMessages.buttonTypeSubmitLabel;
            }
        }
        IElementGenerator.ElementNode input = parent.addChild("input");
        this.addAttributeIfNotEmpty(input, "type", "type");
        input.addAttribute("value", value);
        this.addAttributeIfNotEmpty(input, "form", "form");
        if (this.isTrue("disabled")) {
            input.addAttribute("disabled", "disabled");
        }
        if (this.isTrue("autofocus")) {
            input.addAttribute("autofocus", "autofocus");
        }
        this.addID("button-", input);
        boolean isSubmit = "submit".equals(type);
        if (isSubmit) {
            this.addAttributeIfNotEmpty(input, "formaction", "formaction");
            String method = ((NewButtonWizardPage)this.page).getEditorValue("formmethod");
            if (!HTMLFieldEditorFactory.INHERITED_FROM_FORM.equals(method)) {
                this.addAttributeIfNotEmpty(input, "formmethod", "formmethod");
            }
        }
    }

    @Override
    protected void createBodyForBrowser(IElementGenerator.ElementNode body) {
        IElementGenerator.ElementNode form = this.getFormNode(body);
        IElementGenerator.ElementNode div = form.addChild("div");
        div.addAttribute("style", "padding: 20px 20px 20px 20px;");
        this.addContent(div);
    }
}

