/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.jst.web.ui.palette.internal;

import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.QualifiedName;
import org.jboss.tools.jst.web.ui.WebUiPlugin;
import org.jboss.tools.jst.web.ui.palette.PaletteUIMessages;

public class PaletteSettings {
    private static final QualifiedName HTML5_RECOGNIZED_GROUPS_ONLY = new QualifiedName("org.jboss.tools.jst.web.ui", "HTML5_RECOGNIZED_GROUPS_ONLY");
    private static final QualifiedName HTML5_FILTER_TEXT = new QualifiedName("org.jboss.tools.jst.web.ui", "HTML5_FILTER_TEXT");
    private static final QualifiedName HTML5_DYNAMIC_GROUP_TYPE = new QualifiedName("org.jboss.tools.jst.web.ui", "HTML5_DYNAMIC_GROUP_TYPE");
    private static final QualifiedName HTML5_DYNAMIC_GROUP_NUMBER = new QualifiedName("org.jboss.tools.jst.web.ui", "HTML5_DYNAMIC_GROUP_NUMBER");
    public static final String TYPE_MOST_POPULAR = PaletteUIMessages.TYPE_MOST_POPULAR;
    public static final String TYPE_LAST_USED = PaletteUIMessages.TYPE_LAST_USED;
    private static PaletteSettings instance = new PaletteSettings();
    private boolean recognizedCategoriesOnly = false;
    private String filterString;
    private int dynamicGroupNumber;
    private String dynamicGroupType;

    public static PaletteSettings getInstance() {
        return instance;
    }

    private PaletteSettings() {
        String property = this.getProperty(HTML5_RECOGNIZED_GROUPS_ONLY);
        if (property != null) {
            this.recognizedCategoriesOnly = new Boolean(property);
        }
        this.filterString = this.getProperty(HTML5_FILTER_TEXT);
        if (this.filterString == null) {
            this.filterString = "";
        }
        this.dynamicGroupNumber = (property = this.getProperty(HTML5_DYNAMIC_GROUP_NUMBER)) != null ? new Integer(property) : 20;
        this.dynamicGroupType = this.getProperty(HTML5_DYNAMIC_GROUP_TYPE);
        if (this.dynamicGroupType == null) {
            this.dynamicGroupType = TYPE_MOST_POPULAR;
        }
    }

    public boolean isRecognizedGroupsOnly() {
        return this.recognizedCategoriesOnly;
    }

    public void setRecognizedGroupsOnly(boolean value) {
        this.recognizedCategoriesOnly = value;
        this.setProperty(HTML5_RECOGNIZED_GROUPS_ONLY, "" + value);
    }

    public String getFilterString() {
        return this.filterString;
    }

    public void setFilterString(String value) {
        this.filterString = value;
        this.setProperty(HTML5_FILTER_TEXT, value);
    }

    public void setDynamicGroupNumber(int number) {
        this.dynamicGroupNumber = number;
        this.setProperty(HTML5_DYNAMIC_GROUP_NUMBER, "" + number);
    }

    public int getDynamicGroupNumber() {
        return this.dynamicGroupNumber;
    }

    public void setDynamicGroupType(String type) {
        if (!TYPE_LAST_USED.equals(type) && !TYPE_MOST_POPULAR.equals(type)) {
            throw new IllegalArgumentException("type must be \"" + TYPE_LAST_USED + "\" or \"" + TYPE_MOST_POPULAR + "\", but was - " + type);
        }
        this.dynamicGroupType = type;
        this.setProperty(HTML5_DYNAMIC_GROUP_TYPE, type);
    }

    public String getDynamicGroupType() {
        return this.dynamicGroupType;
    }

    private synchronized String getProperty(QualifiedName propertyName) {
        try {
            return ResourcesPlugin.getWorkspace().getRoot().getPersistentProperty(propertyName);
        }
        catch (CoreException e) {
            WebUiPlugin.getDefault().logError(e);
            return null;
        }
    }

    private synchronized void setProperty(QualifiedName propertyName, String value) {
        try {
            ResourcesPlugin.getWorkspace().getRoot().setPersistentProperty(propertyName, value);
        }
        catch (CoreException e) {
            WebUiPlugin.getDefault().logError(e);
        }
    }
}

