/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.jst.web.ui.palette.html.jquery.wizard;

import java.io.File;
import org.eclipse.jface.wizard.IWizardPage;
import org.jboss.tools.common.model.ui.editors.dnd.IDropCommand;
import org.jboss.tools.common.model.ui.editors.dnd.IElementGenerator;
import org.jboss.tools.jst.web.WebModelPlugin;
import org.jboss.tools.jst.web.kb.internal.taglib.html.jq.JQueryMobileVersion;
import org.jboss.tools.jst.web.kb.taglib.IHTMLLibraryVersion;
import org.jboss.tools.jst.web.ui.internal.editor.jspeditor.dnd.PaletteItemDropCommand;
import org.jboss.tools.jst.web.ui.internal.preferences.js.PreferredJSLibVersions;
import org.jboss.tools.jst.web.ui.palette.html.jquery.wizard.JQueryConstants;
import org.jboss.tools.jst.web.ui.palette.html.jquery.wizard.JQueryVersionPage;
import org.jboss.tools.jst.web.ui.palette.html.jquery.wizard.NewDialogWizard;
import org.jboss.tools.jst.web.ui.palette.html.jquery.wizard.NewJQueryWidgetWizardPage;
import org.jboss.tools.jst.web.ui.palette.html.jquery.wizard.WizardDescriptions;
import org.jboss.tools.jst.web.ui.palette.html.wizard.VersionedNewHTMLWidgetWizard;

public abstract class NewJQueryWidgetWizard<P extends NewJQueryWidgetWizardPage>
extends VersionedNewHTMLWidgetWizard<JQueryMobileVersion, P>
implements JQueryConstants {
    private JQueryVersionPage versionPage;
    PreferredJSLibVersions preferredVersions = null;

    public NewJQueryWidgetWizard() {
        super(JQueryMobileVersion.getLatestDefaultVersion());
    }

    @Override
    public void initWithoutUI() {
        this.addPages();
        if (this.page != null) {
            ((NewJQueryWidgetWizardPage)this.page).createFields();
        }
        this.versionPage.createFields();
    }

    @Override
    protected void doAddPages() {
        super.doAddPages();
        this.versionPage = new JQueryVersionPage("jQueryVersion", "Add References to JS/CSS");
        this.versionPage.setDescription(WizardDescriptions.versionPage);
        this.addPage((IWizardPage)this.versionPage);
    }

    public PreferredJSLibVersions getPreferredVersions() {
        return this.preferredVersions;
    }

    @Override
    public void setCommand(IDropCommand command) {
        super.setCommand(command);
        this.version = (JQueryMobileVersion)((PaletteItemDropCommand)command).getPaletteItem().getCategory().getVersionGroup().getVersion();
        this.preferredVersions = new PreferredJSLibVersions(this.getFile(), (IHTMLLibraryVersion)this.getVersion());
        this.preferredVersions.updateLibEnablementAndSelection();
    }

    protected boolean isMini() {
        return this.isTrue("mini");
    }

    protected boolean isLayoutHorizontal() {
        return "Horizontal".equals(((NewJQueryWidgetWizardPage)this.page).getEditorValue("layout"));
    }

    @Override
    protected void doPerformFinish() {
        this.preferredVersions.applyLibPreference(this.versionPage);
        this.preferredVersions.saveLibPreference();
        if (this.page == null || this.isTrue("addJSCSS")) {
            this.getCommandProperties().put("insert jquery mobile js css", this.getVersion());
            this.getCommandProperties().put("preferred-js-lib-versions", this.preferredVersions);
        }
        super.doPerformFinish();
    }

    protected IElementGenerator.ElementNode getPageContentNode(IElementGenerator.ElementNode parent) {
        IElementGenerator.ElementNode page = parent.addChild("div");
        page.addAttribute("data-role", "page");
        page.addAttribute("id", "jbt");
        IElementGenerator.ElementNode content = page.addChild("div");
        content.addAttribute("data-role", "content");
        return content;
    }

    @Override
    protected void createHead(IElementGenerator.ElementNode html) {
        ResourceConstants c;
        String browserType = ((NewJQueryWidgetWizardPage)this.page).getBrowserType();
        ResourceConstants resourceConstants = c = "mozilla".equals(browserType) || this instanceof NewDialogWizard ? new ResourceConstants130() : new ResourceConstants130();
        if (this.version == JQueryMobileVersion.JQM_1_4) {
            c = new ResourceConstants140();
        }
        String styleSheetURI = c.getCSSPath();
        String jQueryScriptURI = c.getScriptPath();
        String jQueryMobileScriptURI = c.getMobileScriptPath();
        File root = WebModelPlugin.getJSStateRoot();
        if (root != null) {
            String prefix = "js/";
            if (root.isDirectory()) {
                styleSheetURI = new File(root, String.valueOf(prefix) + c.getCSSName()).toURI().toString();
                jQueryScriptURI = new File(root, String.valueOf(prefix) + c.getScriptName()).toURI().toString();
                jQueryMobileScriptURI = new File(root, String.valueOf(prefix) + c.getMobileScriptName()).toURI().toString();
            } else if (root.isFile()) {
                String jar = "jar:" + root.toURI().toString() + "!/";
                styleSheetURI = String.valueOf(jar) + prefix + c.getCSSName();
                jQueryScriptURI = String.valueOf(jar) + prefix + c.getScriptName();
                jQueryMobileScriptURI = String.valueOf(jar) + prefix + c.getMobileScriptName();
            }
        }
        IElementGenerator.ElementNode head = html.addChild("head");
        if ("mozilla".equals(browserType)) {
            StringBuilder sb = new StringBuilder();
            sb.append("\n(function() {\n").append("  var originalGetComputedStyle = window.getComputedStyle;\n").append("  window.getComputedStyle = function() {\n").append("    if (arguments.length == 1) {\n").append("      // workaround for https://bugzilla.mozilla.org/show_bug.cgi?id=567350 (getComputedStyle requires both arguments to be supplied)\n").append("      return originalGetComputedStyle.call(this, arguments[0], null);\n").append("    } else {\n").append("      return originalGetComputedStyle.apply(this, arguments);\n").append("    }\n").append("  };\n").append("}());\n");
            head.addChild("script", sb.toString());
        }
        head.addChild("title", "Page Title");
        IElementGenerator.ElementNode meta = head.addChild("meta");
        meta.addAttribute("name", "viewport");
        meta.addAttribute("content", "width=device-width, initial-scale=1");
        IElementGenerator.ElementNode link = head.addChild("link");
        link.addAttribute("rel", "stylesheet");
        link.addAttribute("href", styleSheetURI);
        IElementGenerator.ElementNode script = head.addChild("script", "");
        script.addAttribute("src", jQueryScriptURI);
        script = head.addChild("script", "");
        script.addAttribute("src", jQueryMobileScriptURI);
    }

    abstract class ResourceConstants {
        ResourceConstants() {
        }

        public String getSite() {
            return "http://code.jquery.com/";
        }

        public String getMobileSite() {
            return "http://code.jquery.com/mobile/";
        }

        public abstract String getVerionFolder();

        public abstract String getCSSName();

        public abstract String getScriptName();

        public abstract String getMobileScriptName();

        public String getCSSPath() {
            return String.valueOf(this.getMobileSite()) + this.getVerionFolder() + this.getCSSName();
        }

        public String getScriptPath() {
            return String.valueOf(this.getSite()) + this.getScriptName();
        }

        public String getMobileScriptPath() {
            return String.valueOf(this.getMobileSite()) + this.getVerionFolder() + this.getMobileScriptName();
        }
    }

    class ResourceConstants120
    extends ResourceConstants {
        ResourceConstants120() {
        }

        @Override
        public String getVerionFolder() {
            return "1.2.0/";
        }

        @Override
        public String getCSSName() {
            return "jquery.mobile-1.2.0.min.css";
        }

        @Override
        public String getScriptName() {
            return "jquery-1.8.2.min.js";
        }

        @Override
        public String getMobileScriptName() {
            return "jquery.mobile-1.2.0.min.js";
        }
    }

    class ResourceConstants121
    extends ResourceConstants {
        ResourceConstants121() {
        }

        @Override
        public String getVerionFolder() {
            return "1.2.1/";
        }

        @Override
        public String getCSSName() {
            return "jquery.mobile-1.2.1.css";
        }

        @Override
        public String getScriptName() {
            return "jquery-1.8.3.min.js";
        }

        @Override
        public String getMobileScriptName() {
            return "jquery.mobile-1.2.1.js";
        }
    }

    class ResourceConstants130
    extends ResourceConstants {
        ResourceConstants130() {
        }

        @Override
        public String getVerionFolder() {
            return "1.3.0-rc.1/";
        }

        @Override
        public String getCSSName() {
            return "jquery.mobile-1.3.0-rc.1.min.css";
        }

        @Override
        public String getScriptName() {
            return "jquery-1.9.0.min.js";
        }

        @Override
        public String getMobileScriptName() {
            return "jquery.mobile-1.3.0-rc.1.min.js";
        }
    }

    class ResourceConstants140
    extends ResourceConstants {
        ResourceConstants140() {
        }

        @Override
        public String getVerionFolder() {
            return "1.4.0-rc.1/";
        }

        @Override
        public String getCSSName() {
            return "jquery.mobile-1.4.0-rc.1.min.css";
        }

        @Override
        public String getScriptName() {
            return "jquery-1.10.2.min.js";
        }

        @Override
        public String getMobileScriptName() {
            return "jquery.mobile-1.4.0-rc.1.min.js";
        }
    }

    protected class SearchCapability {
        protected String searchInputID = null;
        protected IElementGenerator.ElementNode form;

        public SearchCapability(IElementGenerator.ElementNode parent, String filterInputPrefix) {
            boolean is13;
            boolean bl = is13 = NewJQueryWidgetWizard.this.getVersion() == JQueryMobileVersion.JQM_1_3;
            if (!is13 && NewJQueryWidgetWizard.this.isTrue("data-filter")) {
                this.form = parent.addChild("form");
                IElementGenerator.ElementNode input = this.form.addChild("input");
                input.addAttribute("data-type", "search");
                int k = NewJQueryWidgetWizard.this.generateIndex(filterInputPrefix, "", 1);
                this.searchInputID = String.valueOf(filterInputPrefix) + k;
                input.addAttribute("id", this.searchInputID);
            }
        }

        public void addClassFilterable() {
            if (this.form != null) {
                this.form.addAttribute("class", "ui-filterable");
            }
        }

        public void addDataFilter(IElementGenerator.ElementNode filterable) {
            if (NewJQueryWidgetWizard.this.isTrue("data-filter")) {
                filterable.addAttribute("data-filter", "true");
                if (this.searchInputID != null) {
                    filterable.addAttribute("data-input", "#" + this.searchInputID);
                }
            }
        }
    }
}

