/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.jst.web.ui.palette;

import java.net.MalformedURLException;
import java.net.URL;
import org.eclipse.core.runtime.Platform;
import org.eclipse.gef.palette.PaletteContainer;
import org.eclipse.gef.palette.PaletteRoot;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.ContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.dialogs.SearchPattern;
import org.jboss.tools.common.model.XModel;
import org.jboss.tools.common.model.XModelObject;
import org.jboss.tools.common.model.event.XModelTreeEvent;
import org.jboss.tools.common.model.event.XModelTreeListener;
import org.jboss.tools.common.model.ui.views.palette.IPaletteAdapter;
import org.jboss.tools.common.model.ui.views.palette.IPalettePageAdapter;
import org.jboss.tools.common.model.ui.views.palette.PaletteContents;
import org.jboss.tools.common.model.util.EclipseResourceUtil;
import org.jboss.tools.jst.web.ui.JSTWebUIImages;
import org.jboss.tools.jst.web.ui.WebUiPlugin;
import org.jboss.tools.jst.web.ui.internal.editor.jspeditor.PagePaletteContents;
import org.jboss.tools.jst.web.ui.palette.DescriptionManager;
import org.jboss.tools.jst.web.ui.palette.DropTargetManager;
import org.jboss.tools.jst.web.ui.palette.MobileDrawerEditPart;
import org.jboss.tools.jst.web.ui.palette.PaletteUIMessages;
import org.jboss.tools.jst.web.ui.palette.PaletteViewer;
import org.jboss.tools.jst.web.ui.palette.PaletteViewerPreferences;
import org.jboss.tools.jst.web.ui.palette.internal.HTML5DynamicDrawerFigure;
import org.jboss.tools.jst.web.ui.palette.internal.PaletteSettings;
import org.jboss.tools.jst.web.ui.palette.internal.html.impl.PaletteDrawerImpl;
import org.jboss.tools.jst.web.ui.palette.internal.html.impl.PaletteModelImpl;
import org.jboss.tools.jst.web.ui.palette.internal.html.impl.PaletteTool;
import org.jboss.tools.jst.web.ui.palette.model.IPaletteModel;
import org.jboss.tools.jst.web.ui.palette.model.PaletteModel;
import org.osgi.framework.Bundle;

public class PaletteAdapter
implements IPaletteAdapter {
    private static final URL BASE_URL = EclipseResourceUtil.getInstallURL((Bundle)Platform.getBundle((String)"org.jboss.tools.common.model.ui"));
    private static final String IMAGE_PATH = "images/xstudio/palette/";
    private IPalettePageAdapter viewPart = null;
    private IPaletteModel model = null;
    private PaletteViewer viewer = null;
    private Text filterText = null;
    private boolean isRecognizedGroupsOnly = PaletteSettings.getInstance().isRecognizedGroupsOnly();
    private Control palette = null;
    private DescriptionManager descriptionManager = null;
    private DropTargetManager dropManager = null;
    private PaletteModelListener modelListener = null;
    private PagePaletteContents paletteContents;
    private SearchPattern pattern = new SearchPattern();

    public void setPaletteViewPart(IPalettePageAdapter viewPart) {
        this.viewPart = viewPart;
    }

    public void initActionBars() {
        IActionBars bars = this.viewPart.getActionBars();
        if (bars != null) {
            if (this.isJSF()) {
                bars.getToolBarManager().add((IAction)new PaletteEditAction());
                bars.getToolBarManager().add((IAction)new ShowHideTabsAction());
                bars.getToolBarManager().add((IAction)new ImportTLDAction());
            } else if (this.isMobile()) {
                bars.getToolBarManager().add((IContributionItem)new PaletteFilterAction());
                bars.getMenuManager().add((IAction)new ClearDynamicGroupAction());
            }
        }
    }

    public void activated() {
        String filterString = PaletteSettings.getInstance().getFilterString();
        if (this.filterText != null && !this.filterText.getText().equals(filterString)) {
            this.filterText.setText(filterString);
            this.filter();
        }
        if (this.isRecognizedGroupsOnly != PaletteSettings.getInstance().isRecognizedGroupsOnly()) {
            this.filter();
        }
        this.refreshDynamicDrawer();
    }

    private boolean isJSF() {
        return this.model.getType().equals(IPaletteModel.TYPE_JSF);
    }

    private boolean isMobile() {
        return this.model.getType().equals(IPaletteModel.TYPE_HTML5);
    }

    public void filter() {
        this.filter(PaletteSettings.getInstance().getFilterString());
    }

    public void filter(String text) {
        this.pattern.setPattern("*" + text);
        this.filter((PaletteContainer)this.model.getPaletteRoot());
    }

    private void refreshDynamicDrawer() {
        for (Object child : this.model.getPaletteRoot().getChildren()) {
            PaletteDrawerImpl c;
            if (!(child instanceof PaletteDrawerImpl) || !(c = (PaletteDrawerImpl)((Object)child)).getLabel().isEmpty()) continue;
            c.loadVersion(c.getPaletteGroup().getSelectedVersionGroup().getVersion());
            MobileDrawerEditPart part = (MobileDrawerEditPart)((Object)this.getViewer().getEditPartRegistry().get((Object)c));
            if (part == null) continue;
            HTML5DynamicDrawerFigure figure = (HTML5DynamicDrawerFigure)part.getFigure();
            figure.refresh();
        }
    }

    private void filter(PaletteContainer container) {
        for (Object child : container.getChildren()) {
            if (!(child instanceof PaletteContainer)) {
                if (!(child instanceof PaletteTool)) continue;
                PaletteTool entry = (PaletteTool)((Object)child);
                entry.setVisible(this.pattern.matches(entry.getPaletteItem().getKeywordsAsString()));
                continue;
            }
            if (child instanceof PaletteDrawerImpl) {
                PaletteDrawerImpl c = (PaletteDrawerImpl)((Object)child);
                String group = c.getLabel();
                if (!PaletteSettings.getInstance().isRecognizedGroupsOnly() || this.paletteContents.isRecognized(group)) {
                    c.setVisible(true);
                    this.filter((PaletteContainer)c);
                    continue;
                }
                c.setVisible(false);
                continue;
            }
            this.filter((PaletteContainer)child);
        }
        if (container instanceof PaletteDrawerImpl) {
            ((PaletteDrawerImpl)container).refresh();
        }
    }

    public Control createControl(Composite root) {
        Control result = null;
        this.model = PaletteModel.getInstance(this.paletteContents);
        this.viewer = new PaletteViewer(this.viewPart, this.model);
        if (this.isMobile()) {
            Composite container = new Composite(root, 4);
            container.setLayout((Layout)new GridLayout(1, false));
            this.filterText = new Text(container, 2948);
            GridData data = new GridData(768);
            this.filterText.setLayoutData((Object)data);
            this.filterText.setMessage(PaletteUIMessages.PALETTE_FILTER_MESSAGE);
            this.filterText.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    PaletteSettings.getInstance().setFilterString(PaletteAdapter.this.filterText.getText());
                    PaletteAdapter.this.filter();
                }
            });
            this.palette = this.viewer.createControl(container);
            this.palette.setLayoutData((Object)new GridData(1808));
            result = container;
            String storedFilter = PaletteSettings.getInstance().getFilterString();
            if (storedFilter != null && !storedFilter.isEmpty()) {
                this.filterText.setText(storedFilter);
            }
            if (PaletteSettings.getInstance().isRecognizedGroupsOnly() || storedFilter != null && !storedFilter.isEmpty()) {
                this.filter();
            }
        } else {
            result = this.palette = this.viewer.createControl(root);
        }
        this.viewer.setPaletteViewerPreferences((org.eclipse.gef.ui.palette.PaletteViewerPreferences)new PaletteViewerPreferences());
        PaletteRoot paletteRoot = this.model.getPaletteRoot();
        this.viewer.setPaletteRoot(paletteRoot);
        this.descriptionManager = new DescriptionManager(this.viewer);
        this.descriptionManager.install(this.palette);
        if (this.isJSF()) {
            this.dropManager = new DropTargetManager(this.viewer, this.model);
            this.dropManager.install(this.palette);
        }
        this.modelListener = new PaletteModelListener();
        if (this.model instanceof PaletteModel) {
            ((PaletteModel)this.model).addModelTreeListener(this.modelListener);
        }
        this.viewer.addDragStartSupport();
        return result;
    }

    public void setEnabled(boolean enabled) {
        if (this.viewer != null) {
            this.viewer.setEnabled(enabled);
        }
    }

    public void dispose() {
        if (this.model instanceof PaletteModel) {
            ((PaletteModel)this.model).removeModelTreeListener(this.modelListener);
        }
        if (this.isJSF()) {
            this.dropManager.dispose();
        }
        this.descriptionManager.dispose();
        this.viewPart.getActionBars().getToolBarManager().removeAll();
        this.viewer = null;
        this.viewPart = null;
    }

    public void setPaletteContents(PaletteContents contents) {
        this.paletteContents = (PagePaletteContents)contents;
        if (this.model != null) {
            this.model.setPaletteContents(this.paletteContents);
        }
    }

    private void reload(XModelObject lastAddedXCat) {
        if (this.viewer != null) {
            this.viewer.deselectAll();
        }
        if (this.model instanceof PaletteModel) {
            ((PaletteModel)this.model).load(lastAddedXCat);
        } else {
            this.model.load();
        }
        this.setEnabled(true);
    }

    private ImageDescriptor getImageDescriptor(String fileName) {
        try {
            URL url = new URL(BASE_URL, IMAGE_PATH + fileName);
            return ImageDescriptor.createFromURL((URL)url);
        }
        catch (MalformedURLException e) {
            WebUiPlugin.getDefault().logError(e);
            return ImageDescriptor.getMissingImageDescriptor();
        }
    }

    public PaletteViewer getViewer() {
        return this.viewer;
    }

    private class ClearDynamicGroupAction
    extends Action {
        public ClearDynamicGroupAction() {
            super(PaletteUIMessages.CLEAR_LAST_USED_MOST_POPULAR, null);
            this.setToolTipText(PaletteUIMessages.PALETTE_EDITOR);
        }

        public void run() {
            ((PaletteModelImpl)PaletteAdapter.this.model).clearDynamicGroup();
        }
    }

    private class ImportTLDAction
    extends Action {
        public ImportTLDAction() {
            super(PaletteUIMessages.IMPORT_TLD, PaletteAdapter.this.getImageDescriptor("tld_import.gif"));
            this.setToolTipText(PaletteUIMessages.IMPORT);
        }

        public void run() {
            if (PaletteAdapter.this.model instanceof PaletteModel) {
                ((PaletteModel)PaletteAdapter.this.model).runImportTLDDialog();
            }
        }
    }

    private class PaletteEditAction
    extends Action {
        public PaletteEditAction() {
            super(PaletteUIMessages.PALETTE_EDITOR, PaletteAdapter.this.getImageDescriptor("palette_editor.gif"));
            this.setToolTipText(PaletteUIMessages.PALETTE_EDITOR);
        }

        public void run() {
            if (PaletteAdapter.this.model instanceof PaletteModel) {
                ((PaletteModel)PaletteAdapter.this.model).openEditor(PaletteAdapter.this.palette.getShell());
            }
        }
    }

    private class PaletteFilterAction
    extends ContributionItem
    implements SelectionListener {
        private ToolItem filterTool;

        public void fill(ToolBar parent, int index) {
            this.filterTool = new ToolItem(parent, 32);
            this.filterTool.setImage(JSTWebUIImages.getInstance().getOrCreateImage(JSTWebUIImages.FILTER_IMAGE));
            this.filterTool.setToolTipText(PaletteUIMessages.PALETTE_FILTER_TOOLTIP);
            this.filterTool.addSelectionListener((SelectionListener)this);
            if (PaletteSettings.getInstance().isRecognizedGroupsOnly()) {
                this.filterTool.setSelection(true);
            }
        }

        public void widgetSelected(SelectionEvent e) {
            PaletteAdapter.this.isRecognizedGroupsOnly = this.filterTool.getSelection();
            PaletteSettings.getInstance().setRecognizedGroupsOnly(PaletteAdapter.this.isRecognizedGroupsOnly);
            PaletteAdapter.this.filter();
        }

        public void widgetDefaultSelected(SelectionEvent e) {
        }
    }

    private class PaletteModelListener
    implements XModelTreeListener {
        private boolean isTransaction = false;
        private boolean isDirty = false;
        private XModelObject lastAddedCat = null;

        private PaletteModelListener() {
        }

        public void nodeChanged(XModelTreeEvent event) {
            this.run(event);
        }

        public void structureChanged(XModelTreeEvent event) {
            this.run(event);
        }

        private void run(XModelTreeEvent event) {
            if ("transaction_begin".equals(event.getInfo())) {
                this.isTransaction = true;
                return;
            }
            if ("transaction_end".equals(event.getInfo())) {
                this.isTransaction = false;
                if (this.isDirty) {
                    this.isDirty = false;
                    PaletteAdapter.this.reload(this.lastAddedCat);
                    this.lastAddedCat = null;
                }
                return;
            }
            if (PaletteAdapter.this.model instanceof PaletteModel) {
                XModel xmodel = ((PaletteModel)PaletteAdapter.this.model).getXModel();
                XModelObject exo = event.getModelObject();
                boolean q = event.kind() == 3 && xmodel.getRoot().getPath().equals(exo.getPath());
                XModelObject xroot = xmodel.getRoot("Palette");
                if (xroot == null || this.isExist(xroot, event.getModelObject()) || q) {
                    Object info;
                    if (event.kind() == 1 && xroot != null && xroot.getPath().equals(exo.getPath()) && (info = event.getInfo()) instanceof XModelObject) {
                        this.lastAddedCat = (XModelObject)info;
                    }
                    if (this.isTransaction) {
                        this.isDirty = true;
                    } else {
                        PaletteAdapter.this.reload(this.lastAddedCat);
                        this.lastAddedCat = null;
                    }
                }
            }
        }

        private boolean isExist(XModelObject root, XModelObject modelObject) {
            if (root == null || modelObject == null) {
                return false;
            }
            if (modelObject.getPath() == null || root.getPath() == null) {
                return false;
            }
            return (String.valueOf(modelObject.getPath()) + "/").startsWith(String.valueOf(root.getPath()) + "/");
        }
    }

    private class ShowHideTabsAction
    extends Action {
        public ShowHideTabsAction() {
            super(PaletteUIMessages.SHOW_HIDE_TABS, PaletteAdapter.this.getImageDescriptor("visibility.gif"));
            this.setToolTipText(PaletteUIMessages.SHOW_HIDE);
        }

        public void run() {
            if (PaletteAdapter.this.model instanceof PaletteModel) {
                ((PaletteModel)PaletteAdapter.this.model).runShowHideDialog();
            }
        }
    }
}

