/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.jst.web.ui.palette;

import java.io.File;
import java.util.Properties;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IStorage;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.jface.util.LocalSelectionTransfer;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.dnd.DropTarget;
import org.eclipse.swt.dnd.DropTargetAdapter;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.FileTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.dnd.TransferData;
import org.eclipse.swt.widgets.Control;
import org.jboss.tools.common.model.XModelException;
import org.jboss.tools.common.model.XModelObject;
import org.jboss.tools.common.model.event.ActionDeclinedException;
import org.jboss.tools.common.model.project.IModelNature;
import org.jboss.tools.common.model.ui.dnd.DnDUtil;
import org.jboss.tools.common.model.ui.dnd.ModelTransfer;
import org.jboss.tools.common.model.util.EclipseResourceUtil;
import org.jboss.tools.common.reporting.ProblemReportingHelper;
import org.jboss.tools.jst.web.ui.palette.PaletteViewer;
import org.jboss.tools.jst.web.ui.palette.model.IPaletteModel;
import org.jboss.tools.jst.web.ui.palette.model.PaletteModel;
import org.jboss.tools.jst.web.ui.palette.model.PaletteXModelObject;

public class DropTargetManager
extends DropTargetAdapter {
    private DropTarget target = null;
    private PaletteViewer viewer;
    private PaletteModel model;

    public DropTargetManager(PaletteViewer viewer, IPaletteModel model) {
        this.viewer = viewer;
        this.model = (PaletteModel)model;
    }

    public void install(Control palette) {
        this.dispose();
        Transfer[] types = new Transfer[]{ModelTransfer.getInstance(), FileTransfer.getInstance(), LocalSelectionTransfer.getTransfer()};
        this.target = new DropTarget(palette, 3);
        this.target.setTransfer(types);
        this.target.addDropListener((DropTargetListener)this);
    }

    public void dispose() {
        if (this.target != null) {
            if (!this.target.isDisposed()) {
                this.target.removeDropListener((DropTargetListener)this);
                this.target.dispose();
            }
            this.target = null;
        }
    }

    public TransferData getSupportedData(TransferData[] data, Transfer transfer) {
        int i = 0;
        while (i < data.length) {
            if (transfer.isSupportedType(data[i])) {
                return data[i];
            }
            ++i;
        }
        return null;
    }

    public void dragOver(DropTargetEvent event) {
        XModelObject o = null;
        if (LocalSelectionTransfer.getTransfer().isSupportedType(event.currentDataType)) {
            XModelObject fo = this.getObjectFromLocalTransfer();
            if (fo != null && DnDUtil.isCopyEnabled((XModelObject)fo, null)) {
                DnDUtil.copy((XModelObject)fo, null);
                o = this.getModelObject(event.x, event.y);
            }
        } else {
            if (FileTransfer.getInstance().isSupportedType(event.currentDataType)) {
                event.detail = 1;
                return;
            }
            o = !ModelTransfer.getInstance().isSupportedType(event.currentDataType) ? null : this.getModelObject(event.x, event.y);
        }
        boolean enabled = o != null && DnDUtil.isPasteEnabled(o);
        event.detail = enabled ? 1 : 0;
    }

    public void drop(DropTargetEvent event) {
        XModelObject o = null;
        if (FileTransfer.getInstance().isSupportedType(event.currentDataType)) {
            File f = this.getFile(event);
            if (f != null) {
                XModelObject fo;
                IFile ef = EclipseResourceUtil.getFile((String)f.getAbsolutePath());
                XModelObject xModelObject = fo = ef == null ? null : EclipseResourceUtil.getObjectByResource((IResource)ef);
                if (fo != null && DnDUtil.isCopyEnabled((XModelObject)fo, null)) {
                    DnDUtil.copy((XModelObject)fo, null);
                    o = this.getModelObject(event.x, event.y);
                }
            }
        } else if (LocalSelectionTransfer.getTransfer().isSupportedType(event.currentDataType)) {
            XModelObject fo = this.getObjectFromLocalTransfer();
            if (fo != null && DnDUtil.isCopyEnabled((XModelObject)fo, null)) {
                DnDUtil.copy((XModelObject)fo, null);
                o = this.getModelObject(event.x, event.y);
            }
        } else {
            o = !ModelTransfer.getInstance().isSupportedType(event.currentDataType) ? null : this.getModelObject(event.x, event.y);
        }
        if (o != null) {
            try {
                DnDUtil.paste(o, (Properties)new Properties());
                this.model.saveOptions();
            }
            catch (ActionDeclinedException actionDeclinedException) {
            }
            catch (XModelException e) {
                this.message((Exception)((Object)e));
            }
        } else {
            event.detail = 0;
        }
    }

    private XModelObject getModelObject(int x, int y) {
        Object model;
        Control palette = this.target.getControl();
        org.eclipse.swt.graphics.Point p = palette.toControl(x, y);
        EditPart part = this.viewer.findObjectAt(new Point(p.x, p.y));
        if (part instanceof GraphicalEditPart && (model = part.getModel()) instanceof PaletteXModelObject) {
            return ((PaletteXModelObject)model).getXModelObject();
        }
        return null;
    }

    private void message(Exception e) {
        ProblemReportingHelper.reportProblem((String)"org.jboss.tools.jst.web.ui", (Throwable)e);
    }

    private File getFile(DropTargetEvent event) {
        String[] s = (String[])event.data;
        return s == null || s.length == 0 ? null : new File(s[0]);
    }

    XModelObject getObjectFromLocalTransfer() {
        ISelection s = LocalSelectionTransfer.getTransfer().getSelection();
        if (!(s instanceof IStructuredSelection)) {
            return null;
        }
        IStructuredSelection ss = (IStructuredSelection)s;
        Object obj = ss.getFirstElement();
        if (obj instanceof IStorage && obj.getClass().getName().indexOf("JarEntryFile") >= 0) {
            IStorage st = (IStorage)obj;
            return this.getObject(st);
        }
        if (obj instanceof IFile) {
            return EclipseResourceUtil.getObjectByResource((IResource)((IFile)obj));
        }
        if (obj instanceof XModelObject) {
            return (XModelObject)obj;
        }
        return null;
    }

    XModelObject getObject(IStorage st) {
        String str = st.toString();
        IProject p = this.getProject(str);
        String path = "/" + st.getFullPath().toString();
        IModelNature n = EclipseResourceUtil.getModelNature((IProject)p);
        if (n != null) {
            return n.getModel().getByPath(path);
        }
        return null;
    }

    IProject getProject(String jarEntryString) {
        if (jarEntryString == null || !jarEntryString.startsWith("JarEntryFile[")) {
            return null;
        }
        int i = (jarEntryString = jarEntryString.substring("JarEntryFile[".length())).indexOf("::");
        if (i < 0) {
            return null;
        }
        String zip = jarEntryString.substring(0, i);
        IFile f = EclipseResourceUtil.getFile((String)zip);
        return f == null ? null : f.getProject();
    }
}

