/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.jst.web.ui.internal.editor.support.kb;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IFileEditorInput;
import org.jboss.tools.common.model.XModel;
import org.jboss.tools.common.model.XModelObject;
import org.jboss.tools.common.model.filesystems.FileSystemsHelper;
import org.jboss.tools.common.model.util.EclipseResourceUtil;
import org.jboss.tools.jst.web.tld.FilePathEncoderFactory;
import org.jboss.tools.jst.web.tld.IFilePathEncoder;
import org.jboss.tools.jst.web.ui.WebUiPlugin;
import org.jboss.tools.jst.web.ui.internal.editor.outline.ValueHelper;
import org.jboss.tools.jst.web.ui.internal.editor.support.kb.ImagesFinder;
import org.jboss.tools.jst.web.ui.internal.editor.support.kb.WTPKbAbstractModelResource;

public class WTPKbImageFileResource
extends WTPKbAbstractModelResource {
    static Set<String> GRAPHIC_FILE_EXTENSIONS = new HashSet<String>();
    static Set<String> PAGE_FILE_EXTENSIONS = new HashSet<String>();
    String pathType = "absolute";
    String pathAddition = null;
    private IContainer webInfResource = null;
    private IContainer webRootResource = null;
    private IFile currentResource = null;
    Set<String> extensions = null;
    IFilePathEncoder encoder = null;

    static {
        String[] images = new String[]{"gif", "jpeg", "jpg", "png", "wbmp", "bmp"};
        int i = 0;
        while (i < images.length) {
            GRAPHIC_FILE_EXTENSIONS.add(images[i]);
            ++i;
        }
        String[] pages = new String[]{"jsp", "htm", "html", "xhtml", "xml"};
        int i2 = 0;
        while (i2 < pages.length) {
            PAGE_FILE_EXTENSIONS.add(pages[i2]);
            ++i2;
        }
    }

    public WTPKbImageFileResource(IEditorInput editorInput) {
        super(editorInput);
        if (this.fXModel != null) {
            XModelObject webInf = FileSystemsHelper.getWebInf((XModel)this.fXModel);
            XModelObject webRoot = FileSystemsHelper.getWebRoot((XModel)this.fXModel);
            if (webInf != null && webRoot != null) {
                this.webInfResource = (IContainer)EclipseResourceUtil.getResource((XModelObject)webInf);
                this.webRootResource = (IContainer)EclipseResourceUtil.getResource((XModelObject)webRoot);
            }
        }
        if (editorInput instanceof IFileEditorInput) {
            this.currentResource = ((IFileEditorInput)editorInput).getFile();
        }
    }

    public void setConstraint(String name, String value) {
        if ("extensions".equals(name)) {
            this.loadExtensions(value);
        } else if ("pathAddition".equals(name)) {
            this.pathAddition = value;
        } else if ("pathType".equals(name)) {
            this.pathType = value;
        }
    }

    public void clearConstraints() {
        this.extensions = null;
        this.pathType = "absolute";
        this.pathAddition = null;
    }

    void loadExtensions(String value) {
        if (value != null && !value.equals("*")) {
            if ("%image%".equals(value)) {
                this.extensions = GRAPHIC_FILE_EXTENSIONS;
            } else if ("%page%".equals(value)) {
                this.extensions = PAGE_FILE_EXTENSIONS;
            } else {
                StringTokenizer st = new StringTokenizer(value, ",;");
                if (st.countTokens() > 0) {
                    this.extensions = new HashSet<String>();
                    while (st.hasMoreTokens()) {
                        String t = st.nextToken().trim();
                        if (t.length() == 0) continue;
                        if ("%image%".equals(t)) {
                            this.extensions.addAll(GRAPHIC_FILE_EXTENSIONS);
                            continue;
                        }
                        if ("%page%".equals(t)) {
                            this.extensions.addAll(PAGE_FILE_EXTENSIONS);
                            continue;
                        }
                        this.extensions.add(t);
                    }
                }
            }
        }
    }

    public ImagePathDescriptor[] getImagesFilesPathes(String query) {
        if ((query = query.trim()).indexOf(92) > -1) {
            return new ImagePathDescriptor[0];
        }
        if (query.length() == 0) {
            query = "/";
        }
        int lastSeparator = query.lastIndexOf(47);
        String name = null;
        String pathWithoutLastSegment = null;
        if (lastSeparator > -1) {
            pathWithoutLastSegment = query.substring(0, lastSeparator);
            name = lastSeparator + 1 < query.length() ? query.substring(lastSeparator + 1, query.length()) : "";
        } else {
            pathWithoutLastSegment = "";
            name = query;
        }
        if (name.equals(".") || name.equals("..")) {
            pathWithoutLastSegment = pathWithoutLastSegment.length() > 0 ? String.valueOf(pathWithoutLastSegment) + "/" + name : (query.startsWith("/") ? "/" + name : name);
            name = "";
        }
        if (name == null) {
            name = "";
        }
        String startPath = pathWithoutLastSegment;
        if (pathWithoutLastSegment.startsWith("/")) {
            startPath = pathWithoutLastSegment.length() > 1 ? pathWithoutLastSegment.substring(1) : "";
        }
        IResource resource = query.startsWith("/") ? this.webRootResource.findMember(startPath) : this.currentResource.getParent().findMember(startPath);
        ArrayList<IResource> resources = new ArrayList<IResource>();
        try {
            if (resource != null) {
                resource.accept((IResourceVisitor)new ImagesFinder(resources, name, this.extensions));
            }
        }
        catch (CoreException e) {
            WebUiPlugin.getPluginLog().logError((Throwable)e);
        }
        ImagePathDescriptor[] filesPathes = new ImagePathDescriptor[resources.size()];
        int i = 0;
        while (i < filesPathes.length) {
            String prefix = pathWithoutLastSegment.toString();
            if (!prefix.endsWith("/")) {
                prefix = String.valueOf(prefix) + '/';
            }
            IResource r = (IResource)resources.get(i);
            filesPathes[i] = new ImagePathDescriptor(String.valueOf(prefix) + r.getName(), r);
            ++i;
        }
        return filesPathes;
    }

    public boolean isReadyToUse() {
        return this.webInfResource != null && this.webRootResource != null && this.currentResource != null;
    }

    public IContainer getWebRootResource() {
        return this.webRootResource;
    }

    public String getPathAddition() {
        return this.pathAddition;
    }

    public String encodePath(String path, String query, ValueHelper valueHelper) {
        if (valueHelper == null) {
            return path;
        }
        IFilePathEncoder iFilePathEncoder = this.encoder = valueHelper.getProject() == null ? null : FilePathEncoderFactory.getEncoder((IProject)valueHelper.getProject());
        if (this.encoder == null) {
            return path;
        }
        if (this.fXModelObject == null) {
            return path;
        }
        Properties context = new Properties();
        context.setProperty("pathType", this.pathType);
        if (this.pathAddition != null) {
            context.setProperty("pathAddition", this.pathAddition);
        }
        path = this.encoder.encode(path, this.fXModelObject, query, valueHelper.getTaglibManager(), context);
        return path;
    }

    public static class ImagePathDescriptor {
        private String queryPath;
        private IResource resource;

        public ImagePathDescriptor(String queryPath, IResource resource) {
            this.queryPath = queryPath;
            this.resource = resource;
        }

        public String getQueryPath() {
            return this.queryPath;
        }

        public IResource getResource() {
            return this.resource;
        }
    }
}

