/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.jst.web.ui.internal.editor.info;

import java.util.Arrays;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.ITypeRoot;
import org.eclipse.jdt.internal.ui.text.FastJavaPartitionScanner;
import org.eclipse.jdt.internal.ui.text.JavaWordFinder;
import org.eclipse.jdt.internal.ui.text.java.hover.JavadocHover;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.rules.IToken;
import org.jboss.tools.common.el.core.model.ELExpression;
import org.jboss.tools.common.el.core.model.ELInvocationExpression;
import org.jboss.tools.common.el.core.model.ELModel;
import org.jboss.tools.common.el.core.model.ELUtil;
import org.jboss.tools.common.el.core.parser.ELParser;
import org.jboss.tools.common.el.core.parser.ELParserUtil;
import org.jboss.tools.common.el.core.resolver.ELContext;
import org.jboss.tools.common.el.core.resolver.ELResolution;
import org.jboss.tools.common.el.core.resolver.ELResolver;
import org.jboss.tools.common.el.core.resolver.ELSegment;
import org.jboss.tools.common.el.core.resolver.JavaMemberELSegmentImpl;
import org.jboss.tools.common.el.ui.ca.ELProposalProcessor;
import org.jboss.tools.common.el.ui.internal.info.ELInfoHover;
import org.jboss.tools.jst.web.kb.PageContextFactory;
import org.jboss.tools.jst.web.kb.el.MessagePropertyELSegmentImpl;
import org.jboss.tools.jst.web.ui.WebUiPlugin;

public class JavaStringELInfoHover
extends JavadocHover {
    public IRegion getHoverRegion(ITextViewer textViewer, int offset) {
        return JavaWordFinder.findWord((IDocument)textViewer.getDocument(), (int)offset);
    }

    public Object getHoverInfo2(ITextViewer textViewer, IRegion region) {
        IToken token;
        IDocument document;
        IDocument iDocument = document = textViewer == null ? null : textViewer.getDocument();
        if (document == null) {
            return null;
        }
        int rangeStart = -1;
        int rangeLength = 0;
        IToken rangeToken = null;
        FastJavaPartitionScanner scanner = new FastJavaPartitionScanner();
        scanner.setRange(document, 0, document.getLength());
        while ((token = scanner.nextToken()) != null && !token.isEOF()) {
            int start = scanner.getTokenOffset();
            int length = scanner.getTokenLength();
            int end = start + length;
            if (start <= region.getOffset() && end >= region.getOffset()) {
                rangeStart = start;
                rangeLength = length;
                rangeToken = token;
                break;
            }
            if (start <= region.getOffset()) continue;
        }
        if (rangeToken == null || rangeStart == -1 || rangeLength <= 0 || !"__java_string".equals(rangeToken.getData())) {
            return null;
        }
        if (!this.checkStartPosition(document, region.getOffset())) {
            return null;
        }
        String text = null;
        try {
            text = document.get(rangeStart, rangeLength);
        }
        catch (BadLocationException e) {
            WebUiPlugin.getDefault().logError(e);
        }
        int inValueOffset = region.getOffset() - rangeStart;
        ELParser p = ELParserUtil.getJbossFactory().createParser();
        ELModel model = p.parse(text);
        ELInvocationExpression ie = ELUtil.findExpression((ELModel)model, (int)inValueOffset);
        if (ie == null) {
            return null;
        }
        ITypeRoot input = this.getEditorInputJavaElement();
        if (input == null) {
            return null;
        }
        IResource r = input.getResource();
        if (!(r instanceof IFile) || !r.exists() || r.getName().endsWith(".jar")) {
            return null;
        }
        IFile file = (IFile)r;
        ELContext context = PageContextFactory.createPageContext((IFile)file, (String)"org.eclipse.jdt.core.javaSource");
        ELResolver[] resolvers = context.getElResolvers();
        int i = 0;
        while (resolvers != null && i < resolvers.length) {
            block15: {
                ELSegment segment;
                block16: {
                    IJavaElement[] javaElements;
                    block17: {
                        ELResolution resolution;
                        ELResolution eLResolution = resolution = resolvers[i] == null ? null : resolvers[i].resolve(context, (ELExpression)ie, region.getOffset() + region.getLength());
                        if (resolution == null || (segment = resolution.getLastSegment()) == null || !segment.isResolved()) break block15;
                        if (!(segment instanceof JavaMemberELSegmentImpl)) break block16;
                        JavaMemberELSegmentImpl jmSegment = (JavaMemberELSegmentImpl)segment;
                        javaElements = jmSegment.getAllJavaElements();
                        if (javaElements != null && javaElements.length != 0) break block17;
                        if (jmSegment.getJavaElement() == null) break block15;
                        javaElements = new IJavaElement[]{jmSegment.getJavaElement()};
                    }
                    if (javaElements != null && javaElements.length != 0) {
                        Arrays.sort(javaElements, ELProposalProcessor.CASE_INSENSITIVE_ORDER);
                        return ELInfoHover.getHoverInfo((IJavaElement[])javaElements, null);
                    }
                    break block15;
                }
                if (segment instanceof MessagePropertyELSegmentImpl) {
                    MessagePropertyELSegmentImpl mpSegment = (MessagePropertyELSegmentImpl)segment;
                    return ELInfoHover.getHoverInfo((String)mpSegment.getBaseName(), (String)mpSegment.getBaseName(), (Object)mpSegment.getObjects(), null);
                }
            }
            ++i;
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean checkStartPosition(IDocument document, int offset) {
        try {
            while (true) {
                if (--offset < 0) {
                    return false;
                }
                if ('}' == document.getChar(offset)) {
                    return false;
                }
                if ('\"' == document.getChar(offset) && offset - 1 >= 0 && '\\' != document.getChar(offset - 1)) {
                    return false;
                }
                if ('{' != document.getChar(offset) || offset - 1 < 0) continue;
                if ('#' == document.getChar(offset - 1)) return true;
                if ('$' == document.getChar(offset - 1)) break;
            }
            return true;
        }
        catch (BadLocationException e) {
            WebUiPlugin.getDefault().logError(e);
        }
        return false;
    }
}

