/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.jst.web.ui.internal.css.dialog.tabs;

import java.util.ArrayList;
import java.util.Set;
import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.swt.custom.TreeEditor;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.swt.widgets.TreeItem;
import org.jboss.tools.jst.web.ui.internal.css.dialog.common.CSSConstants;
import org.jboss.tools.jst.web.ui.internal.css.dialog.common.StyleAttributes;
import org.jboss.tools.jst.web.ui.internal.css.dialog.tabs.BaseTabControl;
import org.jboss.tools.jst.web.ui.internal.editor.messages.JstUIMessages;

public class TabPropertySheetControl
extends BaseTabControl {
    private static final String[] COLUMNS = new String[]{JstUIMessages.PROPERTY_NAME_COLUMN, JstUIMessages.PROPERTY_VALUE_COLUMN};
    private static final int COLUMNS_WIDTH = 200;
    private Tree tree;

    public TabPropertySheetControl(Composite parent, StyleAttributes styleAttributes, DataBindingContext bindingContext) {
        super(bindingContext, styleAttributes, parent, 0);
        this.setLayout((Layout)new FillLayout());
        this.tree = new Tree((Composite)this, 98308);
        this.tree.setHeaderVisible(true);
        this.tree.setLinesVisible(true);
        int i = 0;
        while (i < COLUMNS.length) {
            TreeColumn column = new TreeColumn(this.tree, 16386);
            column.setText(COLUMNS[i]);
            column.setWidth(200);
            ++i;
        }
        Set<String> sections = CSSConstants.CSS_STYLES_MAP.keySet();
        for (String sectionKey : sections) {
            TreeItem sectionTreeItem = this.createTreeItem(this.tree, sectionKey);
            sectionTreeItem.setExpanded(true);
            ArrayList<String> attributeKeys = CSSConstants.CSS_STYLES_MAP.get(sectionKey);
            for (String attribute : attributeKeys) {
                TreeItem item = this.createBindedTreeItem(sectionTreeItem, attribute);
                item.setExpanded(true);
            }
            sectionTreeItem.setExpanded(true);
        }
        final TreeEditor editor = new TreeEditor(this.tree);
        editor.horizontalAlignment = 16384;
        editor.grabHorizontal = true;
        editor.minimumHeight = 0;
        editor.minimumWidth = 0;
        this.tree.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TreeItem item;
                Control oldEditor = editor.getEditor();
                if (oldEditor != null) {
                    oldEditor.dispose();
                }
                if ((item = (TreeItem)e.item) == null) {
                    return;
                }
                Control newEditor = null;
                if (!CSSConstants.CSS_STYLES_MAP.containsKey(item.getText(0))) {
                    newEditor = TabPropertySheetControl.this.createControl((Composite)TabPropertySheetControl.this.tree, item.getText(0));
                }
                if (newEditor != null) {
                    newEditor.setFocus();
                    Point size = newEditor.computeSize(-1, -1);
                    editor.minimumWidth = size.x;
                    editor.minimumHeight = size.y;
                    if (TabPropertySheetControl.this.tree.getColumn(1).getWidth() < editor.minimumWidth) {
                        TabPropertySheetControl.this.tree.getColumn(1).setWidth(editor.minimumWidth);
                    }
                    editor.setEditor(newEditor, item, 1);
                }
            }
        });
    }
}

