/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.jst.web.ui.internal.css.dialog.tabs;

import java.util.List;
import java.util.Map;
import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.UpdateValueStrategy;
import org.eclipse.core.databinding.observable.Observables;
import org.eclipse.core.databinding.observable.map.IObservableMap;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.databinding.validation.IValidator;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.databinding.swt.SWTObservables;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.ColorDialog;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.model.WorkbenchContentProvider;
import org.eclipse.ui.model.WorkbenchLabelProvider;
import org.jboss.tools.common.web.WebUtils;
import org.jboss.tools.jst.web.ui.WebUiPlugin;
import org.jboss.tools.jst.web.ui.internal.css.dialog.FontFamilyDialog;
import org.jboss.tools.jst.web.ui.internal.css.dialog.ImageSelectionDialog;
import org.jboss.tools.jst.web.ui.internal.css.dialog.common.CSSConstants;
import org.jboss.tools.jst.web.ui.internal.css.dialog.common.CSSStyleValueValidator;
import org.jboss.tools.jst.web.ui.internal.css.dialog.common.StyleAttributes;
import org.jboss.tools.jst.web.ui.internal.css.dialog.common.Util;
import org.jboss.tools.jst.web.ui.internal.css.dialog.tabs.ICSSTabControl;
import org.jboss.tools.jst.web.ui.internal.css.dialog.widgets.CSSTreeItemWidgetValueProperty;
import org.jboss.tools.jst.web.ui.internal.css.dialog.widgets.CSSWidget;
import org.jboss.tools.jst.web.ui.internal.css.dialog.widgets.CSSWidgetValueProperty;
import org.jboss.tools.jst.web.ui.internal.css.dialog.widgets.ImageCombo;
import org.jboss.tools.jst.web.ui.internal.css.dialog.widgets.SizeCombo;
import org.jboss.tools.jst.web.ui.internal.css.dialog.widgets.SizeText;
import org.jboss.tools.jst.web.ui.internal.editor.messages.JstUIMessages;
import org.jboss.tools.jst.web.ui.internal.editor.util.Constants;

public abstract class BaseTabControl
extends Composite
implements ICSSTabControl {
    private StyleAttributes styleAttributes = null;
    private DataBindingContext bindingContext;
    protected static final int NAME_ATTRIBUTE_COLUMN = 0;
    protected static final int VALUE_ATTRIBUTE_COLUMN = 1;
    protected static final int COMPOSITE_NUM_COLUMNS = 2;
    private static final int COLUMNS = 3;

    public BaseTabControl(DataBindingContext bindingContext, StyleAttributes styleAttributes, Composite parent, int style) {
        super(parent, style);
        this.setLayout((Layout)new GridLayout(3, false));
        this.styleAttributes = styleAttributes;
        this.bindingContext = bindingContext;
    }

    public StyleAttributes getStyleAttributes() {
        return this.styleAttributes;
    }

    public void setStyleAttributes(StyleAttributes styleAttributes) {
        this.styleAttributes = styleAttributes;
    }

    public DataBindingContext getBindingContext() {
        return this.bindingContext;
    }

    public void setBindingContext(DataBindingContext bindingContext) {
        this.bindingContext = bindingContext;
    }

    protected Label addLabel(Composite parent, String label) {
        Label labelControl = new Label(parent, 16384);
        labelControl.setLayoutData((Object)new GridData(3, 2, false, false));
        labelControl.setText(label);
        return labelControl;
    }

    protected Label addSectionLabel(Composite parent, String label) {
        Label labelControl = new Label(parent, 0);
        labelControl.setLayoutData((Object)new GridData(1, 2, false, false, 3, 1));
        labelControl.setFont(JFaceResources.getFontRegistry().get("org.eclipse.jface.bannerfont"));
        labelControl.setText(label);
        return labelControl;
    }

    protected Composite addFontComposite(Composite parent, String attribute) {
        Composite wrapper = this.createWrapperComposite(parent);
        final Text fontFamilyText = new Text(wrapper, 2052);
        fontFamilyText.setLayoutData((Object)new GridData(4, 2, true, false));
        Button button = this.createButton(wrapper, "images/cssdialog/font_large.gif", JstUIMessages.FONT_FAMILY_TIP);
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                FontFamilyDialog dialog = new FontFamilyDialog(BaseTabControl.this.getShell(), fontFamilyText.getText());
                if (dialog.open() == 0) {
                    fontFamilyText.setText(dialog.getFontFamily());
                }
            }
        });
        this.bind((Widget)fontFamilyText, attribute);
        return wrapper;
    }

    protected Composite addColorComposite(Composite parent, String attribute) {
        Composite wrapper = this.createWrapperComposite(parent);
        final ImageCombo colorCombo = new ImageCombo(wrapper, 2048);
        colorCombo.setLayoutData(new GridData(4, 2, true, false));
        for (Map.Entry<String, String> me : CSSConstants.COLORS_BY_NAME.entrySet()) {
            RGB rgb = Util.getColor(me.getValue());
            String name = CSSConstants.COLORS_BY_RGB.get(me.getValue());
            if (name == null) {
                name = me.getKey();
            }
            colorCombo.add(name, rgb);
        }
        Button button = this.createButton(wrapper, "images/cssdialog/color_large.gif", JstUIMessages.COLOR_TIP);
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                ColorDialog dlg = new ColorDialog(BaseTabControl.this.getShell());
                dlg.setRGB(Util.getColor(colorCombo.getText().trim()) == null ? Constants.RGB_BLACK : Util.getColor(colorCombo.getText().trim()));
                dlg.setText(JstUIMessages.COLOR_DIALOG_TITLE);
                RGB rgb = dlg.open();
                if (rgb != null) {
                    String colorStr = Util.createColorString(rgb);
                    colorCombo.setText(colorStr);
                }
            }
        });
        this.bind((Widget)colorCombo, attribute);
        return wrapper;
    }

    protected Composite addImageFileComposite(Composite parent, List<String> comboValues, final String attribute) {
        Composite wrapper = this.createWrapperComposite(parent);
        final Combo combo = new Combo(wrapper, 2048);
        combo.setLayoutData((Object)new GridData(4, 2, true, false));
        for (String string : comboValues) {
            combo.add(string);
        }
        Button button = this.createButton(wrapper, "images/cssdialog/folder_large.gif", JstUIMessages.BACKGROUND_IMAGE);
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                IResource project = Util.getCurrentProject();
                ImageSelectionDialog dialog = new ImageSelectionDialog(BaseTabControl.this.getShell(), (ILabelProvider)new WorkbenchLabelProvider(), (ITreeContentProvider)new WorkbenchContentProvider());
                dialog.setTitle(JstUIMessages.IMAGE_DIALOG_TITLE);
                dialog.setMessage(JstUIMessages.IMAGE_DIALOG_MESSAGE);
                dialog.setEmptyListMessage(JstUIMessages.IMAGE_DIALOG_EMPTY_MESSAGE);
                dialog.setAllowMultiple(false);
                dialog.setInput(project);
                IFile pageFile = BaseTabControl.this.getPageFile();
                String text = combo.getText();
                if (pageFile != null && text != null && text.length() > 0) {
                    if (text.startsWith("url(") && text.endsWith(")")) {
                        text = text.substring(4, text.length() - 1);
                    }
                    text = text.replace('\\', '/');
                    IPath path = pageFile.getFullPath().removeLastSegments(1);
                    IFile selectedFile = null;
                    if (text.startsWith("/")) {
                        IPath[] paths;
                        IPath[] iPathArray = paths = WebUtils.getWebContentPaths((IProject)pageFile.getProject());
                        int n = paths.length;
                        int n2 = 0;
                        while (n2 < n) {
                            IPath p = iPathArray[n2];
                            selectedFile = ResourcesPlugin.getWorkspace().getRoot().getFile(p.append(text.substring(1)));
                            if (selectedFile.exists()) break;
                            selectedFile = null;
                            ++n2;
                        }
                    }
                    if (selectedFile == null) {
                        while (path.segmentCount() >= 2) {
                            if (text.startsWith("/")) {
                                text = text.substring(1);
                                continue;
                            }
                            if (text.startsWith("./")) {
                                text = text.substring(2);
                                continue;
                            }
                            if (!text.startsWith("../")) break;
                            text = text.substring(3);
                            path = path.removeLastSegments(1);
                        }
                        path = path.append(text);
                        selectedFile = ResourcesPlugin.getWorkspace().getRoot().getFile(path);
                    }
                    if (selectedFile.exists()) {
                        dialog.setInitialSelection(selectedFile);
                    }
                }
                if (dialog.open() == 0 && pageFile != null) {
                    IFile imageFile = (IFile)dialog.getFirstResult();
                    String relativePath = BaseTabControl.computeRelativePath(pageFile, imageFile);
                    combo.add(relativePath);
                    combo.setText(relativePath);
                }
            }
        });
        this.bind((Widget)combo, attribute, new UpdateValueStrategy(){

            protected IStatus doSet(IObservableValue observableValue, Object value) {
                List values = CSSConstants.CSS_STYLE_VALUES_MAP.get(attribute);
                if (values != null && !values.contains(value)) {
                    value = BaseTabControl.adjustBackgroundURL((String)value);
                }
                return super.doSet(observableValue, value);
            }
        }, null);
        return wrapper;
    }

    private IFile getPageFile() {
        IWorkbenchPage page = WebUiPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow().getActivePage();
        if (page != null && page.getActiveEditor() != null && page.getActiveEditor().getEditorInput() instanceof IFileEditorInput) {
            return ((IFileEditorInput)page.getActiveEditor().getEditorInput()).getFile();
        }
        return null;
    }

    private static String computeRelativePath(IFile baseFile, IFile otherFile) {
        IPath basePath = baseFile.getLocation();
        IPath otherPath = otherFile.getLocation();
        String relativePath = otherPath.makeRelativeTo(basePath).toPortableString();
        if (relativePath.startsWith("..")) {
            relativePath = relativePath.replaceFirst("..", ".");
        }
        return relativePath;
    }

    protected Composite createWrapperComposite(Composite parent) {
        Composite wrapper = new Composite(parent, 0);
        GridLayout layout = new GridLayout(2, false);
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        wrapper.setLayout((Layout)layout);
        wrapper.setLayoutData((Object)new GridData(4, 2, true, false, 2, 1));
        return wrapper;
    }

    protected Composite addSizeCombo(Composite parent, List<String> comboValues, String attribute) {
        SizeCombo combo = new SizeCombo(parent, comboValues);
        this.bind((Widget)combo, attribute);
        return combo;
    }

    protected Composite addSizeText(Composite parent, String attribute) {
        SizeText combo = new SizeText(parent);
        this.bind((Widget)combo, attribute);
        return combo;
    }

    protected Text addText(Composite parent, String attribute) {
        GridData gridData = new GridData(4, 2, true, false);
        gridData.horizontalSpan = 2;
        Text text = new Text(parent, 2048);
        text.setLayoutData((Object)gridData);
        this.bind((Widget)text, attribute);
        return text;
    }

    protected Combo addCombo(Composite parent, List<String> comboValues, String attribute) {
        GridData gridData = new GridData(4, 2, true, false);
        gridData.horizontalSpan = 2;
        Combo combo = new Combo(parent, 2048);
        combo.setLayoutData((Object)gridData);
        for (String str : comboValues) {
            combo.add(str);
        }
        this.bind((Widget)combo, attribute);
        return combo;
    }

    protected TreeItem createBindedTreeItem(TreeItem parent, String attribute) {
        TreeItem item = new TreeItem(parent, 0);
        item.setText(0, attribute);
        this.bind((Widget)item, attribute);
        return item;
    }

    protected TreeItem createTreeItem(Tree parent, String text) {
        TreeItem item = new TreeItem(parent, 0);
        item.setText(text);
        return item;
    }

    private Button createButton(Composite parent, String imageFile, String tooltip) {
        Button button = new Button(parent, 8);
        button.setLayoutData((Object)new GridData(3, 2, false, false));
        button.setToolTipText(tooltip);
        button.setImage(WebUiPlugin.getImageDescriptor(imageFile).createImage());
        button.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                Button button = (Button)e.getSource();
                button.getImage().dispose();
            }
        });
        return button;
    }

    protected Control createControl(Composite parent, String property) {
        Object control = null;
        control = CSSConstants.CSS_STYLE_VALUES_MAP.keySet().contains(property) ? (property.indexOf("color") != -1 ? this.addColorComposite(parent, property) : (Constants.elemFolder.contains(property) ? this.addImageFileComposite(parent, (List<String>)CSSConstants.CSS_STYLE_VALUES_MAP.get(property), property) : (Constants.extElem.contains(property) ? this.addSizeCombo(parent, (List<String>)CSSConstants.CSS_STYLE_VALUES_MAP.get(property), property) : this.addCombo(parent, (List<String>)CSSConstants.CSS_STYLE_VALUES_MAP.get(property), property)))) : (property.equalsIgnoreCase("font-family") ? this.addFontComposite(parent, property) : (Constants.extElem.contains(property) ? this.addSizeText(parent, property) : this.addText(parent, property)));
        return control;
    }

    private static String adjustBackgroundURL(String backgroundURL) {
        if (backgroundURL != null && !backgroundURL.trim().equals("") && !backgroundURL.matches("(url)\\(.*\\)")) {
            return "url(" + backgroundURL + ")";
        }
        return backgroundURL;
    }

    private IObservableValue createAttributeObservableValue(String attributeName) {
        return Observables.observeMapEntry((IObservableMap)this.getStyleAttributes().getObservableMap(), (Object)attributeName, String.class);
    }

    private void bind(Widget widget, String attribute) {
        this.bind(widget, attribute, null, null);
    }

    private void bind(Widget widget, String attribute, UpdateValueStrategy targetToModel, UpdateValueStrategy modelToTarget) {
        IObservableValue attributeValue = this.createAttributeObservableValue(attribute);
        if (targetToModel == null) {
            targetToModel = new UpdateValueStrategy();
        }
        targetToModel.setBeforeSetValidator((IValidator)CSSStyleValueValidator.getInstance());
        if (widget instanceof Text) {
            this.getBindingContext().bindValue((IObservableValue)SWTObservables.observeText((Control)((Text)widget), (int)24), attributeValue, targetToModel, modelToTarget);
        } else if (widget instanceof Combo) {
            this.getBindingContext().bindValue((IObservableValue)SWTObservables.observeText((Widget)widget), attributeValue, targetToModel, modelToTarget);
        } else if (widget instanceof CSSWidget) {
            this.getBindingContext().bindValue((IObservableValue)new CSSWidgetValueProperty().observe(widget), attributeValue, targetToModel, modelToTarget);
        } else if (widget instanceof TreeItem) {
            this.getBindingContext().bindValue((IObservableValue)new CSSTreeItemWidgetValueProperty(1).observe(widget), attributeValue, targetToModel, modelToTarget);
        }
    }

    @Override
    public void update() {
    }
}

