/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.common.verification.ui.actions;

import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.handlers.HandlerUtil;
import org.eclipse.wst.validation.MutableProjectSettings;
import org.eclipse.wst.validation.ValidationFramework;
import org.eclipse.wst.validation.Validator;
import org.eclipse.wst.validation.internal.ValManager;
import org.eclipse.wst.validation.internal.ValPrefManagerProject;
import org.eclipse.wst.validation.internal.ValidatorMutable;
import org.eclipse.wst.validation.internal.model.FilterGroup;
import org.eclipse.wst.validation.internal.model.FilterRule;
import org.eclipse.wst.validation.internal.model.ProjectPreferences;
import org.jboss.tools.common.verification.ui.Messages;
import org.jboss.tools.common.verification.ui.XStudioVerificationPlugin;

public class IncludeResourceHandler
extends AbstractHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        ISelection selection = HandlerUtil.getCurrentSelection((ExecutionEvent)event);
        if (selection instanceof IStructuredSelection) {
            for (Object element : (IStructuredSelection)selection) {
                IResource resource;
                if (!(element instanceof IAdaptable) || (resource = (IResource)((IAdaptable)element).getAdapter(IResource.class)) == null) continue;
                this.includeResource(resource);
            }
        }
        return null;
    }

    private void includeResource(IResource resource) {
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        Shell shell = window.getShell();
        boolean include = MessageDialog.openQuestion((Shell)shell, (String)Messages.IncludeResourceHandler_Include_Validation, (String)NLS.bind((String)Messages.IncludeResourceHandler_Are_you_sure_you_want_to_include_all_V2_validators, (Object)resource.getName()));
        if (!include) {
            return;
        }
        if (resource.getType() == 4) {
            ValidationFramework.getDefault().enableValidation(resource);
        } else {
            IProject project = resource.getProject();
            MutableProjectSettings projectSettings = ValidationFramework.getDefault().getProjectSettings(project);
            projectSettings.setOverride(true);
            Validator[] validators = ValManager.getDefault().getValidatorsConfiguredForProject(project, ValManager.UseProjectPreferences.MustUse);
            String resourcePattern = resource.getProjectRelativePath().toString();
            ValidatorMutable[] changedValidator = new ValidatorMutable[validators.length];
            int i = 0;
            while (i < validators.length) {
                ValidatorMutable validator;
                changedValidator[i] = validator = new ValidatorMutable(validators[i]);
                if (validator.isV2Validator()) {
                    FilterGroup[] groups = validator.getGroups();
                    int j = 0;
                    while (j < groups.length) {
                        if (groups[j].isExclude()) {
                            FilterGroup group = groups[j];
                            FilterRule[] rules = group.getRules();
                            int k = 0;
                            while (k < rules.length) {
                                FilterRule rule = rules[k];
                                String pattern = rule.getPattern();
                                String type = rule.getType();
                                if ("file".equals(type) && pattern != null && pattern.equals(resourcePattern)) {
                                    FilterGroup.removeRule((FilterGroup)group, (FilterRule)rule);
                                    FilterGroup newGroup = FilterGroup.removeRule((FilterGroup)group, (FilterRule)rule);
                                    validator.replaceFilterGroup(group, newGroup);
                                }
                                ++k;
                            }
                        }
                        ++j;
                    }
                }
                ++i;
            }
            ValidationFramework.getDefault().applyChanges(projectSettings, true);
            ValidationFramework.getDefault().applyChanges(projectSettings, true);
            ProjectPreferences pp = new ProjectPreferences(project, projectSettings.getOverride(), projectSettings.getSuspend(), null);
            ValPrefManagerProject vpm = new ValPrefManagerProject(project);
            vpm.savePreferences(pp, changedValidator);
        }
        try {
            resource.setPersistentProperty(XStudioVerificationPlugin.RESOURCE_EXCLUDED, null);
        }
        catch (CoreException ignore) {
            ignore.printStackTrace();
        }
    }
}

