/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.common.jdt.debug.ui.launching;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationType;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.core.ILaunchManager;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.internal.dialogs.WorkbenchPreferenceDialog;
import org.jboss.tools.common.jdt.debug.RemoteDebugActivator;
import org.jboss.tools.common.jdt.debug.VmModel;
import org.jboss.tools.common.jdt.debug.ui.RemoteDebugUIActivator;
import org.jboss.tools.common.jdt.debug.ui.actions.RemoteLaunchAction;
import org.jboss.tools.common.jdt.debug.ui.preferences.AutoResizeTableLayout;

public class LaunchRemoteApplicationDialog
extends Dialog {
    private VmModel[] vmModels;
    private TableViewer viewer;
    private Combo configurationsCombo;
    private Button customPort;
    private Text customPortVal;

    public LaunchRemoteApplicationDialog(Shell parentShell) {
        super(parentShell);
        this.setShellStyle(0xC70 | LaunchRemoteApplicationDialog.getDefaultOrientation());
        this.vmModels = RemoteDebugUIActivator.getDefault().getCurrentDebugModels();
    }

    protected Control createDialogArea(Composite parent) {
        this.getShell().setText("Remote Java Application");
        Composite area = (Composite)super.createDialogArea(parent);
        Composite contents = new Composite(area, 0);
        GridData gd = new GridData(1808);
        gd.heightHint = 400;
        gd.widthHint = 600;
        contents.setLayoutData((Object)gd);
        contents.setLayout((Layout)new GridLayout(1, false));
        LaunchRemoteApplicationDialog.applyDialogFont((Control)contents);
        this.initializeDialogUnits((Control)area);
        Composite messageComposite = new Composite(contents, 0);
        gd = new GridData(4, 4, true, false);
        messageComposite.setLayoutData((Object)gd);
        messageComposite.setLayout((Layout)new GridLayout(1, false));
        Label pathLabel = new Label(messageComposite, 0);
        pathLabel.setText("Found " + this.vmModels.length + " Remote Java Application's. Please select which application you want to connect the debugger to.");
        this.viewer = new TableViewer(contents, 68356);
        gd = new GridData(1808);
        gd.heightHint = 250;
        this.viewer.getTable().setLayoutData((Object)gd);
        final Table table = this.viewer.getTable();
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        table.setFont(parent.getFont());
        table.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                int selection = table.getSelectionIndex();
                Button okButton = LaunchRemoteApplicationDialog.this.getButton(0);
                if (selection < 0 || selection >= LaunchRemoteApplicationDialog.this.vmModels.length) {
                    okButton.setEnabled(false);
                } else {
                    okButton.setEnabled(true);
                }
            }
        });
        this.viewer.setContentProvider((IContentProvider)new RemoteApplicationContentProvider());
        String[] columnHeaders = new String[]{"PID", "Port", "Class", "Arguments"};
        int i = 0;
        while (i < columnHeaders.length) {
            TableViewerColumn column = new TableViewerColumn(this.viewer, 0);
            column.setLabelProvider((CellLabelProvider)new RemoteApplicationLabelProvider(i));
            column.getColumn().setText(columnHeaders[i]);
            column.getColumn().setResizable(true);
            column.getColumn().setMoveable(true);
            ++i;
        }
        ColumnLayoutData[] remoteApplicationLayouts = new ColumnLayoutData[]{new ColumnWeightData(80, 80), new ColumnWeightData(80, 80), new ColumnWeightData(200, 200), new ColumnWeightData(200, 200)};
        AutoResizeTableLayout tableLayout = new AutoResizeTableLayout(table);
        int i2 = 0;
        while (i2 < remoteApplicationLayouts.length) {
            tableLayout.addColumnData(remoteApplicationLayouts[i2]);
            ++i2;
        }
        this.viewer.getTable().setLayout((Layout)tableLayout);
        this.viewer.setInput((Object)this.vmModels);
        this.viewer.getTable().select(0);
        Composite configurationComposite = new Composite(contents, 0);
        configurationComposite.setLayout((Layout)new GridLayout(2, false));
        gd = new GridData(4, 4, true, false);
        configurationComposite.setLayoutData((Object)gd);
        Label configurationLabel = new Label(configurationComposite, 0);
        gd = new GridData(4, 4, false, false);
        configurationLabel.setLayoutData((Object)gd);
        configurationLabel.setText("Configurations:");
        this.configurationsCombo = new Combo(configurationComposite, 0);
        gd = new GridData(4, 4, true, false);
        this.configurationsCombo.setLayoutData((Object)gd);
        this.configureCombo();
        Composite wrapper = new Composite(contents, 0);
        wrapper.setLayout((Layout)new GridLayout(2, false));
        this.customPort = new Button(wrapper, 32);
        this.customPort.setText("Custize debugger port: ");
        this.customPort.setSelection(false);
        this.customPort.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                LaunchRemoteApplicationDialog.this.customPortVal.setEnabled(LaunchRemoteApplicationDialog.this.customPort.getSelection());
            }
        });
        this.customPortVal = new Text(wrapper, 2048);
        this.customPortVal.setEnabled(false);
        final Button autoButton = new Button(contents, 32);
        gd = new GridData(4, 4, true, false);
        messageComposite.setLayoutData((Object)gd);
        autoButton.setText("Automatically connect if only one application found");
        autoButton.setSelection(RemoteDebugUIActivator.getDefault().isAutoConnect());
        autoButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                RemoteDebugUIActivator.getDefault().setAutoConnect(autoButton.getSelection());
            }
        });
        return area;
    }

    private void configureCombo() {
        String[] configurations = this.getConfigurations();
        this.configurationsCombo.setItems(configurations);
        this.configurationsCombo.select(this.getDefaultConfigurationIndex(configurations));
    }

    private int getDefaultConfigurationIndex(String[] configurations) {
        if (configurations.length == 0) {
            return 0;
        }
        ILaunchConfiguration defaultConfiguration = RemoteDebugActivator.getDefault().getDefaultLaunchConfiguration();
        if (defaultConfiguration == null) {
            return 0;
        }
        int i = 0;
        while (i < configurations.length) {
            String name = configurations[i];
            if (name.equals(defaultConfiguration.getName())) {
                return i;
            }
            ++i;
        }
        return 0;
    }

    private String[] getConfigurations() {
        ILaunchConfiguration[] configs = RemoteDebugActivator.getDefault().getLaunchConfigurations();
        if (configs == null || configs.length == 0) {
            try {
                ILaunchManager manager = DebugPlugin.getDefault().getLaunchManager();
                ILaunchConfigurationType type = manager.getLaunchConfigurationType(RemoteDebugActivator.REMOTE_JAVA_APPLICATION_ID);
                ILaunchConfigurationWorkingCopy config = RemoteDebugActivator.createNewLaunchConfiguration((ILaunchConfigurationType)type);
                return new String[]{config.getName()};
            }
            catch (CoreException e) {
                RemoteDebugUIActivator.log(e);
                return new String[0];
            }
        }
        String[] configNames = new String[configs.length];
        int i = 0;
        while (i < configs.length) {
            configNames[i] = configs[i].getName();
            ++i;
        }
        return configNames;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 2, "Configure...", false);
        super.createButtonsForButtonBar(parent);
        Button okButton = this.getButton(0);
        okButton.setText("Debug");
    }

    protected void okPressed() {
        String port = null;
        if (this.customPort.getSelection()) {
            port = this.customPortVal.getText();
        } else {
            VmModel vmModel = this.vmModels[this.viewer.getTable().getSelectionIndex()];
            port = vmModel.getPort();
        }
        String configurationName = this.configurationsCombo.getText();
        ILaunchConfiguration[] configurations = RemoteDebugActivator.getDefault().getLaunchConfigurations();
        ILaunchConfiguration selectedConfiguration = null;
        ILaunchConfiguration[] iLaunchConfigurationArray = configurations;
        int n = configurations.length;
        int n2 = 0;
        while (n2 < n) {
            ILaunchConfiguration configuration = iLaunchConfigurationArray[n2];
            if (configurationName.equals(configuration.getName())) {
                selectedConfiguration = configuration;
            } else {
                this.setDefault(configuration, false);
            }
            ++n2;
        }
        if (selectedConfiguration != null) {
            this.setDefault(selectedConfiguration, true);
        }
        super.okPressed();
        new RemoteLaunchAction(port).run();
    }

    private void setDefault(ILaunchConfiguration configuration, boolean value) {
        try {
            boolean isDefault = configuration.getAttribute("setAsDefault", false);
            if (isDefault != value) {
                ILaunchConfigurationWorkingCopy wc = configuration.getWorkingCopy();
                wc.setAttribute("setAsDefault", value);
                wc.doSave();
            }
        }
        catch (CoreException e) {
            RemoteDebugUIActivator.log(e);
        }
    }

    protected void buttonPressed(int buttonId) {
        if (buttonId == 2) {
            Shell shell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
            WorkbenchPreferenceDialog dialog = WorkbenchPreferenceDialog.createDialogOn((Shell)shell, (String)"org.jboss.tools.common.jdt.debug.ui.preferences.RemoteDebugPreferencePage");
            dialog.open();
            this.configureCombo();
        } else {
            super.buttonPressed(buttonId);
        }
    }

    class RemoteApplicationContentProvider
    implements IStructuredContentProvider {
        RemoteApplicationContentProvider() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }

        public Object[] getElements(Object inputElement) {
            return LaunchRemoteApplicationDialog.this.vmModels;
        }

        public void dispose() {
        }
    }

    class RemoteApplicationLabelProvider
    extends ColumnLabelProvider {
        private int columnIndex;

        public RemoteApplicationLabelProvider(int i) {
            this.columnIndex = i;
        }

        public String getText(Object element) {
            if (element instanceof VmModel) {
                VmModel model = (VmModel)element;
                switch (this.columnIndex) {
                    case 0: {
                        return model.getPid();
                    }
                    case 1: {
                        return model.getPort();
                    }
                    case 2: {
                        return model.getMainClass();
                    }
                    case 3: {
                        return model.getMainArgs();
                    }
                }
            }
            return null;
        }

        public Image getImage(Object element) {
            return null;
        }
    }
}

