/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.common.jdt.debug.ui.actions;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.internal.ui.stringsubstitution.SelectedResourceManager;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.ITypeRoot;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.debug.ui.JDIDebugUIPlugin;
import org.eclipse.jdt.internal.debug.ui.launcher.LauncherMessages;
import org.eclipse.jdt.ui.JavaUI;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.jboss.tools.common.jdt.debug.RemoteDebugActivator;
import org.jboss.tools.common.jdt.debug.ui.internal.SelectionUtil;

public class RemoteLaunchAction
extends Action {
    private String port;

    public RemoteLaunchAction(String port) {
        this.port = port;
    }

    public void run() {
        IStructuredSelection ss = SelectedResourceManager.getDefault().getCurrentSelection();
        Object o = ss.getFirstElement();
        if (o instanceof IEditorPart) {
            this.launch((IEditorPart)o);
        } else {
            this.launch((ISelection)ss);
        }
    }

    private void launch(ISelection selection) {
        IResource resource = SelectionUtil.getLaunchableResource(selection);
        IJavaProject javaProject = null;
        if (resource != null) {
            IProject project = resource.getProject();
            javaProject = JavaCore.create((IProject)project);
        }
        ILaunchConfiguration config = this.createOrGetDefaultLaunchConfiguration(javaProject, selection);
        DebugUITools.launch((ILaunchConfiguration)config, (String)"debug");
    }

    private void launch(IEditorPart editor) {
        IResource resource = this.getLaunchableResource(editor);
        IJavaProject javaProject = null;
        if (resource != null) {
            IProject project = resource.getProject();
            javaProject = JavaCore.create((IProject)project);
        }
        ILaunchConfiguration config = this.createOrGetDefaultLaunchConfiguration(javaProject, null);
        DebugUITools.launch((ILaunchConfiguration)config, (String)"debug");
    }

    public void runWithEvent(Event event) {
        this.run();
    }

    private IResource getLaunchableResource(IEditorPart editorpart) {
        ITypeRoot element = JavaUI.getEditorInputTypeRoot((IEditorInput)editorpart.getEditorInput());
        if (element != null) {
            try {
                return element.getCorrespondingResource();
            }
            catch (JavaModelException javaModelException) {}
        }
        return null;
    }

    protected ILaunchConfiguration createOrGetDefaultLaunchConfiguration(IJavaProject javaProject, ISelection selection) {
        Object[] all;
        IResource resource;
        ILaunchConfiguration config = RemoteDebugActivator.getDefault().getDefaultLaunchConfiguration();
        if (javaProject == null && SelectionUtil.getJavaElements(selection).length == 0 && (resource = SelectionUtil.getLaunchableResource(selection = new StructuredSelection(all = ResourcesPlugin.getWorkspace().getRoot().getProjects()))) != null) {
            IProject project = resource.getProject();
            javaProject = JavaCore.create((IProject)project);
        }
        try {
            return RemoteDebugActivator.createOrGetDefaultLaunchConfiguration((String)this.port, (String)"localhost", (IJavaProject)javaProject, (IJavaElement[])SelectionUtil.getJavaElements(selection));
        }
        catch (CoreException exception) {
            MessageDialog.openError((Shell)JDIDebugUIPlugin.getActiveWorkbenchShell(), (String)LauncherMessages.JavaLaunchShortcut_3, (String)exception.getStatus().getMessage());
            return config;
        }
    }
}

