/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.ui.swt.gef.model;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.sapphire.ui.diagram.editor.ShapePart;
import org.eclipse.sapphire.ui.swt.gef.model.DiagramNodeModel;
import org.eclipse.sapphire.ui.swt.gef.model.ShapeModel;
import org.eclipse.sapphire.ui.swt.gef.presentation.ContainerShapePresentation;
import org.eclipse.sapphire.ui.swt.gef.presentation.ShapePresentation;

public class ContainerShapeModel
extends ShapeModel {
    public static final String SHAPE_VISIBILITY_UPDATES = "SHAPE_VISIBILITY_UPDATES";
    private List<ShapeModel> children = new ArrayList<ShapeModel>();

    public ContainerShapeModel(DiagramNodeModel nodeModel, ShapeModel parent, ContainerShapePresentation presentation) {
        super(nodeModel, parent, presentation);
        for (ShapePresentation shapePresentation : presentation.getChildren()) {
            ShapeModel childModel = ShapeModel.ShapeModelFactory.createShapeModel(nodeModel, this, shapePresentation);
            if (childModel == null) continue;
            this.children.add(childModel);
        }
        presentation.init(this);
    }

    public void refreshChildren() {
        ContainerShapePresentation presentation = this.getContainerShapePresentation();
        presentation.refreshChildren();
        ArrayList<ShapeModel> refreshedChildren = new ArrayList<ShapeModel>();
        for (ShapePresentation shapePresentation : presentation.getChildren()) {
            ShapeModel childModel = this.getChildShapeModel(shapePresentation);
            if (childModel == null) {
                childModel = ShapeModel.ShapeModelFactory.createShapeModel(this.getNodeModel(), this, shapePresentation);
            }
            if (childModel == null) continue;
            refreshedChildren.add(childModel);
        }
        this.children = refreshedChildren;
    }

    private ShapeModel getChildShapeModel(ShapePresentation shapePresentation) {
        for (ShapeModel model : this.getChildren()) {
            if (model.getShapePresentation().part() != shapePresentation.part()) continue;
            return model;
        }
        return null;
    }

    private ContainerShapePresentation getContainerShapePresentation() {
        return (ContainerShapePresentation)this.getShapePresentation();
    }

    public List<ShapeModel> getChildren() {
        return this.children;
    }

    public void handleVisibilityChange(ShapePart shapePart) {
        this.refreshChildren();
        this.firePropertyChange(SHAPE_VISIBILITY_UPDATES, null, shapePart);
    }
}

