/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.maven.sourcelookup.ui.browsers;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.debug.internal.ui.DebugPluginImages;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.wst.server.core.IServer;
import org.eclipse.wst.server.core.ServerCore;
import org.jboss.ide.eclipse.as.core.server.IJBossServer;
import org.jboss.ide.eclipse.as.core.server.IJBossServerRuntime;
import org.jboss.ide.eclipse.as.core.util.ServerConverter;
import org.jboss.tools.maven.sourcelookup.ui.SourceLookupUIActivator;

public class JBossSourceContainerDialog
extends TitleAreaDialog {
    private TableViewer viewer;
    private static final int SIZING_SELECTION_WIDGET_HEIGHT = 250;
    private static final int SIZING_SELECTION_WIDGET_WIDTH = 300;
    private String homePath;
    private Image image;

    public JBossSourceContainerDialog(Shell parentShell) {
        super(parentShell);
        this.setShellStyle(this.getShellStyle() | 0x10);
        this.image = SourceLookupUIActivator.imageDescriptorFromPlugin((String)"org.jboss.tools.maven.sourcelookup.ui", (String)"icons/jboss.gif").createImage();
    }

    public List<IJBossServerRuntime> getRuntimes() {
        IServer[] servers = ServerCore.getServers();
        ArrayList<IJBossServerRuntime> runtimes = new ArrayList<IJBossServerRuntime>();
        if (servers != null) {
            IServer[] iServerArray = servers;
            int n = servers.length;
            int n2 = 0;
            while (n2 < n) {
                IJBossServerRuntime runtime;
                IServer server = iServerArray[n2];
                IJBossServer jbossServer = null;
                try {
                    jbossServer = ServerConverter.checkedGetJBossServer((IServer)server);
                }
                catch (CoreException e) {
                    SourceLookupUIActivator.log(e);
                }
                if (jbossServer != null && (runtime = jbossServer.getRuntime()) != null) {
                    runtimes.add(runtime);
                }
                ++n2;
            }
        }
        return runtimes;
    }

    protected void configureShell(Shell newShell) {
        newShell.setText("Runtime Selection");
        super.configureShell(newShell);
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        this.setMessage("Select Server Runtime");
        this.setTitle("Add a container to the source lookup path");
        this.setTitleImage(DebugPluginImages.getImage((String)"IMG_ADD_SRC_LOCATION"));
        this.initializeDialogUnits((Control)composite);
        this.viewer = new TableViewer(composite, 2820);
        GridData data = new GridData(1808);
        data.heightHint = 250;
        data.widthHint = 300;
        this.viewer.getTable().setLayoutData((Object)data);
        this.viewer.setLabelProvider((IBaseLabelProvider)new RuntimeLabelProvider());
        this.viewer.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        List<IJBossServerRuntime> runtimes = this.getRuntimes();
        this.viewer.setInput(runtimes);
        this.viewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                IStructuredSelection structuredSelection;
                Object object;
                ISelection selection = event.getSelection();
                if (selection instanceof IStructuredSelection && (object = (structuredSelection = (IStructuredSelection)selection).getFirstElement()) instanceof IJBossServerRuntime) {
                    IJBossServerRuntime runtime = (IJBossServerRuntime)object;
                    JBossSourceContainerDialog.this.setHomePath(runtime);
                }
            }
        });
        this.viewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                JBossSourceContainerDialog.this.okPressed();
            }
        });
        if (runtimes.size() > 0) {
            this.viewer.getTable().select(0);
            this.setHomePath(runtimes.get(0));
        }
        Dialog.applyDialogFont((Control)composite);
        return composite;
    }

    protected void setHomePath(IJBossServerRuntime runtime) {
        if (runtime != null) {
            IPath location = runtime.getRuntime().getLocation();
            this.homePath = location.toOSString();
        }
    }

    protected void createButtonsForButtonBar(Composite parent) {
        Button chooseHomeButton = this.createButton(parent, 2, "Choose Home...", false);
        chooseHomeButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DirectoryDialog dialog = new DirectoryDialog(JBossSourceContainerDialog.this.getShell());
                dialog.setMessage("Choose Home:");
                String path = dialog.open();
                if (path != null) {
                    JBossSourceContainerDialog.this.setHomePath(path);
                    JBossSourceContainerDialog.this.okPressed();
                }
            }
        });
        super.createButtonsForButtonBar(parent);
    }

    public String getHomePath() {
        return this.homePath;
    }

    public void setHomePath(String homePath) {
        this.homePath = homePath;
    }

    public boolean close() {
        this.image.dispose();
        return super.close();
    }

    private class RuntimeLabelProvider
    extends LabelProvider {
        private RuntimeLabelProvider() {
        }

        public String getText(Object element) {
            IJBossServerRuntime runtime;
            if (element instanceof IJBossServerRuntime && (runtime = (IJBossServerRuntime)element).getRuntime() != null) {
                return runtime.getRuntime().getName();
            }
            return super.getText(element);
        }

        public Image getImage(Object element) {
            return JBossSourceContainerDialog.this.image;
        }
    }
}

