/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.livereload.core.internal.util;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceDelta;

public class ResourceChangeEventVisitor {
    public static List<IResource> getAffectedFiles(IResourceChangeEvent event) {
        CallBack callBack = new CallBack();
        callBack.addIfFile(event.getResource());
        ResourceChangeEventVisitor.visitEventDelta(event.getDelta(), callBack);
        return callBack.getFiles();
    }

    private static void visitEventDelta(IResourceDelta delta, CallBack callBack) {
        callBack.addIfFile(delta.getResource());
        IResourceDelta[] iResourceDeltaArray = delta.getAffectedChildren();
        int n = iResourceDeltaArray.length;
        int n2 = 0;
        while (n2 < n) {
            IResourceDelta childDelta = iResourceDeltaArray[n2];
            ResourceChangeEventVisitor.visitEventDelta(childDelta, callBack);
            ++n2;
        }
    }

    static class CallBack {
        private final List<IResource> files = new ArrayList<IResource>();

        CallBack() {
        }

        public void addIfFile(IResource resource) {
            if (resource != null && resource.getType() == 1) {
                this.getFiles().add(resource);
            }
        }

        public List<IResource> getFiles() {
            return this.files;
        }
    }
}

