/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.livereload.core.internal.service;

import java.util.ArrayList;
import java.util.Collections;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.jboss.tools.livereload.core.internal.service.EventFilter;
import org.jboss.tools.livereload.core.internal.service.Subscriber;
import org.jboss.tools.livereload.core.internal.util.Logger;

public class EventService {
    private static final EventService instance = new EventService();
    private final Map<Subscriber, List<EventFilter>> subscribers = new ConcurrentHashMap<Subscriber, List<EventFilter>>();

    private EventService() {
    }

    public static EventService getInstance() {
        return instance;
    }

    public void publish(EventObject event) {
        if (this.subscribers.size() > 0) {
            Logger.debug("Notifying {} client(s) of event {}", this.subscribers.size(), event.toString());
            for (Map.Entry<Subscriber, List<EventFilter>> entry : this.subscribers.entrySet()) {
                Subscriber subscriber = entry.getKey();
                List<EventFilter> filters = entry.getValue();
                for (EventFilter filter : filters) {
                    if (filter.accept(event)) {
                        Logger.debug("Informing subscriber '{}' of {}", subscriber.getId(), event.toString());
                        subscriber.inform(event);
                        continue;
                    }
                    Logger.trace("Ignored event {} by subscriber {}", event, subscriber.getId());
                }
            }
        } else {
            Logger.debug("*** No subscriber to inform about event {} ***", event.getSource());
        }
    }

    public void subscribe(Subscriber subscriber, EventFilter filter) {
        Logger.debug("Welcome to new subscriber {} ", subscriber.getId());
        if (!this.subscribers.containsKey(subscriber)) {
            this.subscribers.put(subscriber, new ArrayList());
        }
        this.subscribers.get(subscriber).add(filter);
    }

    public void unsubscribe(Subscriber subscriber) {
        Logger.debug("Good bye, {} ", subscriber.getId());
        this.subscribers.remove(subscriber);
    }

    public void resetSubscribers() {
        this.subscribers.clear();
    }

    public Map<Subscriber, List<EventFilter>> getSubscribers() {
        return Collections.unmodifiableMap(this.subscribers);
    }
}

