/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.livereload.core.internal.server.jetty;

import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.IOUtils;
import org.jboss.tools.livereload.core.internal.JBossLiveReloadCoreActivator;
import org.jboss.tools.livereload.core.internal.util.HttpUtils;
import org.jboss.tools.livereload.core.internal.util.Logger;

public class LiveReloadScriptFileServlet
extends HttpServlet {
    private static final long serialVersionUID = 163695311668462503L;

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        try (InputStream scriptContent = null;){
            Logger.debug("Serving embedded /livereload.js");
            HttpServletResponse httpServletResponse = response;
            scriptContent = JBossLiveReloadCoreActivator.getDefault().getResourceContent("/script/livereload.js");
            if (scriptContent == null) {
                httpServletResponse.setStatus(404);
            } else {
                Charset charset = HttpUtils.getContentCharSet(request.getHeader("accept"), "UTF-8");
                httpServletResponse.setContentType("text/javascript; charset=" + charset.name());
                httpServletResponse.getOutputStream().write(IOUtils.toByteArray((InputStream)scriptContent));
                httpServletResponse.setStatus(200);
            }
        }
    }
}

