/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.livereload.core.internal.server.jetty;

import java.net.InetAddress;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.NetworkConnector;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.ServerConnector;
import org.eclipse.wst.server.core.util.SocketUtil;
import org.jboss.tools.livereload.core.internal.util.Logger;
import org.jboss.tools.livereload.core.internal.util.TimeoutUtils;

public class JettyServerRunner
implements Runnable {
    public static final String NAME = "serverName";
    private final Server server;
    private IStatus status = null;

    public static JettyServerRunner start(Server liveReloadServer) throws TimeoutException {
        JettyServerRunner runner = new JettyServerRunner(liveReloadServer);
        Logger.debug("Starting {} on port {}", liveReloadServer, runner.getPort());
        Thread serverThread = new Thread((Runnable)runner, (String)liveReloadServer.getAttribute(NAME));
        TimeoutUtils.TaskMonitor monitor = new TimeoutUtils.TaskMonitor(){

            @Override
            public boolean isComplete() {
                boolean statusOk;
                boolean started = JettyServerRunner.this.isStarted();
                boolean bl = statusOk = JettyServerRunner.this.status != null && !JettyServerRunner.this.status.isOK();
                return started || statusOk;
            }
        };
        serverThread.start();
        if (TimeoutUtils.timeout(monitor, 15L, TimeUnit.SECONDS)) {
            Logger.error("Failed to start " + liveReloadServer + " within expected time (reason: timeout)");
            JettyServerRunner.stop(runner);
            throw new TimeoutException("Failed to start " + liveReloadServer + " within expected time (reason: timeout)");
        }
        Logger.debug("Server {} started (success={})", liveReloadServer, runner.status.isOK());
        return runner;
    }

    public static void stop(JettyServerRunner runner) {
        if (runner != null) {
            try {
                Logger.debug("Stopping {}...", runner.server.getAttribute(NAME));
                runner.stop();
                TimeoutUtils.TaskMonitor monitor = new TimeoutUtils.TaskMonitor(){

                    @Override
                    public boolean isComplete() {
                        return JettyServerRunner.this.isStopped();
                    }
                };
                if (TimeoutUtils.timeout(monitor, 5L, TimeUnit.SECONDS)) {
                    Logger.error("Failed to stop LiveReload Server within expected time (reason: timeout)");
                    throw new TimeoutException("Failed to stop LiveReload Server within expected time (reason: timeout)");
                }
                Logger.debug("{} fully stopped: {}", runner.server.getAttribute(NAME), !SocketUtil.isPortInUse((int)runner.getPort()));
            }
            catch (Exception e) {
                Logger.error("Failed to stop LiveReload Server", e);
            }
        }
    }

    private JettyServerRunner(Server server) {
        this.server = server;
    }

    @Override
    public void run() {
        try {
            Connector[] connectorArray = this.server.getConnectors();
            int n = connectorArray.length;
            int n2 = 0;
            while (n2 < n) {
                Connector connector = connectorArray[n2];
                Throwable throwable = null;
                Object var6_9 = null;
                try (ServerConnector websocketConnector = (ServerConnector)connector;){
                    if (SocketUtil.isPortInUse((InetAddress)InetAddress.getByName(websocketConnector.getHost()), (int)websocketConnector.getPort(), (int)0)) {
                        throw new ExecutionException("Cannot start LiveReload Server: port " + websocketConnector.getPort() + " is already in use.");
                    }
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                ++n2;
            }
            if (!this.server.isStarted()) {
                Logger.debug("Starting {}...", this.server.getAttribute(NAME));
                this.server.start();
                this.status = Status.OK_STATUS;
                this.server.join();
            }
        }
        catch (Exception startException) {
            this.status = Logger.error("Failed to start '" + this.server.getAttribute(NAME) + "'", startException);
            try {
                this.server.stop();
            }
            catch (Exception stopException) {
                Logger.error("Failed to stop server '" + this.server.getAttribute(NAME) + "' after startup failure", stopException);
            }
        }
    }

    private void stop() throws Exception {
        if (this.server != null) {
            this.server.stop();
        }
    }

    boolean isStarted() {
        boolean started = this.server.isStarted();
        Connector[] connectorArray = this.server.getConnectors();
        int n = connectorArray.length;
        int n2 = 0;
        while (n2 < n) {
            Connector connector = connectorArray[n2];
            started = started && connector.isStarted();
            ++n2;
        }
        return started;
    }

    public boolean isSuccessfullyStarted() {
        return this.isStarted() && this.status != null && this.status.isOK();
    }

    boolean isStopped() {
        return this.server.isStopped();
    }

    public int getPort() {
        return ((NetworkConnector)this.server.getConnectors()[0]).getPort();
    }
}

