/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.maven.core;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jst.j2ee.componentcore.J2EEModuleVirtualComponent;
import org.eclipse.m2e.core.internal.Messages;
import org.eclipse.m2e.core.ui.internal.UpdateMavenProjectJob;
import org.eclipse.wst.common.componentcore.ComponentCore;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;
import org.eclipse.wst.common.componentcore.resources.IVirtualFolder;
import org.eclipse.wst.common.frameworks.datamodel.IDataModel;

public class ProjectUtil {
    public static int refreshHierarchy(File basedir, int refreshDepth, IProgressMonitor monitor) throws CoreException {
        try {
            int count = 0;
            IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
            ArrayList<IProject> projects = new ArrayList<IProject>(Arrays.asList(root.getProjects()));
            IPath rootLocation = root.getLocation();
            Path basedirPath = new Path(basedir.getAbsolutePath());
            while (!rootLocation.equals((Object)basedirPath) && rootLocation.isPrefixOf((IPath)basedirPath)) {
                Iterator ite = projects.iterator();
                while (ite.hasNext()) {
                    IProject project = (IProject)ite.next();
                    IPath projectLocation = project.getLocation();
                    if (projectLocation == null || !projectLocation.equals((Object)basedirPath) || !project.isAccessible()) continue;
                    project.refreshLocal(refreshDepth, monitor);
                    ++count;
                    ite.remove();
                    break;
                }
                basedirPath = basedirPath.removeLastSegments(1);
            }
            int n = count;
            return n;
        }
        finally {
            monitor.done();
        }
    }

    public static IFile getWebResourceFile(IProject project, String path) {
        IContainer[] underlyingFolders;
        IVirtualComponent component = ComponentCore.createComponent((IProject)project);
        if (component == null) {
            return null;
        }
        Path filePath = new Path(path);
        IContainer[] iContainerArray = underlyingFolders = component.getRootFolder().getUnderlyingFolders();
        int n = underlyingFolders.length;
        int n2 = 0;
        while (n2 < n) {
            IContainer underlyingFolder = iContainerArray[n2];
            IPath p = underlyingFolder.getProjectRelativePath().append((IPath)filePath);
            IFile f = project.getFile(p);
            if (f.exists()) {
                return f;
            }
            ++n2;
        }
        return null;
    }

    public static IFile getGeneratedWebResourceFile(IProject project, String path) {
        IVirtualComponent component = ComponentCore.createComponent((IProject)project);
        if (component == null) {
            return null;
        }
        Path filePath = new Path(path);
        IVirtualFolder root = component.getRootFolder();
        IContainer[] underlyingFolders = root.getUnderlyingFolders();
        IPath defaultDDFolderPath = J2EEModuleVirtualComponent.getDefaultDeploymentDescriptorFolder((IVirtualFolder)root);
        IContainer[] iContainerArray = underlyingFolders;
        int n = underlyingFolders.length;
        int n2 = 0;
        while (n2 < n) {
            IContainer underlyingFolder = iContainerArray[n2];
            if (defaultDDFolderPath == null || !defaultDDFolderPath.equals((Object)underlyingFolder.getProjectRelativePath())) {
                IPath p = underlyingFolder.getProjectRelativePath().append((IPath)filePath);
                IFile f = project.getFile(p);
                return f;
            }
            ++n2;
        }
        return null;
    }

    public static String getRelativePath(IProject project, String absolutePath) {
        File basedir = project.getLocation().toFile();
        String relative = absolutePath.equals(basedir.getAbsolutePath()) ? "." : (absolutePath.startsWith(basedir.getAbsolutePath()) ? absolutePath.substring(basedir.getAbsolutePath().length() + 1) : absolutePath);
        return relative.replace('\\', '/');
    }

    public static void removeWTPContainers(IDataModel m2FacetModel, IProject project) throws CoreException {
        IJavaProject javaProject;
        if (m2FacetModel != null && project != null && project.hasNature("org.eclipse.jdt.core.javanature") && m2FacetModel.getBooleanProperty("removeWTPClasspathContainers") && (javaProject = JavaCore.create((IProject)project)) != null) {
            ArrayList<IClasspathEntry> newEntries = new ArrayList<IClasspathEntry>();
            IClasspathEntry[] iClasspathEntryArray = javaProject.getRawClasspath();
            int n = iClasspathEntryArray.length;
            int n2 = 0;
            while (n2 < n) {
                IClasspathEntry entry = iClasspathEntryArray[n2];
                String path = entry.getPath().toString();
                if (path != null && !path.startsWith("org.eclipse.jst.j2ee.internal.")) {
                    newEntries.add(entry);
                }
                ++n2;
            }
            javaProject.setRawClasspath(newEntries.toArray(new IClasspathEntry[newEntries.size()]), null);
        }
    }

    public static void refreshProjects(List<IProject> projects, int depth, IProgressMonitor monitor) {
        if (projects == null || projects.isEmpty()) {
            return;
        }
        for (IProject project : projects) {
            if (monitor != null && monitor.isCanceled()) {
                return;
            }
            if (project == null || !project.isAccessible()) continue;
            try {
                project.refreshLocal(depth, monitor);
            }
            catch (CoreException coreException) {}
        }
    }

    public static void updateOutOfDateMavenProjects(List<IProject> projects, IProgressMonitor monitor) throws CoreException {
        if (projects == null || projects.isEmpty()) {
            return;
        }
        ArrayList<IProject> projectsTorUpdate = new ArrayList<IProject>(projects.size());
        for (IProject project : projects) {
            if (monitor != null && monitor.isCanceled()) {
                return;
            }
            if (!ProjectUtil.hasOutOfDateMavenMarker(project)) continue;
            projectsTorUpdate.add(project);
        }
        if (projectsTorUpdate.isEmpty()) {
            return;
        }
        ProjectUtil.refreshProjects(projectsTorUpdate, 2, monitor);
        IProject[] selectedProjects = new IProject[projectsTorUpdate.size()];
        UpdateMavenProjectJob updateJob = new UpdateMavenProjectJob(selectedProjects);
        updateJob.schedule();
    }

    public static boolean hasOutOfDateMavenMarker(IProject project) throws CoreException {
        IMarker[] markers;
        if (project == null || !project.isAccessible() || !project.hasNature("org.eclipse.m2e.core.maven2Nature")) {
            return false;
        }
        IMarker[] iMarkerArray = markers = project.findMarkers("org.eclipse.m2e.core.maven2Problem.configuration", true, 0);
        int n = markers.length;
        int n2 = 0;
        while (n2 < n) {
            IMarker marker = iMarkerArray[n2];
            String message = (String)marker.getAttribute("message");
            if (Messages.ProjectConfigurationUpdateRequired.equals(message)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public static List<IProject> toIProjects(List<String> projectNames) {
        if (projectNames == null) {
            return null;
        }
        ArrayList<IProject> projects = new ArrayList<IProject>(projectNames.size());
        for (String name : projectNames) {
            IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(name);
            if (project == null) continue;
            projects.add(project);
        }
        return projects;
    }
}

