/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.cdi.seam.config.core.util;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.jdt.core.IField;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.Signature;
import org.jboss.tools.cdi.core.CDICoreNature;
import org.jboss.tools.cdi.core.IRootDefinitionContext;
import org.jboss.tools.cdi.seam.config.core.CDISeamConfigConstants;
import org.jboss.tools.cdi.seam.config.core.definition.SeamMethodDefinition;
import org.jboss.tools.cdi.seam.config.core.definition.SeamParameterDefinition;
import org.jboss.tools.cdi.seam.config.core.xml.SAXElement;
import org.jboss.tools.cdi.seam.config.core.xml.SAXText;
import org.jboss.tools.common.java.ParametedType;

public class Util
implements CDISeamConfigConstants {
    public static Map<String, String> EE_TYPES;
    public static Map<String, String> EE_TYPES_30;

    static {
        String[] SEAM_SOLDER;
        String[] JAVAX_INTERCEPTOR;
        String[] JAVAX_DECORAROR;
        String[] JAVAX_ENTERPRISE_EVENT;
        String[] JAVAX_ENTERPRISE_CONTEXT;
        String[] JAVAX_ENTERPRISE_INJECT;
        String[] JAVAX_INJECT;
        String[] JAVAX_ANNOTATION;
        String[] JAVA_UTIL;
        String[] JAVA_LANG;
        EE_TYPES = new HashMap<String, String>();
        EE_TYPES_30 = new HashMap<String, String>();
        EE_TYPES.put("int", "java.lang.Integer");
        EE_TYPES.put("short", "java.lang.Short");
        EE_TYPES.put("long", "java.lang.Long");
        EE_TYPES.put("char", "java.lang.Character");
        EE_TYPES.put("byte", "java.lang.Byte");
        EE_TYPES.put("boolean", "java.lang.Boolean");
        EE_TYPES.put("double", "java.lang.Double");
        EE_TYPES.put("float", "java.lang.Float");
        String[] stringArray = JAVA_LANG = new String[]{"Integer", "Short", "Long", "String", "Character", "Byte", "Boolean", "Double", "Float"};
        int n = JAVA_LANG.length;
        int n2 = 0;
        while (n2 < n) {
            String s = stringArray[n2];
            EE_TYPES.put(s, "java.lang." + s);
            ++n2;
        }
        String[] stringArray2 = JAVA_UTIL = new String[]{"List", "Map", "Set"};
        int n3 = JAVA_UTIL.length;
        n = 0;
        while (n < n3) {
            String s = stringArray2[n];
            EE_TYPES.put(s, "java.util." + s);
            ++n;
        }
        String[] stringArray3 = JAVAX_ANNOTATION = new String[]{"Generated", "PostConstruct", "PreDestroy", "Resource", "Resources"};
        int n4 = JAVAX_ANNOTATION.length;
        n3 = 0;
        while (n3 < n4) {
            String s = stringArray3[n3];
            EE_TYPES.put(s, "javax.annotation." + s);
            ++n3;
        }
        String[] stringArray4 = JAVAX_INJECT = new String[]{"Inject", "Named", "Provider", "Qualifier", "Scope", "Singleton"};
        int n5 = JAVAX_INJECT.length;
        n4 = 0;
        while (n4 < n5) {
            String s = stringArray4[n4];
            EE_TYPES.put(s, "javax.inject." + s);
            ++n4;
        }
        String[] stringArray5 = JAVAX_ENTERPRISE_INJECT = new String[]{"Alternative", "AmbiguousResolutionException", "Any", "CreationException", "Default", "Disposes", "IllegalProductException", "InjectionException", "Instance", "Model", "New", "Produces", "ResolutionException", "Specializes", "Stereotype", "Typed", "UnproxyableResolutionException", "UnsatisfiedResolutionException"};
        int n6 = JAVAX_ENTERPRISE_INJECT.length;
        n5 = 0;
        while (n5 < n6) {
            String s = stringArray5[n5];
            EE_TYPES.put(s, "javax.enterprise.inject." + s);
            ++n5;
        }
        String[] stringArray6 = JAVAX_ENTERPRISE_CONTEXT = new String[]{"ApplicationScoped", "BusyConversationException", "ContextException", "ContextNotActiveException", "Conversation", "ConversationScoped", "Dependent", "NonexistentConversationException", "NormalScope", "RequestScoped", "SessionScoped"};
        int n7 = JAVAX_ENTERPRISE_CONTEXT.length;
        n6 = 0;
        while (n6 < n7) {
            String s = stringArray6[n6];
            EE_TYPES.put(s, "javax.enterprise.context." + s);
            ++n6;
        }
        String[] stringArray7 = JAVAX_ENTERPRISE_EVENT = new String[]{"Event", "ObserverException", "Observes", "Reception", "TransactionPhase"};
        int n8 = JAVAX_ENTERPRISE_EVENT.length;
        n7 = 0;
        while (n7 < n8) {
            String s = stringArray7[n7];
            EE_TYPES.put(s, "javax.enterprise.event." + s);
            ++n7;
        }
        String[] stringArray8 = JAVAX_DECORAROR = new String[]{"Decorator", "Delegate"};
        int n9 = JAVAX_DECORAROR.length;
        n8 = 0;
        while (n8 < n9) {
            String s = stringArray8[n8];
            EE_TYPES.put(s, "javax.decorator." + s);
            ++n8;
        }
        String[] stringArray9 = JAVAX_INTERCEPTOR = new String[]{"AroundInvoke", "AroundTimeout", "ExcludeClassInterceptors", "ExcludeDefaultInterceptors", "Interceptor", "InterceptorBinding", "Interceptors", "InvocationContext"};
        int n10 = JAVAX_INTERCEPTOR.length;
        n9 = 0;
        while (n9 < n10) {
            String s = stringArray9[n9];
            EE_TYPES.put(s, "javax.interceptor." + s);
            ++n9;
        }
        String[] stringArray10 = SEAM_SOLDER = new String[]{"Exact"};
        int n11 = SEAM_SOLDER.length;
        n10 = 0;
        while (n10 < n11) {
            String s = stringArray10[n10];
            EE_TYPES.put(s, "org.jboss.solder.core." + s);
            EE_TYPES_30.put(s, "org.jboss.seam.solder.core." + s);
            ++n10;
        }
    }

    public static boolean isConfigRelevant(SAXElement element) {
        String uri = element.getURI();
        return uri != null && uri.startsWith("urn:java:");
    }

    public static IType resolveType(SAXElement element, CDICoreNature project) {
        return Util.resolveType(element.getLocalName(), element.getURI(), project);
    }

    public static IType resolveType(String name, String uri, CDICoreNature project) {
        String[] packages;
        if (uri == null || !uri.startsWith("urn:java:")) {
            return null;
        }
        String[] stringArray = packages = Util.getPackages(uri);
        int n = packages.length;
        int n2 = 0;
        while (n2 < n) {
            String pkg = stringArray[n2];
            if (pkg.length() != 0) {
                IType type = null;
                if (pkg.equals("ee")) {
                    type = project.getType(EE_TYPES.get(name));
                    if (type == null) {
                        type = project.getType(EE_TYPES_30.get(name));
                    }
                } else {
                    type = project.getType(String.valueOf(pkg) + "." + name);
                }
                if (type != null) {
                    return type;
                }
            }
            ++n2;
        }
        return null;
    }

    public static Set<String> getPossibleTypeNames(SAXElement element) {
        HashSet<String> result = new HashSet<String>();
        String name = element.getLocalName();
        String uri = element.getURI();
        if (uri != null && uri.startsWith("urn:java:")) {
            String[] packages;
            String[] stringArray = packages = Util.getPackages(uri);
            int n = packages.length;
            int n2 = 0;
            while (n2 < n) {
                String pkg = stringArray[n2];
                if (pkg.length() > 0 && !pkg.equals("ee")) {
                    result.add(String.valueOf(pkg) + "." + name);
                }
                ++n2;
            }
        }
        return result;
    }

    public static IMember resolveMember(IType type, SAXElement element) throws JavaModelException {
        IMethod[] ms;
        String name = element.getLocalName();
        IField f = type.getField(name);
        if (f != null && f.exists() && !Util.hasParametersOrArrayChild(element)) {
            return f;
        }
        IMethod[] iMethodArray = ms = type.getMethods();
        int n = ms.length;
        int n2 = 0;
        while (n2 < n) {
            IMethod m = iMethodArray[n2];
            if (name.equals(m.getElementName())) {
                return m;
            }
            ++n2;
        }
        return null;
    }

    public static String[] getPackages(String uri) {
        if (uri == null || !uri.startsWith("urn:java:")) {
            return new String[0];
        }
        uri = uri.substring("urn:java:".length());
        return uri.split(":");
    }

    public static boolean containsEEPackage(SAXElement element) {
        return Util.containsEEPackage(element.getURI());
    }

    public static boolean containsEEPackage(String uri) {
        String[] ps;
        String[] stringArray = ps = Util.getPackages(uri);
        int n = ps.length;
        int n2 = 0;
        while (n2 < n) {
            String p = stringArray[n2];
            if ("ee".equals(p)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public static boolean isArray(SAXElement element) {
        return Util.isKeyword(element, "array");
    }

    public static boolean isEntry(SAXElement element) {
        return Util.isKeyword(element, "entry", "e");
    }

    public static boolean isKey(SAXElement element) {
        return Util.isKeyword(element, "key", "k");
    }

    public static boolean isValue(SAXElement element) {
        return Util.isKeyword(element, "value", "v");
    }

    public static boolean isParameters(SAXElement element) {
        return Util.isKeyword(element, "parameters");
    }

    public static boolean isKeyword(SAXElement element, String keyword) {
        return keyword.equals(element.getLocalName()) && Util.containsEEPackage(element);
    }

    public static boolean isKeyword(SAXElement element, String keyword1, String keyword2) {
        String n = element.getLocalName();
        return (keyword1.equals(n) || keyword2.equals(n)) && Util.containsEEPackage(element);
    }

    public static boolean hasText(SAXElement element) {
        SAXText t = element.getTextNode();
        return t != null && t.getValue() != null && t.getValue().trim().length() > 0;
    }

    public static boolean hasProducesChild(SAXElement element) {
        List<SAXElement> cs = element.getChildElements();
        for (SAXElement c : cs) {
            if (!Util.containsEEPackage(c) || !"Produces".equals(c.getLocalName())) continue;
            return true;
        }
        return false;
    }

    public static boolean hasParametersOrArrayChild(SAXElement element) {
        List<SAXElement> cs = element.getChildElements();
        for (SAXElement c : cs) {
            if (!Util.isParameters(c) && !Util.isArray(c)) continue;
            return true;
        }
        return false;
    }

    public static IMethod findMethod(SeamMethodDefinition def, IType type, String name, IRootDefinitionContext context) throws JavaModelException {
        IMethod[] ms;
        IMethod[] iMethodArray = ms = type.getMethods();
        int n = ms.length;
        int n2 = 0;
        while (n2 < n) {
            IMethod m = iMethodArray[n2];
            if ((name == null && m.isConstructor() || name != null && name.equals(m.getElementName())) && Util.sameParameterTypes(def, m, context)) {
                return m;
            }
            ++n2;
        }
        return null;
    }

    static boolean sameParameterTypes(SeamMethodDefinition def, IMethod m, IRootDefinitionContext context) throws JavaModelException {
        String[] paramTypes = m.getParameterTypes();
        if (paramTypes.length != def.getParameters().size()) {
            return false;
        }
        if (paramTypes.length == 0) {
            return true;
        }
        int i = 0;
        while (i < paramTypes.length) {
            String paramType = paramTypes[i];
            SeamParameterDefinition p = def.getParameters().get(i);
            if (p.getDimensions() != Signature.getArrayCount((String)paramType)) {
                return false;
            }
            ParametedType pt = context.getProject().getTypeFactory().getParametedType((IMember)m, paramType);
            if (pt == null || p.getType() == null) {
                return false;
            }
            if (!pt.getType().getFullyQualifiedName().equals(p.getType().getFullyQualifiedName())) {
                return false;
            }
            ++i;
        }
        return true;
    }
}

