/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.jst.js.bower.util;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.runtime.CoreException;
import org.jboss.tools.jst.js.bower.BowerJson;
import org.jboss.tools.jst.js.bower.Bowerrc;
import org.jboss.tools.jst.js.util.WorkbenchResourceUtil;

public final class BowerUtil {
    private BowerUtil() {
    }

    public static boolean isBowerJsonExist(IProject project) throws CoreException {
        IFile bowerJson = null;
        if (project != null && project.exists()) {
            bowerJson = WorkbenchResourceUtil.findFileRecursively((IContainer)project, "bower.json");
        }
        return bowerJson != null && bowerJson.exists();
    }

    public static boolean hasBowerJson(IFolder folder) throws CoreException {
        IResource bowerJson = folder.findMember("bower.json");
        return bowerJson != null && bowerJson.exists();
    }

    public static boolean isBowerJson(IResource resource) {
        return resource != null && "bower.json".equals(resource.getName()) && resource.exists();
    }

    public static String generateJson(BowerJson bowerJson) {
        Gson gson = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();
        return gson.toJson((Object)bowerJson);
    }

    public static IFile getBowerrc(IProject project) throws CoreException {
        IFile bowerrc = null;
        if (project != null && project.exists()) {
            bowerrc = WorkbenchResourceUtil.findFileRecursively((IContainer)project, ".bowerrc");
        }
        return bowerrc;
    }

    public static String getBowerWorkingDir(IProject project, final String ... ignores) throws CoreException {
        String workingDir = null;
        final ArrayList foundFiles = new ArrayList();
        if (project != null && project.exists()) {
            project.accept(new IResourceVisitor(){

                public boolean visit(IResource resource) throws CoreException {
                    if (!foundFiles.isEmpty()) {
                        return false;
                    }
                    if (resource.getType() == 2 && ignores != null) {
                        String[] stringArray = ignores;
                        int n = ignores.length;
                        int n2 = 0;
                        while (n2 < n) {
                            String ignore = stringArray[n2];
                            if (resource.getName().equals(ignore)) {
                                return false;
                            }
                            ++n2;
                        }
                    } else if (resource.getType() == 1 && "bower.json".equals(resource.getName())) {
                        foundFiles.add((IFile)resource);
                    }
                    return true;
                }
            });
        }
        if (!foundFiles.isEmpty()) {
            workingDir = ((IFile)foundFiles.get(0)).getParent().getFullPath().toOSString();
        }
        return workingDir;
    }

    public static String getDirectoryName(IFile bowerrc) throws UnsupportedEncodingException, CoreException {
        String[] split;
        int length;
        InputStreamReader reader;
        Bowerrc model;
        String directory;
        String directoryName = null;
        if (bowerrc != null && bowerrc.exists() && (directory = (model = (Bowerrc)new Gson().fromJson((Reader)(reader = new InputStreamReader(bowerrc.getContents(), "UTF-8")), Bowerrc.class)).getDirectory()) != null && (length = (split = directory.split("/")).length) > 0) {
            directoryName = split[length - 1];
        }
        return directoryName;
    }
}

