/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.jst.js.bower.internal.preference.editor;

import java.io.File;
import org.eclipse.jface.preference.DirectoryFieldEditor;
import org.eclipse.swt.widgets.Composite;
import org.jboss.tools.common.util.PlatformUtil;
import org.jboss.tools.jst.js.bower.internal.Messages;
import org.jboss.tools.jst.js.bower.internal.util.ExternalToolUtil;

public class NodeHomeFieldEditor
extends DirectoryFieldEditor {
    public NodeHomeFieldEditor(String name, String label, Composite composite) {
        super(name, label, composite);
        this.setEmptyStringAllowed(true);
    }

    protected boolean doCheckState() {
        String nodeExecutableName;
        File selectedFile;
        File nodeExecutable;
        String filename = this.getTextControl().getText();
        if ((filename = filename.trim()).isEmpty()) {
            this.getPage().setMessage(Messages.BowerPreferencePage_NotSpecifiedNodeWarning, 2);
            return true;
        }
        this.getPage().setMessage(null);
        if (!filename.endsWith(File.separator)) {
            filename = String.valueOf(filename) + File.separator;
        }
        if (!(nodeExecutable = new File(selectedFile = new File(filename), nodeExecutableName = ExternalToolUtil.getNodeExecutableName())).exists()) {
            if (!PlatformUtil.isLinux()) {
                this.setErrorMessage(Messages.BowerPreferencePage_NotValidNodeError);
                return false;
            }
            nodeExecutableName = "node";
            nodeExecutable = new File(selectedFile, nodeExecutableName);
            if (!nodeExecutable.exists()) {
                this.setErrorMessage(Messages.BowerPreferencePage_NotValidNodeError);
                return false;
            }
        }
        return true;
    }

    public void setValidateStrategy(int value) {
        super.setValidateStrategy(0);
    }
}

