/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.jst.js.bower.internal.launch.shortcut;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.DebugEvent;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.IDebugEventSetListener;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationType;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.core.ILaunchManager;
import org.eclipse.debug.core.model.IProcess;
import org.eclipse.debug.ui.ILaunchShortcut;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IEditorPart;
import org.jboss.tools.jst.js.bower.internal.ui.ExceptionNotifier;
import org.jboss.tools.jst.js.bower.internal.util.ExternalToolUtil;
import org.jboss.tools.jst.js.internal.Activator;
import org.jboss.tools.jst.js.util.WorkbenchResourceUtil;

public abstract class GenericNativeBowerLaunch
implements ILaunchShortcut {
    private IProject workingProject;
    IDebugEventSetListener bowerProcessTerminateListener = new IDebugEventSetListener(){

        public void handleDebugEvents(DebugEvent[] events) {
            DebugEvent[] debugEventArray = events;
            int n = events.length;
            int n2 = 0;
            while (n2 < n) {
                block7: {
                    ILaunchConfiguration lc;
                    ILaunch launch;
                    Object source;
                    DebugEvent event = debugEventArray[n2];
                    if (event.getKind() == 8 && (source = event.getSource()) instanceof IProcess && (launch = ((IProcess)source).getLaunch()) != null && (lc = launch.getLaunchConfiguration()) != null && GenericNativeBowerLaunch.this.getLaunchName().equals(lc.getName()) && GenericNativeBowerLaunch.this.workingProject != null && GenericNativeBowerLaunch.this.workingProject.exists()) {
                        try {
                            try {
                                GenericNativeBowerLaunch.this.workingProject.refreshLocal(2, null);
                            }
                            catch (CoreException e) {
                                Activator.logError(e);
                                DebugPlugin.getDefault().removeDebugEventListener((IDebugEventSetListener)this);
                                break block7;
                            }
                        }
                        catch (Throwable throwable) {
                            DebugPlugin.getDefault().removeDebugEventListener((IDebugEventSetListener)this);
                            throw throwable;
                        }
                        DebugPlugin.getDefault().removeDebugEventListener((IDebugEventSetListener)this);
                    }
                }
                ++n2;
            }
        }
    };

    public void launch(ISelection selection, String mode) {
        Object element;
        if (selection instanceof IStructuredSelection && (element = ((IStructuredSelection)selection).getFirstElement()) != null && element instanceof IResource) {
            try {
                IResource selectedResource = (IResource)element;
                String nodeLocation = ExternalToolUtil.getNodeExecutableLocation();
                String bowerLocation = ExternalToolUtil.getBowerExecutableLocation();
                if (nodeLocation == null || nodeLocation.isEmpty()) {
                    ExceptionNotifier.nodeLocationNotDefined();
                } else if (bowerLocation == null || bowerLocation.isEmpty()) {
                    ExceptionNotifier.bowerLocationNotDefined();
                } else {
                    this.workingProject = selectedResource.getProject();
                    this.execute(this.getWorkingDirectory(selectedResource), nodeLocation, bowerLocation);
                }
            }
            catch (CoreException e) {
                Activator.logError(e);
            }
        }
    }

    public void launch(IEditorPart editor, String mode) {
    }

    protected void execute(String workingDirectory, String nodeExecutableLocation, String bowerExecutableLocation) {
        ILaunchManager manager = DebugPlugin.getDefault().getLaunchManager();
        DebugPlugin.getDefault().addDebugEventListener(this.bowerProcessTerminateListener);
        ILaunchConfigurationType programType = manager.getLaunchConfigurationType("org.eclipse.ui.externaltools.ProgramLaunchConfigurationType");
        try {
            ILaunchConfigurationWorkingCopy cfg = programType.newInstance(null, this.getLaunchName());
            ILaunchConfigurationWorkingCopy wc = cfg.getWorkingCopy();
            wc.setAttribute("org.eclipse.ui.externaltools.ATTR_LOCATION", nodeExecutableLocation);
            wc.setAttribute("org.eclipse.ui.externaltools.ATTR_WORKING_DIRECTORY", "${workspace_loc:" + workingDirectory + "}");
            wc.setAttribute("org.eclipse.ui.externaltools.ATTR_SHOW_CONSOLE", true);
            wc.setAttribute("org.eclipse.ui.externaltools.ATTR_TOOL_ARGUMENTS", String.valueOf(bowerExecutableLocation) + " " + this.getCommandName());
            cfg = wc.doSave();
            cfg.launch("run", null, false, true);
            cfg.delete();
            WorkbenchResourceUtil.showConsoleView();
        }
        catch (CoreException e) {
            Activator.logError(e);
            ExceptionNotifier.launchError((Exception)((Object)e));
        }
    }

    protected abstract String getWorkingDirectory(IResource var1) throws CoreException;

    protected abstract String getCommandName();

    protected abstract String getLaunchName();
}

