/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.thym.ui.wizard.export;

import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.thym.core.HybridCore;
import org.eclipse.thym.core.HybridProject;
import org.eclipse.thym.core.extensions.PlatformSupport;
import org.eclipse.thym.core.platform.AbstractProjectGeneratorDelegate;
import org.eclipse.thym.ui.HybridUI;
import org.eclipse.thym.ui.internal.status.StatusManager;
import org.eclipse.thym.ui.wizard.export.NativeProjectDestinationPage;
import org.eclipse.thym.ui.wizard.export.NativeProjectExportOperation;
import org.eclipse.ui.IExportWizard;
import org.eclipse.ui.IWorkbench;

public class NativeProjectExportWizard
extends Wizard
implements IExportWizard {
    private static final String DIALOG_SETTINGS_KEY = "NativeProjectExportWizard";
    private NativeProjectDestinationPage pageOne;
    private IStructuredSelection initialSelection;

    public NativeProjectExportWizard() {
        this.setWindowTitle("Export Native Platform Project");
        this.setNeedsProgressMonitor(true);
        IDialogSettings workbenchSettings = HybridUI.getDefault().getDialogSettings();
        IDialogSettings section = workbenchSettings.getSection(DIALOG_SETTINGS_KEY);
        this.setDialogSettings(section);
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        this.initialSelection = selection;
    }

    public boolean performFinish() {
        List<PlatformSupport> platforms = this.pageOne.getSelectedPlatforms();
        List<HybridProject> projects = this.pageOne.getSelectedProjects();
        ArrayList<AbstractProjectGeneratorDelegate> delegates = new ArrayList<AbstractProjectGeneratorDelegate>();
        for (HybridProject project : projects) {
            for (PlatformSupport platform : platforms) {
                try {
                    AbstractProjectGeneratorDelegate dlg = platform.createDelegate(project.getProject(), new File(this.pageOne.getDestinationDirectory(), project.getProject().getName()));
                    delegates.add(dlg);
                }
                catch (CoreException e) {
                    HybridCore.log((int)4, (String)("Error creating project generator delegate for " + platform.getPlatform()), (Throwable)e);
                }
            }
        }
        NativeProjectExportOperation op = new NativeProjectExportOperation(delegates, this.pageOne);
        try {
            this.getContainer().run(true, true, (IRunnableWithProgress)op);
        }
        catch (InvocationTargetException e) {
            if (e.getTargetException() != null) {
                if (e.getTargetException() instanceof CoreException) {
                    StatusManager.handle((CoreException)e.getTargetException());
                } else {
                    ErrorDialog.openError((Shell)this.getShell(), (String)"Error exporting native projects", null, (IStatus)new Status(4, "org.eclipse.thym.ui", "Error while exporting native projects", e.getTargetException()));
                    return false;
                }
            }
            return false;
        }
        catch (InterruptedException interruptedException) {
            return false;
        }
        MultiStatus status = op.getStatus();
        if (!status.isOK()) {
            StatusManager.handle((IStatus)status);
            return !status.matches(4);
        }
        this.savePageSettings();
        return true;
    }

    private void savePageSettings() {
        IDialogSettings workbenchSettings = HybridUI.getDefault().getDialogSettings();
        IDialogSettings section = workbenchSettings.getSection(DIALOG_SETTINGS_KEY);
        if (section == null) {
            section = workbenchSettings.addNewSection(DIALOG_SETTINGS_KEY);
        }
        this.setDialogSettings(section);
        this.pageOne.saveWidgetValues();
    }

    public void addPages() {
        super.addPages();
        this.pageOne = new NativeProjectDestinationPage(this.getWindowTitle(), this.initialSelection);
        this.pageOne.setTitle("Export Native Platform Project");
        this.pageOne.setDescription("Exports a platform native project from a hybrid mobile project type");
        this.addPage((IWizardPage)this.pageOne);
    }
}

