/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.thym.ui.config.internal;

import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.thym.core.config.Access;
import org.eclipse.thym.core.config.Widget;
import org.eclipse.thym.core.config.WidgetModel;
import org.eclipse.thym.ui.HybridUI;

public class NewAccessDialog
extends Dialog {
    private Text txtOrigin;
    private Access access;
    private Widget widget;
    private WidgetModel model;
    private Button btnSubdomains;
    private Button btnBrowserOnly;

    public NewAccessDialog(Shell parentShell, WidgetModel widgetModel) {
        super(parentShell);
        Assert.isNotNull((Object)widgetModel);
        try {
            this.widget = widgetModel.getWidgetForEdit();
            this.model = widgetModel;
        }
        catch (CoreException e) {
            HybridUI.log(2, "Error retrieving Widget while on the NewAccessDialog", e);
        }
    }

    protected Control createDialogArea(Composite parent) {
        this.getShell().setText("New Access");
        Composite container = (Composite)super.createDialogArea(parent);
        GridLayout gl_container = new GridLayout(2, false);
        gl_container.marginTop = 10;
        container.setLayout((Layout)gl_container);
        Label lblOrigin = new Label(container, 0);
        lblOrigin.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 1, 1));
        lblOrigin.setText("Origin:");
        this.txtOrigin = new Text(container, 2048);
        this.txtOrigin.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        new Label(container, 0);
        Composite composite = new Composite(container, 0);
        composite.setLayoutData((Object)new GridData(4, 4, false, false, 1, 1));
        composite.setLayout((Layout)new RowLayout(512));
        this.btnSubdomains = new Button(composite, 32);
        this.btnSubdomains.setText("Allow Subdomains");
        this.btnBrowserOnly = new Button(composite, 32);
        this.btnBrowserOnly.setText("Browser Only");
        return container;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
        this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
    }

    protected Point getInitialSize() {
        Point p = this.getShell().computeSize(-1, -1, true);
        p.x += p.x / 2;
        return p;
    }

    protected void okPressed() {
        String origin = this.txtOrigin.getText();
        this.access = this.model.createAccess(this.widget);
        if (origin != null && !origin.isEmpty()) {
            this.access.setOrigin(origin);
        }
        if (this.btnSubdomains.getSelection()) {
            this.access.setSubdomains(true);
        }
        if (this.btnBrowserOnly.getSelection()) {
            this.access.setBrowserOnly(true);
        }
        super.okPressed();
    }

    public Access getAccess() {
        return this.access;
    }
}

