/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.cdi.text.ext.hyperlink;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.ITypeRoot;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.ui.javaeditor.EditorUtility;
import org.eclipse.jdt.internal.ui.javaeditor.JavaEditor;
import org.eclipse.jdt.internal.ui.text.JavaWordFinder;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.hyperlink.AbstractHyperlinkDetector;
import org.eclipse.jface.text.hyperlink.IHyperlink;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.texteditor.ITextEditor;
import org.jboss.tools.cdi.core.CDICoreNature;
import org.jboss.tools.cdi.core.CDIUtil;
import org.jboss.tools.cdi.core.IBean;
import org.jboss.tools.cdi.core.IBeanMethod;
import org.jboss.tools.cdi.core.ICDIProject;
import org.jboss.tools.cdi.core.IClassBean;
import org.jboss.tools.cdi.core.IProducer;
import org.jboss.tools.cdi.core.IProducerMethod;
import org.jboss.tools.cdi.text.ext.CDIExtensionsPlugin;
import org.jboss.tools.cdi.text.ext.hyperlink.DisposerHyperlink;
import org.jboss.tools.cdi.text.ext.hyperlink.ProducerHyperlink;

public class ProducerDisposerHyperlinkDetector
extends AbstractHyperlinkDetector {
    protected IFile file;

    public IHyperlink[] detectHyperlinks(ITextViewer textViewer, IRegion region, boolean canShowMultipleHyperlinks) {
        ArrayList<DisposerHyperlink> hyperlinks;
        IJavaElement[] elements;
        Collection<IBean> beans;
        IDocument document;
        block19: {
            IRegion wordRegion;
            ITypeRoot input;
            block18: {
                block17: {
                    ITextEditor textEditor = (ITextEditor)this.getAdapter(ITextEditor.class);
                    if (region == null || !(textEditor instanceof JavaEditor)) {
                        return null;
                    }
                    if (textEditor.getEditorInput() instanceof IFileEditorInput) {
                        this.file = ((IFileEditorInput)textEditor.getEditorInput()).getFile();
                    }
                    int offset = region.getOffset();
                    input = EditorUtility.getEditorInputJavaElement((IEditorPart)textEditor, (boolean)true);
                    if (input == null) {
                        return null;
                    }
                    document = textEditor.getDocumentProvider().getDocument((Object)textEditor.getEditorInput());
                    wordRegion = JavaWordFinder.findWord((IDocument)document, (int)offset);
                    if (wordRegion == null) {
                        return null;
                    }
                    IProject project = null;
                    project = input.getJavaProject().getProject();
                    if (project == null) {
                        return null;
                    }
                    beans = this.getBeans(project, input.getPath(), textEditor.isDirty());
                    if (beans == null) {
                        return null;
                    }
                    elements = null;
                    elements = input.codeSelect(wordRegion.getOffset(), wordRegion.getLength());
                    if (elements != null) break block17;
                    return null;
                }
                if (elements.length == 1) break block18;
                return null;
            }
            hyperlinks = new ArrayList<DisposerHyperlink>();
            if (!(elements[0] instanceof IType) || !"javax.enterprise.inject.Produces".equals(((IType)elements[0]).getFullyQualifiedName())) break block19;
            elements[0] = input.getElementAt(wordRegion.getOffset());
            if (elements[0] != null) break block19;
            return null;
        }
        try {
            if (elements[0] instanceof IMethod) {
                for (IBean bean : beans) {
                    if (!(bean instanceof IClassBean)) continue;
                    IProducerMethod producer = this.getProducer((IClassBean)bean, (IMethod)elements[0]);
                    if (producer != null) {
                        List<IMethod> disposers = this.findDisposerMethods(producer);
                        for (IMethod method : disposers) {
                            hyperlinks.add(new DisposerHyperlink(region, method, document));
                        }
                        continue;
                    }
                    IBeanMethod disposer = this.getDisposer((IClassBean)bean, (IMethod)elements[0]);
                    if (disposer == null) continue;
                    List<IMethod> producers = this.findProducerMethods((IClassBean)bean, disposer);
                    for (IMethod method : producers) {
                        hyperlinks.add(new ProducerHyperlink(region, method, document));
                    }
                }
            }
            if (hyperlinks != null && !hyperlinks.isEmpty()) {
                return hyperlinks.toArray(new IHyperlink[hyperlinks.size()]);
            }
        }
        catch (JavaModelException jme) {
            CDIExtensionsPlugin.getDefault().logError(jme);
        }
        return null;
    }

    private Collection<IBean> getBeans(IProject project, IPath path, boolean dirty) {
        CDICoreNature cdiNature = CDIUtil.getCDINatureWithProgress((IProject)project);
        if (cdiNature == null) {
            return null;
        }
        ICDIProject cdiProject = CDIUtil.getCDIProject((IFile)this.file, (CDICoreNature)cdiNature, (boolean)dirty);
        if (cdiProject == null) {
            return null;
        }
        return cdiProject.getBeans(path);
    }

    private IProducerMethod getProducer(IClassBean classBean, IMethod method) {
        for (IProducer producer : classBean.getProducers()) {
            if (!(producer instanceof IProducerMethod) || !((IProducerMethod)producer).getMethod().equals(method)) continue;
            return (IProducerMethod)producer;
        }
        return null;
    }

    private IBeanMethod getDisposer(IClassBean classBean, IMethod method) {
        for (IBeanMethod disposer : classBean.getDisposers()) {
            if (!disposer.getMethod().equals(method)) continue;
            return disposer;
        }
        return null;
    }

    private List<IMethod> findProducerMethods(IClassBean classBean, IBeanMethod disposer) {
        ArrayList<IMethod> methods = new ArrayList<IMethod>();
        for (IProducer producer : classBean.getProducers()) {
            if (!(producer instanceof IProducerMethod)) continue;
            for (IBeanMethod beanMethod : producer.getCDIProject().resolveDisposers((IProducerMethod)producer)) {
                if (!beanMethod.equals(disposer)) continue;
                methods.add(((IProducerMethod)producer).getMethod());
            }
        }
        return methods;
    }

    private List<IMethod> findDisposerMethods(IProducerMethod producer) {
        ArrayList<IMethod> methods = new ArrayList<IMethod>();
        for (IBeanMethod beanMethod : producer.getCDIProject().resolveDisposers(producer)) {
            methods.add(beanMethod.getMethod());
        }
        return methods;
    }
}

