/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.cdi.text.ext.hyperlink;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.jboss.tools.cdi.core.IBean;
import org.jboss.tools.cdi.core.IBeanMember;
import org.jboss.tools.cdi.core.IInjectionPoint;
import org.jboss.tools.cdi.core.IProducer;
import org.jboss.tools.cdi.text.ext.CDIExtensionsPlugin;

public class AssignableBeanFilters {
    static FilterContributor[] contributors = null;
    public static int OPTION_UNAVAILABLE_BEANS = 1;
    public static int OPTION_DECORATOR = 2;
    public static int OPTION_INTERCEPTOR = 3;
    public static int OPTION_UNSELECTED_ALTERNATIVE = 4;
    public static int OPTION_PRODUCER_IN_UNAVAILABLE_BEAN = 5;
    public static int OPTION_SPECIALIZED_BEAN = 6;
    public static int OPTION_ELIMINATED_AMBIGUOUS = 7;
    private Map<Integer, Checkbox> allOptions = new HashMap<Integer, Checkbox>();
    private Checkbox root = new Checkbox(0, "", null);

    public AssignableBeanFilters() {
        this.initContributors();
    }

    void initContributors() {
        if (contributors == null) {
            IConfigurationElement[] cs = Platform.getExtensionRegistry().getExtensionPoint("org.jboss.tools.cdi.text.ext.assignableBeanFilterContributors").getConfigurationElements();
            ArrayList<FilterContributor> s = new ArrayList<FilterContributor>();
            IConfigurationElement[] iConfigurationElementArray = cs;
            int n = cs.length;
            int n2 = 0;
            while (n2 < n) {
                IConfigurationElement c = iConfigurationElementArray[n2];
                try {
                    FilterContributor f = (FilterContributor)c.createExecutableExtension("class");
                    s.add(f);
                }
                catch (CoreException e) {
                    CDIExtensionsPlugin.getDefault().logError(e);
                }
                ++n2;
            }
            contributors = s.toArray(new FilterContributor[s.size()]);
        }
    }

    public void init(IInjectionPoint point) {
        this.allOptions.clear();
        this.allOptions.put(this.root.id, this.root);
        this.add(0, OPTION_UNAVAILABLE_BEANS, "Unavailable Beans", null);
        this.add(OPTION_UNAVAILABLE_BEANS, OPTION_DECORATOR, "@Decorator", new DecoratorFilter());
        this.add(OPTION_UNAVAILABLE_BEANS, OPTION_INTERCEPTOR, "@Interceptor", new InterceptorFilter());
        this.add(OPTION_UNAVAILABLE_BEANS, OPTION_UNSELECTED_ALTERNATIVE, "Unselected @Alternative", new UnselectedAlternativeFilter());
        this.add(OPTION_UNAVAILABLE_BEANS, OPTION_PRODUCER_IN_UNAVAILABLE_BEAN, "@Produces in unavailable bean", new ProducerFilter());
        this.add(OPTION_UNAVAILABLE_BEANS, OPTION_SPECIALIZED_BEAN, "Specialized beans", new SpecializedBeanFilter());
        this.add(0, OPTION_ELIMINATED_AMBIGUOUS, "Eliminated ambiguous", new EliminatedAmbiguousFilter());
        FilterContributor[] filterContributorArray = contributors;
        int n = contributors.length;
        int n2 = 0;
        while (n2 < n) {
            FilterContributor c = filterContributorArray[n2];
            c.contribute(this, point);
            ++n2;
        }
    }

    public void add(int parentId, int id, String label, Filter f) {
        Checkbox parent = this.getOption(parentId);
        if (parent == null) {
            parent = this.root;
        }
        Checkbox c = parent.add(id, label, f);
        this.allOptions.put(id, c);
    }

    public Checkbox getRoot() {
        return this.root;
    }

    public Map<Integer, Checkbox> getAllOptions() {
        return this.allOptions;
    }

    public Checkbox getOption(int id) {
        return this.allOptions.get(id);
    }

    public Filter getFilter(int id) {
        Checkbox c = this.getOption(id);
        return c == null ? null : c.filter;
    }

    public static class Checkbox {
        int id;
        String label;
        Filter filter;
        boolean state = true;
        Checkbox parent = null;
        List<Checkbox> children = new ArrayList<Checkbox>();

        Checkbox(int id, String label, Filter filter) {
            this.id = id;
            this.label = label;
            this.filter = filter;
        }

        Checkbox add(int id, String label, Filter f) {
            Checkbox c = new Checkbox(id, label, f);
            c.parent = this;
            this.children.add(c);
            return c;
        }

        public String toString() {
            return this.label;
        }

        public boolean isEnabled() {
            return this.state && (this.parent == null || this.parent.isEnabled());
        }

        public void filter(Set<IBean> beans) {
            if (!this.isEnabled() && this.filter != null) {
                this.filter.filter(beans);
            }
            for (Checkbox c : this.children) {
                c.filter(beans);
            }
        }
    }

    public static class DecoratorFilter
    implements Filter {
        @Override
        public void filter(Set<IBean> beans) {
            Iterator<IBean> it = beans.iterator();
            while (it.hasNext()) {
                IBean b = it.next();
                if (!b.isAnnotationPresent("javax.decorator.Decorator")) continue;
                it.remove();
            }
        }
    }

    public class EliminatedAmbiguousFilter
    implements Filter {
        @Override
        public void filter(Set<IBean> beans) {
            HashSet<IBean> eligible = new HashSet<IBean>(beans);
            int i = OPTION_UNAVAILABLE_BEANS + 1;
            while (i < OPTION_ELIMINATED_AMBIGUOUS) {
                Filter f = AssignableBeanFilters.this.getFilter(i);
                if (f != null) {
                    f.filter(eligible);
                }
                ++i;
            }
            boolean hasAlternative = false;
            for (IBean b : eligible) {
                if (!b.isEnabled() || !b.isAlternative() || !b.isSelectedAlternative()) continue;
                hasAlternative = true;
            }
            if (hasAlternative) {
                Iterator<IBean> it = beans.iterator();
                while (it.hasNext()) {
                    IBeanMember p;
                    IBean bean = it.next();
                    if (!eligible.contains(bean) || bean.isAlternative() || bean instanceof IProducer && bean instanceof IBeanMember && (p = (IBeanMember)bean).getClassBean() != null && p.getClassBean().isAlternative()) continue;
                    it.remove();
                }
            }
        }
    }

    public static interface Filter {
        public void filter(Set<IBean> var1);
    }

    public static interface FilterContributor {
        public void contribute(AssignableBeanFilters var1, IInjectionPoint var2);
    }

    public static class InterceptorFilter
    implements Filter {
        @Override
        public void filter(Set<IBean> beans) {
            Iterator<IBean> it = beans.iterator();
            while (it.hasNext()) {
                IBean b = it.next();
                if (!b.isAnnotationPresent("javax.interceptor.Interceptor")) continue;
                it.remove();
            }
        }
    }

    public static class ProducerFilter
    implements Filter {
        @Override
        public void filter(Set<IBean> beans) {
            Iterator<IBean> it = beans.iterator();
            while (it.hasNext()) {
                IBean b = it.next();
                if (!(b instanceof IProducer) || ((IProducer)b).getClassBean() == null || ((IProducer)b).getClassBean().isEnabled()) continue;
                it.remove();
            }
        }
    }

    public static class SpecializedBeanFilter
    implements Filter {
        @Override
        public void filter(Set<IBean> beans) {
            Iterator<IBean> it = beans.iterator();
            HashSet<IBean> specialized = new HashSet<IBean>();
            while (it.hasNext()) {
                IBean b = it.next();
                IBean bean = b.getSpecializedBean();
                if (bean == null) continue;
                specialized.add(bean);
            }
            beans.removeAll(specialized);
        }
    }

    public static class UnselectedAlternativeFilter
    implements Filter {
        @Override
        public void filter(Set<IBean> beans) {
            Iterator<IBean> it = beans.iterator();
            while (it.hasNext()) {
                IBean b = it.next();
                if (!b.isAlternative() || b.isSelectedAlternative()) continue;
                it.remove();
            }
        }
    }
}

