/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.jsf.text.ext.hyperlink;

import java.text.MessageFormat;
import java.util.Properties;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IRegion;
import org.jboss.tools.common.model.XModel;
import org.jboss.tools.common.text.ext.hyperlink.AbstractHyperlink;
import org.jboss.tools.common.text.ext.hyperlink.xpl.Messages;
import org.jboss.tools.jsf.text.ext.JSFExtensionsPlugin;
import org.jboss.tools.jsf.text.ext.JSFTextExtMessages;
import org.jboss.tools.jst.web.project.list.WebPromptingProvider;

public class RenderKitHyperlink
extends AbstractHyperlink {
    protected void doHyperlink(IRegion region) {
        if (this.getDocument() == null || region == null) {
            this.openFileFailed();
            return;
        }
        XModel xModel = this.getXModel();
        if (xModel == null) {
            this.openFileFailed();
            return;
        }
        WebPromptingProvider provider = WebPromptingProvider.getInstance();
        String beanName = this.getBeanName(this.getHyperlinkRegion());
        Properties p = new Properties();
        provider.getList(xModel, "jsf.open.render-kit", beanName, p);
        String error = p.getProperty("error");
        if (error != null && error.length() > 0) {
            this.openFileFailed();
        }
    }

    private String getBeanName(IRegion region) {
        if (this.getDocument() == null || region == null) {
            return null;
        }
        try {
            return this.trimQuotes(this.getDocument().get(region.getOffset(), region.getLength()));
        }
        catch (BadLocationException x) {
            JSFExtensionsPlugin.log("", (Exception)((Object)x));
            return null;
        }
    }

    private String trimQuotes(String word) {
        String attrText = word;
        int bStart = 0;
        int bEnd = word.length() - 1;
        StringBuffer sb = new StringBuffer(attrText);
        while (bStart < bEnd && (sb.charAt(bStart) == '\'' || sb.charAt(bStart) == '\"' || Character.isWhitespace(sb.charAt(bStart)))) {
            ++bStart;
        }
        while (bEnd > bStart && (sb.charAt(bEnd) == '\'' || sb.charAt(bEnd) == '\"' || Character.isWhitespace(sb.charAt(bEnd)))) {
            --bEnd;
        }
        return sb.substring(bStart, ++bEnd);
    }

    public String getHyperlinkText() {
        String renderKitName = this.getBeanName(this.getHyperlinkRegion());
        if (renderKitName == null) {
            return MessageFormat.format(Messages.OpenA, JSFTextExtMessages.RenderKit);
        }
        return MessageFormat.format(JSFTextExtMessages.OpenRenderKit, renderKitName);
    }
}

