/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.forge.ui.internal.preferences;

import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.jboss.tools.forge.core.preferences.ForgeCorePreferences;

public class ForgeMainPreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage {
    private Text addonDirText;

    protected Control createContents(Composite parent) {
        this.noDefaultAndApplyButton();
        Composite clientArea = this.createClientArea(parent);
        this.createAddonDirText(clientArea);
        return clientArea;
    }

    private void createAddonDirText(Composite parent) {
        Label addonDirLabel = new Label(parent, 0);
        addonDirLabel.setText("Forge Addon Repository Location: ");
        Composite container = new Composite(parent, 0);
        container.setLayoutData((Object)new GridData(768));
        GridLayout layout = new GridLayout();
        container.setLayout((Layout)layout);
        layout.numColumns = 2;
        layout.verticalSpacing = 9;
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        this.addonDirText = new Text(container, 2048);
        this.addonDirText.setLayoutData((Object)new GridData(768));
        this.addonDirText.setText(ForgeCorePreferences.INSTANCE.getAddonDir());
        Button button = new Button(container, 8);
        button.setText("Browse...");
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DirectoryDialog dialog = new DirectoryDialog(ForgeMainPreferencePage.this.getShell(), 4096);
                dialog.setText("Select a directory");
                dialog.setFilterPath(ForgeMainPreferencePage.this.addonDirText.getText());
                String selectedPath = dialog.open();
                if (selectedPath != null) {
                    ForgeMainPreferencePage.this.addonDirText.setText(selectedPath);
                }
            }
        });
    }

    private Composite createClientArea(Composite parent) {
        Composite clientArea = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        clientArea.setLayout((Layout)layout);
        GridData gridData = new GridData(768);
        clientArea.setLayoutData((Object)gridData);
        return clientArea;
    }

    public void init(IWorkbench workbench) {
    }

    public boolean performOk() {
        ForgeCorePreferences.INSTANCE.setAddonDir(this.addonDirText.getText());
        return true;
    }
}

