/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.forge.ui.internal.ext.control;

import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.jboss.forge.addon.convert.Converter;
import org.jboss.forge.addon.convert.ConverterFactory;
import org.jboss.forge.addon.ui.controller.CommandController;
import org.jboss.forge.addon.ui.input.InputComponent;
import org.jboss.forge.addon.ui.input.SelectComponent;
import org.jboss.forge.addon.ui.input.UISelectOne;
import org.jboss.forge.addon.ui.util.InputComponents;
import org.jboss.forge.furnace.proxy.Proxies;
import org.jboss.tools.forge.core.furnace.FurnaceService;
import org.jboss.tools.forge.ui.internal.ext.control.ControlBuilder;
import org.jboss.tools.forge.ui.internal.ext.wizards.ForgeWizardPage;

public class RadioControlBuilder
extends ControlBuilder<Control> {
    @Override
    public Control build(final ForgeWizardPage page, InputComponent<?, ?> input, final String inputName, Composite parent) {
        Label label = new Label(parent, 0);
        label.setText(this.getMnemonicLabel(input, true));
        Composite container = new Composite(parent, 0);
        container.setLayout((Layout)new RowLayout());
        container.setLayoutData((Object)new GridData(768));
        ConverterFactory converterFactory = FurnaceService.INSTANCE.getConverterFactory();
        UISelectOne selectOne = (UISelectOne)input;
        Converter itemLabelConverter = InputComponents.getItemLabelConverter((ConverterFactory)converterFactory, (SelectComponent)selectOne);
        Object originalValue = InputComponents.getValueFor(input);
        Iterable valueChoices = selectOne.getValueChoices();
        if (valueChoices != null) {
            for (final Object choice : valueChoices) {
                String itemLabel = (String)itemLabelConverter.convert(choice);
                final Button button = new Button(container, 16);
                button.setText(itemLabel);
                button.setToolTipText(input.getDescription());
                boolean selected = Proxies.areEquivalent(choice, (Object)originalValue);
                button.setSelection(selected);
                button.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        if (button.getSelection()) {
                            CommandController controller = page.getController();
                            controller.setValueFor(inputName, Proxies.unwrap((Object)choice));
                        }
                    }
                });
            }
        }
        Label dummy = new Label(parent, 0);
        dummy.setText("");
        return container;
    }

    @Override
    protected Class<Object> getProducedType() {
        return Object.class;
    }

    @Override
    protected String getSupportedInputType() {
        return "org.jboss.forge.inputType.RADIO";
    }

    @Override
    protected Class<?>[] getSupportedInputComponentTypes() {
        return new Class[]{UISelectOne.class};
    }
}

