/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.project.examples.seam.internal.fixes;

import org.eclipse.core.runtime.Assert;
import org.jboss.tools.project.examples.fixes.IProjectFixProvider;
import org.jboss.tools.project.examples.fixes.UIHandler;
import org.jboss.tools.project.examples.model.ProjectExample;
import org.jboss.tools.project.examples.model.RequirementModel;
import org.jboss.tools.project.examples.seam.internal.fixes.SeamRuntimeFix;
import org.jboss.tools.project.examples.seam.internal.fixes.SeamRuntimeFixUIHandler;

public class SeamProjectFixProvider
implements IProjectFixProvider {
    private static final String SEAM_RUNTIME = "seam";

    public boolean accepts(String type) {
        return SEAM_RUNTIME.equals(type);
    }

    public SeamRuntimeFix create(ProjectExample example, RequirementModel requirement) {
        Assert.isNotNull((Object)requirement);
        if (this.accepts(requirement.getType())) {
            return new SeamRuntimeFix(example, requirement);
        }
        throw new IllegalArgumentException(requirement == null ? null : String.valueOf(requirement.getType()) + " is not a valid seam requirement");
    }

    public UIHandler createUIHandler() {
        return new SeamRuntimeFixUIHandler();
    }
}

