/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.maven.jdt.internal.endorsedlib;

import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.IClasspathContainer;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.m2e.jdt.IClasspathDescriptor;
import org.jboss.tools.maven.jdt.MavenJdtActivator;
import org.jboss.tools.maven.jdt.endorsedlib.IEndorsedLibrariesManager;
import org.jboss.tools.maven.jdt.internal.endorsedlib.EndorsedLibrariesContainer;
import org.jboss.tools.maven.jdt.internal.endorsedlib.JarFilter;
import org.jboss.tools.maven.jdt.internal.endorsedlib.xpl.MavenClasspathContainerSaveHelper;
import org.jboss.tools.maven.jdt.utils.ClasspathHelpers;

public class EndorsedLibrariesManager
implements IEndorsedLibrariesManager {
    private File stateLocationDir;

    public EndorsedLibrariesManager(File containerLocationDir) {
        this.stateLocationDir = containerLocationDir;
    }

    @Override
    public void configureEndorsedLibs(IJavaProject javaProject, IClasspathDescriptor classpath, File[] endorsedDirs, IProgressMonitor monitor) throws CoreException {
        if (javaProject != null && classpath != null) {
            IClasspathEntry[] classpathEntries = this.getClasspathEntries(javaProject, endorsedDirs, monitor);
            ClasspathHelpers.removeEndorsedLibClasspathContainer(classpath);
            if (classpathEntries.length > 0) {
                IClasspathEntry containerEntry = ClasspathHelpers.addEndorsedLibClasspathContainer(classpath);
                IPath path = containerEntry != null ? containerEntry.getPath() : new Path("org.jboss.tools.maven.jdt.ENDORSED_LIB_CLASSPATH_CONTAINER");
                EndorsedLibrariesContainer container = new EndorsedLibrariesContainer(path, classpathEntries);
                JavaCore.setClasspathContainer((IPath)container.getPath(), (IJavaProject[])new IJavaProject[]{javaProject}, (IClasspathContainer[])new IClasspathContainer[]{container}, (IProgressMonitor)monitor);
                this.saveContainerState(javaProject.getProject(), container);
            }
        }
    }

    private IClasspathEntry[] getClasspathEntries(IJavaProject javaProject, File[] endorsedDirs, IProgressMonitor monitor) {
        ArrayList<IClasspathEntry> cpes = new ArrayList<IClasspathEntry>();
        File[] fileArray = endorsedDirs;
        int n = endorsedDirs.length;
        int n2 = 0;
        while (n2 < n) {
            File dir = fileArray[n2];
            if (dir.isDirectory() && dir.canRead()) {
                this.setEntries(dir, cpes);
            }
            ++n2;
        }
        return cpes.toArray(new IClasspathEntry[0]);
    }

    private void setEntries(File lib, List<IClasspathEntry> cpes) {
        if (!lib.canRead()) {
            return;
        }
        File[] fileArray = lib.listFiles(new JarFilter());
        int n = fileArray.length;
        int n2 = 0;
        while (n2 < n) {
            Path fullPath;
            IClasspathEntry entry;
            File f = fileArray[n2];
            if (f.isFile() && !cpes.contains(entry = JavaCore.newLibraryEntry((IPath)(fullPath = new Path(f.getAbsolutePath())), null, null))) {
                cpes.add(entry);
            }
            ++n2;
        }
    }

    private void saveContainerState(IProject project, IClasspathContainer container) {
        File containerStateFile = this.getContainerStateFile(project);
        FileOutputStream is = null;
        try {
            try {
                is = new FileOutputStream(containerStateFile);
                new MavenClasspathContainerSaveHelper().writeContainer(container, is);
            }
            catch (IOException ex) {
                MavenJdtActivator.log("Can't save classpath container state for " + project.getName(), ex);
                this.closeQuietly(is, "Can't close output stream for " + containerStateFile.getAbsolutePath());
            }
        }
        finally {
            this.closeQuietly(is, "Can't close output stream for " + containerStateFile.getAbsolutePath());
        }
    }

    @Override
    public IClasspathContainer getSavedContainer(IProject project) throws CoreException {
        File containerStateFile = this.getContainerStateFile(project);
        if (!containerStateFile.exists()) {
            return null;
        }
        FileInputStream is = null;
        try {
            is = new FileInputStream(containerStateFile);
            IClasspathContainer iClasspathContainer = new MavenClasspathContainerSaveHelper().readContainer(is);
            return iClasspathContainer;
        }
        catch (IOException ex) {
            throw new CoreException((IStatus)new Status(4, "org.jboss.tools.maven.jdt", -1, "Can't read classpath container state for " + project.getName(), (Throwable)ex));
        }
        catch (ClassNotFoundException ex) {
            throw new CoreException((IStatus)new Status(4, "org.jboss.tools.maven.jdt", -1, "Can't read classpath container state for " + project.getName(), (Throwable)ex));
        }
        finally {
            this.closeQuietly(is, "Can't close output stream for " + containerStateFile.getAbsolutePath());
        }
    }

    private void closeQuietly(Closeable c, String message) {
        if (c != null) {
            try {
                c.close();
            }
            catch (IOException e) {
                MavenJdtActivator.log(message, e);
            }
        }
    }

    private File getContainerStateFile(IProject project) {
        return new File(this.stateLocationDir, String.valueOf(project.getName()) + ".container");
    }
}

