/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.jsf.vpe.richfaces.template;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jboss.tools.jsf.vpe.richfaces.ComponentUtil;
import org.jboss.tools.vpe.editor.context.VpePageContext;
import org.jboss.tools.vpe.editor.template.VpeAbstractTemplate;
import org.jboss.tools.vpe.editor.template.VpeChildrenInfo;
import org.jboss.tools.vpe.editor.template.VpeCreationData;
import org.mozilla.interfaces.nsIDOMDocument;
import org.mozilla.interfaces.nsIDOMElement;
import org.mozilla.interfaces.nsIDOMNode;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class RichFacesPickListTemplate
extends VpeAbstractTemplate {
    private static final String ATTR_LISTS_HEIGHT = "listsHeight";
    private static final String ATTR_MOVE_CONTROLS_VERTICAL_ALIGN = "moveControlsVerticalAlign";
    private static final String ATTR_SHOW_BUTTON_LABELS = "showButtonsLabel";
    private static final String ATTR_SOURCE_LIST_WIDTH = "sourceListWidth";
    private static final String ATTR_TARGET_LIST_WIDTH = "targetListWidth";
    private static final String BUTTON_IMG_PATH = "pickList/button.gif";
    private static final String CLASS_SUFFIX = "Class";
    private static final String CONTROL_MAP_KEY = "control";
    private static final String CSS_EXTENSION = "pickList";
    private static final String DEFAULT_BUTTON_ALIGN = "middle";
    private static final String DEFAULT_LIST_HEIGHT = "140px";
    private static final String DEFAULT_LIST_WIDTH = "140px";
    private static final String LABEL_SUFFIX = "Label";
    private static final String LIST_MAP_KEY = "list";
    private static final String RICH_LIST_PICKLIST_BUTTON_CONTENT_CSS_CLASS = "rich-list-picklist-button-content";
    private static final String RICH_LIST_PICKLIST_BUTTON_CSS_CLASS = "rich-list-picklist-button";
    private static final String RICH_PICKLIST_CONTROL_BUTTON_CSS_CLASS = "rich-picklist-control-button-class";
    private static final String RICH_PICKLIST_INTERNAL_TAB_CSS_CLASS = "rich-picklist-internal-tab";
    private static final String RICH_PICKLIST_LIST_CONTENT_CSS_CLASS = "rich-picklist-list-content";
    private static final String RICH_PICKLIST_LIST_CSS_CLASS = "rich-picklist-list";
    private static final String RICH_PICKLIST_SOURCE_CELL_CSS_CLASS = "rich-picklist-source-cell";
    private static final String SELECT_ITEM = "selectItem";
    private static final String SOURCE_LIST = "source";
    private static final String SPACER_GIF = "/spacer.gif";
    private static final String STYLE_PATH = "pickList/pickList.css";
    private static final Map<String, String> styleClasses = new HashMap<String, String>();
    private static final String TARGET_LIST = "target";
    private static final String TD_STYLE_1 = "border: 0px none ; padding: 0px;";
    private static final String WIDTH_15 = "15";
    private final Map<LabelKey, String> buttonImages = new HashMap<LabelKey, String>();
    private final Map<LabelKey, String> defaultLabels = new HashMap<LabelKey, String>();
    private final Map<String, String> defaultStyleClasses = new HashMap<String, String>();
    private final Map<String, Node> facetLabels = new HashMap<String, Node>();
    private boolean isShowButtonLabels;
    private final Map<String, String> labels = new HashMap<String, String>();
    private String listsHeight;
    private String moveControlsAlign;
    private final List<String> sourceButtons = new ArrayList<String>();
    private String sourceListsWidth;
    private final List<String> targetButtons = new ArrayList<String>();
    private String targetListsWidth;
    private static final String REMOVE_ALL_CONTROL = "\u21d0";
    private static final String REMOVE_CONTROL = "\u2190";
    private static final String COPY_CONTROL = "\u2192";
    private static final String COPY_ALL_CONTROL = "\u21d2";

    public static List<Node> getChildren(Node sourceNode) {
        ArrayList<Node> children = new ArrayList<Node>();
        NodeList nodeList = sourceNode.getChildNodes();
        int i = 0;
        while (i < nodeList.getLength()) {
            Node child = nodeList.item(i);
            children.add(child);
            ++i;
        }
        return children;
    }

    public RichFacesPickListTemplate() {
        this.init();
    }

    private void addChildrens(nsIDOMDocument visualDocument, List<Node> children, nsIDOMElement td, VpeCreationData creationData) {
        ArrayList<Element> selectItems = new ArrayList<Element>();
        for (Node child : children) {
            if (!(child instanceof Element) || child.getNodeName().indexOf(SELECT_ITEM) <= 1) continue;
            selectItems.add((Element)child);
        }
        if (selectItems.size() > 0) {
            nsIDOMElement topItemDiv = visualDocument.createElement("div");
            topItemDiv.setAttribute("class", RICH_PICKLIST_LIST_CSS_CLASS);
            nsIDOMElement pickListContentItemDiv = visualDocument.createElement("div");
            pickListContentItemDiv.setAttribute("class", RICH_PICKLIST_LIST_CONTENT_CSS_CLASS);
            pickListContentItemDiv.setAttribute("style", "width:" + this.sourceListsWidth + ";" + "height" + ":" + this.listsHeight);
            nsIDOMElement itemsTable = visualDocument.createElement("table");
            nsIDOMElement itemsTableTBody = visualDocument.createElement("tbody");
            itemsTable.setAttribute("class", RICH_PICKLIST_INTERNAL_TAB_CSS_CLASS);
            itemsTable.setAttribute("cellpadding", "0");
            itemsTable.setAttribute("cellpadding", "0");
            VpeChildrenInfo childrensInfo = new VpeChildrenInfo(itemsTableTBody);
            creationData.addChildrenInfo(childrensInfo);
            for (Element selectItem : selectItems) {
                childrensInfo.addSourceChild((Node)selectItem);
            }
            td.appendChild((nsIDOMNode)topItemDiv);
            topItemDiv.appendChild((nsIDOMNode)pickListContentItemDiv);
            pickListContentItemDiv.appendChild((nsIDOMNode)itemsTable);
            itemsTable.appendChild((nsIDOMNode)itemsTableTBody);
        }
    }

    private void clearData() {
        this.labels.clear();
        styleClasses.clear();
        this.sourceButtons.clear();
        this.targetButtons.clear();
        this.facetLabels.clear();
    }

    public VpeCreationData create(VpePageContext pageContext, Node sourceNode, nsIDOMDocument visualDocument) {
        Element sourceElement = (Element)sourceNode;
        this.prepareData(sourceElement);
        ComponentUtil.setCSSLink(pageContext, STYLE_PATH, CSS_EXTENSION);
        nsIDOMElement rootTable = visualDocument.createElement("table");
        nsIDOMElement rootTBody = visualDocument.createElement("tbody");
        nsIDOMElement rootTr = visualDocument.createElement("tr");
        VpeCreationData creationData = new VpeCreationData((nsIDOMNode)rootTable);
        creationData.addChildrenInfo(new VpeChildrenInfo(null));
        rootTable.setAttribute("class", styleClasses.get("style"));
        String attrStyleVal = sourceElement.hasAttribute("style") ? sourceElement.getAttribute("style") : null;
        rootTable.setAttribute("style", attrStyleVal);
        nsIDOMElement sourceBoxTd = visualDocument.createElement("td");
        nsIDOMElement sourceBox = this.createBox(visualDocument, creationData, RichFacesPickListTemplate.getChildren(sourceNode), SOURCE_LIST);
        sourceBox.setAttribute("style", "width:" + this.sourceListsWidth + ";" + "height" + ":" + this.listsHeight + ";");
        sourceBoxTd.appendChild((nsIDOMNode)sourceBox);
        nsIDOMElement controlsButtonsTd = visualDocument.createElement("td");
        nsIDOMElement sourceButtonsBlock = this.createButtonsBlock(visualDocument, creationData);
        controlsButtonsTd.appendChild((nsIDOMNode)sourceButtonsBlock);
        controlsButtonsTd.setAttribute("style", "vertical-align:" + this.moveControlsAlign);
        nsIDOMElement targetBoxTd = visualDocument.createElement("td");
        nsIDOMElement targetBox = this.createBox(visualDocument, creationData, RichFacesPickListTemplate.getChildren(sourceNode), TARGET_LIST);
        targetBox.setAttribute("style", "width:" + this.targetListsWidth + ";" + "height" + ":" + this.listsHeight + ";");
        targetBoxTd.appendChild((nsIDOMNode)targetBox);
        rootTr.appendChild((nsIDOMNode)sourceBoxTd);
        rootTr.appendChild((nsIDOMNode)controlsButtonsTd);
        rootTr.appendChild((nsIDOMNode)targetBoxTd);
        rootTBody.appendChild((nsIDOMNode)rootTr);
        rootTable.appendChild((nsIDOMNode)rootTBody);
        this.clearData();
        return creationData;
    }

    private nsIDOMElement createBox(nsIDOMDocument visualDocument, VpeCreationData creationData, List<Node> children, String boxId) {
        nsIDOMElement div = visualDocument.createElement("div");
        div.setAttribute("class", MessageFormat.format(styleClasses.get(LIST_MAP_KEY), boxId));
        nsIDOMElement box = visualDocument.createElement("table");
        box.setAttribute("cellspacing", "0");
        box.setAttribute("cellpadding", "0");
        box.setAttribute("width", "100%");
        box.setAttribute("class", "rich-picklist-body");
        nsIDOMElement td = visualDocument.createElement("td");
        nsIDOMElement tr = visualDocument.createElement("tr");
        td.setAttribute("style", TD_STYLE_1);
        if (SOURCE_LIST.equalsIgnoreCase(boxId)) {
            this.addChildrens(visualDocument, children, td, creationData);
        }
        box.appendChild((nsIDOMNode)tr);
        tr.appendChild((nsIDOMNode)td);
        div.appendChild((nsIDOMNode)box);
        return div;
    }

    private nsIDOMElement createButton(nsIDOMDocument visualDocument, VpeCreationData creationData, LabelKey buttonId) {
        nsIDOMElement buttonSpace = visualDocument.createElement("div");
        buttonSpace.setAttribute("class", RICH_PICKLIST_CONTROL_BUTTON_CSS_CLASS);
        nsIDOMElement metaButton = visualDocument.createElement("div");
        metaButton.setAttribute("style", ComponentUtil.getBackgoundImgStyle(BUTTON_IMG_PATH));
        metaButton.setAttribute("class", RICH_LIST_PICKLIST_BUTTON_CSS_CLASS);
        nsIDOMElement buttonContent = visualDocument.createElement("div");
        buttonContent.setAttribute("class", RICH_LIST_PICKLIST_BUTTON_CONTENT_CSS_CLASS);
        if (this.isShowButtonLabels) {
            buttonContent.appendChild((nsIDOMNode)visualDocument.createTextNode(String.valueOf(this.buttonImages.get((Object)buttonId)) + " " + this.labels.get(buttonId.getValue())));
        } else {
            buttonContent.appendChild((nsIDOMNode)visualDocument.createTextNode(this.buttonImages.get((Object)buttonId)));
        }
        buttonSpace.appendChild((nsIDOMNode)metaButton);
        metaButton.appendChild((nsIDOMNode)buttonContent);
        return buttonSpace;
    }

    private nsIDOMElement createButtonsBlock(nsIDOMDocument visualDocument, VpeCreationData creationData) {
        nsIDOMElement buttonsBlock = visualDocument.createElement("div");
        buttonsBlock.setAttribute("class", styleClasses.get(CONTROL_MAP_KEY));
        LabelKey[] labelKeyArray = LabelKey.values();
        int n = labelKeyArray.length;
        int n2 = 0;
        while (n2 < n) {
            LabelKey buttonId = labelKeyArray[n2];
            buttonsBlock.appendChild((nsIDOMNode)this.createButton(visualDocument, creationData, buttonId));
            ++n2;
        }
        return buttonsBlock;
    }

    private nsIDOMElement createItemTr(nsIDOMDocument visualDocument, Element child) {
        nsIDOMElement tr = visualDocument.createElement("tr");
        nsIDOMElement td = visualDocument.createElement("td");
        td.setAttribute("class", RICH_PICKLIST_SOURCE_CELL_CSS_CLASS);
        nsIDOMElement itemImage = visualDocument.createElement("img");
        itemImage.setAttribute("width", "1px");
        itemImage.setAttribute("height", "1px");
        ComponentUtil.setImg(itemImage, String.valueOf(this.getCssExtension()) + SPACER_GIF);
        tr.appendChild((nsIDOMNode)td);
        td.appendChild((nsIDOMNode)itemImage);
        td.appendChild((nsIDOMNode)visualDocument.createTextNode(this.getTextForSelectItem(child)));
        return tr;
    }

    protected String getCssExtension() {
        return CSS_EXTENSION;
    }

    private String getTextForSelectItem(Element child) {
        String result = "";
        String attrName = "itemLabel";
        String defaultValue = "<h:selectItem/>";
        if (child.getNodeName().endsWith("selectItems")) {
            attrName = "value";
            defaultValue = "<h:selectItems/>";
        }
        if ((result = ComponentUtil.getAttribute(child, attrName)).trim().length() == 0) {
            result = defaultValue;
        }
        return result;
    }

    private void init() {
        this.initButtonImagesMap();
        this.initDefaultLabelsMap();
        this.initDefaultStyleClasses();
    }

    private void initButtonImagesMap() {
        this.buttonImages.put(LabelKey.COPY_ALL_CONTROL, COPY_ALL_CONTROL);
        this.buttonImages.put(LabelKey.COPY_CONTROL, COPY_CONTROL);
        this.buttonImages.put(LabelKey.REMOVE_CONTROL, REMOVE_CONTROL);
        this.buttonImages.put(LabelKey.REMOVE_ALL_CONTROL, REMOVE_ALL_CONTROL);
    }

    private void initDefaultLabelsMap() {
        this.defaultLabels.put(LabelKey.COPY_ALL_CONTROL, "Copy all");
        this.defaultLabels.put(LabelKey.COPY_CONTROL, "Copy");
        this.defaultLabels.put(LabelKey.REMOVE_CONTROL, "Remove");
        this.defaultLabels.put(LabelKey.REMOVE_ALL_CONTROL, "Remove All");
    }

    private void initDefaultStyleClasses() {
        this.defaultStyleClasses.put("style", "rich-list-picklist");
        this.defaultStyleClasses.put(LIST_MAP_KEY, "rich-picklist-{0}-items");
        this.defaultStyleClasses.put(CONTROL_MAP_KEY, "rich-picklist-controls");
    }

    public boolean recreateAtAttrChange(VpePageContext pageContext, Element sourceElement, nsIDOMDocument visualDocument, nsIDOMElement visualNode, Object data, String name, String value) {
        return true;
    }

    private void prepareData(Element sourceElement) {
        this.prepareLabels(sourceElement);
        this.prepareStyleClasses(sourceElement);
        this.prepareOtherParameters(sourceElement);
    }

    private void prepareLabels(Element sourceElement) {
        LabelKey[] labelKeyArray = LabelKey.values();
        int n = labelKeyArray.length;
        int n2 = 0;
        while (n2 < n) {
            LabelKey key = labelKeyArray[n2];
            if (sourceElement.hasAttribute(String.valueOf(key.getValue()) + LABEL_SUFFIX)) {
                String label = sourceElement.getAttribute(String.valueOf(key.getValue()) + LABEL_SUFFIX);
                this.labels.put(key.getValue(), label);
            } else {
                this.labels.put(key.getValue(), this.defaultLabels.get((Object)key));
            }
            ++n2;
        }
    }

    private void prepareOtherParameters(Element sourceElement) {
        this.isShowButtonLabels = !Boolean.FALSE.toString().equalsIgnoreCase(sourceElement.getAttribute(ATTR_SHOW_BUTTON_LABELS));
        this.moveControlsAlign = sourceElement.hasAttribute(ATTR_MOVE_CONTROLS_VERTICAL_ALIGN) ? sourceElement.getAttribute(ATTR_MOVE_CONTROLS_VERTICAL_ALIGN) : DEFAULT_BUTTON_ALIGN;
        String listsHeightString = sourceElement.getAttribute(ATTR_LISTS_HEIGHT);
        try {
            this.listsHeight = String.valueOf(ComponentUtil.parseWidthHeightValue(listsHeightString));
        }
        catch (NumberFormatException numberFormatException) {
            this.listsHeight = "140px";
        }
        String sourceListWithString = sourceElement.getAttribute(ATTR_SOURCE_LIST_WIDTH);
        try {
            this.sourceListsWidth = String.valueOf(ComponentUtil.parseWidthHeightValue(sourceListWithString));
        }
        catch (NumberFormatException numberFormatException) {
            this.sourceListsWidth = "140px";
        }
        String targetListWithString = sourceElement.getAttribute(ATTR_TARGET_LIST_WIDTH);
        try {
            this.targetListsWidth = String.valueOf(ComponentUtil.parseWidthHeightValue(targetListWithString));
        }
        catch (NumberFormatException numberFormatException) {
            this.targetListsWidth = "140px";
        }
    }

    private void prepareStyleClasses(Element sourceElement) {
        Set<String> styleClassesKeys = this.defaultStyleClasses.keySet();
        for (String key : styleClassesKeys) {
            if (sourceElement.hasAttribute(String.valueOf(key) + CLASS_SUFFIX)) {
                String styleClass = sourceElement.getAttribute(String.valueOf(key) + CLASS_SUFFIX);
                styleClasses.put(key, String.valueOf(this.defaultStyleClasses.get(key)) + " " + styleClass);
                continue;
            }
            styleClasses.put(key, this.defaultStyleClasses.get(key));
        }
    }

    private static enum LabelKey {
        COPY_ALL_CONTROL("copyAllControl"),
        COPY_CONTROL("copyControl"),
        REMOVE_CONTROL("removeControl"),
        REMOVE_ALL_CONTROL("removeAllControl");

        private String value;

        private LabelKey(String val) {
            this.value = val;
        }

        public String getValue() {
            return this.value;
        }
    }
}

