/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.jsf.vpe.richfaces.template;

import java.util.HashMap;
import org.jboss.tools.jsf.vpe.richfaces.ComponentUtil;
import org.jboss.tools.jsf.vpe.richfaces.template.RichFacesMessageTemplate;
import org.jboss.tools.vpe.editor.context.VpePageContext;
import org.jboss.tools.vpe.editor.template.VpeChildrenInfo;
import org.jboss.tools.vpe.editor.template.VpeCreationData;
import org.mozilla.interfaces.nsIDOMDocument;
import org.mozilla.interfaces.nsIDOMElement;
import org.mozilla.interfaces.nsIDOMNode;
import org.mozilla.interfaces.nsIDOMText;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class RichFacesMessagesTemplate
extends RichFacesMessageTemplate {
    private static final String LAYOUT = "layout";
    private static final String TABLE = "table";
    private static final String CSS_RICH_MESSAGES = "rich-messages";
    private static final String CSS_RICH_MESSAGES_MARKER = "rich-messages-marker";
    private static final String CSS_RICH_MESSAGES_LABEL = "rich-messages-label";

    @Override
    public VpeCreationData create(VpePageContext pageContext, Node sourceNode, nsIDOMDocument visualDocument) {
        nsIDOMElement container;
        VpeCreationData creationData = null;
        Element sourceElement = (Element)sourceNode;
        RichFacesMessageTemplate.Attributes attrs = new RichFacesMessageTemplate.Attributes(sourceElement);
        String styleClass = CSS_RICH_MESSAGES;
        String layout = ((Element)sourceNode).getAttribute(LAYOUT);
        if (TABLE.equalsIgnoreCase(layout)) {
            container = visualDocument.createElement(TABLE);
            container.setAttribute("cellpadding", "0");
            container.setAttribute("cellspacing", "0");
        } else {
            container = visualDocument.createElement("dl");
        }
        if (ComponentUtil.isNotBlank(attrs.getStyleValue())) {
            container.setAttribute("style", attrs.getStyleValue());
        }
        if (ComponentUtil.isNotBlank(attrs.getStyleClassValue())) {
            styleClass = String.valueOf(styleClass) + " " + attrs.getStyleClassValue();
        }
        container.setAttribute("class", styleClass);
        creationData = new VpeCreationData((nsIDOMNode)container);
        HashMap<String, Node> facets = this.getFacelets((Element)sourceNode);
        int i = 0;
        while (i < markers.length) {
            if (facets.containsKey(markers[i])) {
                container.appendChild((nsIDOMNode)this.createVisualMessage(creationData, visualDocument, layout, i, (Element)facets.get(markers[i]), attrs));
            } else {
                container.appendChild((nsIDOMNode)this.createVisualMessage(creationData, visualDocument, layout, i, null, attrs));
            }
            ++i;
        }
        return creationData;
    }

    private nsIDOMElement createVisualMessage(VpeCreationData creationData, nsIDOMDocument visualDocument, String layout, int markerNum, Element facet, RichFacesMessageTemplate.Attributes attrs) {
        String labelMessage;
        nsIDOMElement topContainer;
        nsIDOMElement container;
        String containerClass = "";
        String markerClass = CSS_RICH_MESSAGES_MARKER;
        String labelClass = CSS_RICH_MESSAGES_LABEL;
        nsIDOMElement marker = visualDocument.createElement("span");
        nsIDOMElement label = visualDocument.createElement("span");
        if (TABLE.equalsIgnoreCase(layout)) {
            nsIDOMElement tr = visualDocument.createElement("tr");
            container = visualDocument.createElement("td");
            tr.appendChild((nsIDOMNode)container);
            container.appendChild((nsIDOMNode)marker);
            container.appendChild((nsIDOMNode)label);
            topContainer = tr;
        } else {
            container = visualDocument.createElement("dt");
            container.appendChild((nsIDOMNode)marker);
            container.appendChild((nsIDOMNode)label);
            topContainer = container;
        }
        if (facet != null) {
            VpeChildrenInfo childrenInfo = new VpeChildrenInfo(marker);
            marker.setAttribute("VPE-FACET", facet.getAttribute("name"));
            creationData.addChildrenInfo(childrenInfo);
            childrenInfo.addSourceChild((Node)facet);
        }
        switch (markerNum) {
            case 0: {
                String string = labelMessage = attrs.getPassedLabelValue() == null ? "" : attrs.getPassedLabelValue();
                if (ComponentUtil.isNotBlank(attrs.getMarkerClassValue())) {
                    markerClass = String.valueOf(markerClass) + " " + attrs.getMarkerClassValue();
                }
                if (!ComponentUtil.isNotBlank(attrs.getLabelClassValue())) break;
                labelClass = String.valueOf(labelClass) + " " + attrs.getLabelClassValue();
                break;
            }
            case 1: {
                labelMessage = ERROR_MESSAGE;
                if (ComponentUtil.isNotBlank(attrs.getErrorClassValue())) {
                    containerClass = String.valueOf(containerClass) + " " + attrs.getErrorClassValue();
                }
                if (ComponentUtil.isNotBlank(attrs.getErrorMarkerClassValue())) {
                    markerClass = String.valueOf(markerClass) + " " + attrs.getErrorMarkerClassValue();
                }
                if (!ComponentUtil.isNotBlank(attrs.getErrorLabelClassValue())) break;
                labelClass = String.valueOf(labelClass) + " " + attrs.getErrorLabelClassValue();
                break;
            }
            case 2: {
                labelMessage = FATAL_MESSAGE;
                if (ComponentUtil.isNotBlank(attrs.getFatalClassValue())) {
                    containerClass = String.valueOf(containerClass) + " " + attrs.getFatalClassValue();
                }
                if (ComponentUtil.isNotBlank(attrs.getFatalMarkerClassValue())) {
                    markerClass = String.valueOf(markerClass) + " " + attrs.getFatalMarkerClassValue();
                }
                if (!ComponentUtil.isNotBlank(attrs.getFatalLabelClassValue())) break;
                labelClass = String.valueOf(labelClass) + " " + attrs.getFatalLabelClassValue();
                break;
            }
            case 3: {
                labelMessage = INFO_MESSAGE;
                if (ComponentUtil.isNotBlank(attrs.getInfoClassValue())) {
                    containerClass = String.valueOf(containerClass) + " " + attrs.getInfoClassValue();
                }
                if (ComponentUtil.isNotBlank(attrs.getInfoMarkerClassValue())) {
                    markerClass = String.valueOf(markerClass) + " " + attrs.getInfoMarkerClassValue();
                }
                if (!ComponentUtil.isNotBlank(attrs.getInfoLabelClassValue())) break;
                labelClass = String.valueOf(labelClass) + " " + attrs.getInfoLabelClassValue();
                break;
            }
            case 4: {
                labelMessage = WARNING_MESSAGE;
                if (ComponentUtil.isNotBlank(attrs.getWarnClassValue())) {
                    containerClass = String.valueOf(containerClass) + " " + attrs.getWarnClassValue();
                }
                if (ComponentUtil.isNotBlank(attrs.getWarnMarkerClassValue())) {
                    markerClass = String.valueOf(markerClass) + " " + attrs.getWarnMarkerClassValue();
                }
                if (!ComponentUtil.isNotBlank(attrs.getWarnLabelClassValue())) break;
                labelClass = String.valueOf(labelClass) + " " + attrs.getWarnLabelClassValue();
                break;
            }
            default: {
                labelMessage = "";
            }
        }
        if (ComponentUtil.isNotBlank(containerClass)) {
            container.setAttribute("class", containerClass);
        }
        marker.setAttribute("class", markerClass);
        label.setAttribute("class", labelClass);
        nsIDOMText text = visualDocument.createTextNode(labelMessage);
        label.appendChild((nsIDOMNode)text);
        return topContainer;
    }
}

