/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.jsf.vpe.richfaces.template;

import org.jboss.tools.jsf.vpe.richfaces.ComponentUtil;
import org.jboss.tools.vpe.editor.context.VpePageContext;
import org.jboss.tools.vpe.editor.template.VpeAbstractTemplate;
import org.jboss.tools.vpe.editor.template.VpeCreationData;
import org.mozilla.interfaces.nsIDOMDocument;
import org.mozilla.interfaces.nsIDOMElement;
import org.mozilla.interfaces.nsIDOMNode;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class RichFacesFileUploadTemplate
extends VpeAbstractTemplate {
    private static final String DEFAULT_CONTROL_LABEL_VALUE = "Add...";
    private static final String DEFAULT_LIST_HEIGHT = "210px";
    private static final String DEFAULT_LIST_WIDTH = "400px";
    private static final String FILE_UPLOAD_FILE_UPLOAD_CSS = "fileUpload/fileUpload.css";
    private static final String RICH_FACES_FILE_UPLOAD_EXT = "richFacesFileUpload";
    private String addControlLabel;
    private String listHeight;
    private String listWidth;
    private String uploadControlLabel;
    private String clearAllControlLabel;

    public VpeCreationData create(VpePageContext pageContext, Node sourceNode, nsIDOMDocument visualDocument) {
        Element source = (Element)sourceNode;
        StyleClasses styleClasses = new StyleClasses(source);
        this.prepareData(source);
        VpeCreationData data = null;
        ComponentUtil.setCSSLink(pageContext, FILE_UPLOAD_FILE_UPLOAD_CSS, RICH_FACES_FILE_UPLOAD_EXT);
        nsIDOMElement rootDiv = visualDocument.createElement("div");
        rootDiv.setAttribute("class", "rich-fileupload-list-decor");
        rootDiv.setAttribute("style", "width:" + this.listWidth);
        nsIDOMElement table = visualDocument.createElement("table");
        table.setAttribute("class", "rich-fileupload-toolbar-decor");
        nsIDOMElement tr = visualDocument.createElement("tr");
        nsIDOMElement td = visualDocument.createElement("td");
        nsIDOMElement buttonBorderDiv = visualDocument.createElement("div");
        buttonBorderDiv.setAttribute("class", "rich-fileupload-button-border");
        buttonBorderDiv.setAttribute("style", "float: left;");
        nsIDOMElement fileuploadButtonDiv = visualDocument.createElement("div");
        fileuploadButtonDiv.setAttribute("class", styleClasses.getAddButtonClass());
        fileuploadButtonDiv.setAttribute("style", "position: relative;");
        nsIDOMElement labelDiv = visualDocument.createElement("div");
        labelDiv.setAttribute("class", styleClasses.getAddButtonClassDiv2());
        labelDiv.appendChild((nsIDOMNode)visualDocument.createTextNode(this.addControlLabel));
        fileuploadButtonDiv.appendChild((nsIDOMNode)labelDiv);
        rootDiv.appendChild((nsIDOMNode)table);
        rootDiv.appendChild((nsIDOMNode)this.createPanelDiv(pageContext, source, visualDocument, styleClasses));
        table.appendChild((nsIDOMNode)tr);
        tr.appendChild((nsIDOMNode)td);
        td.appendChild((nsIDOMNode)buttonBorderDiv);
        buttonBorderDiv.appendChild((nsIDOMNode)fileuploadButtonDiv);
        td.appendChild(this.createControl(pageContext, sourceNode, visualDocument, styleClasses.getUploadButtonClass(), styleClasses.getUploadButtonClass2(), this.uploadControlLabel, false, styleClasses));
        td.appendChild(this.createControl(pageContext, sourceNode, visualDocument, styleClasses.getCleanButtonClass(), styleClasses.getCleanButtonClass2(), this.clearAllControlLabel, true, styleClasses));
        data = new VpeCreationData((nsIDOMNode)rootDiv);
        return data;
    }

    private nsIDOMNode createControl(VpePageContext pageContext, Node sourceNode, nsIDOMDocument visualDocument, String secondCssClass, String thirdCssClass, String text, boolean isClearButton, StyleClasses styleClasses) {
        nsIDOMElement firstDiv = visualDocument.createElement("div");
        nsIDOMElement secondDiv = visualDocument.createElement("div");
        nsIDOMElement thirdDiv = visualDocument.createElement("div");
        firstDiv.setAttribute("class", "rich-fileupload-button-border");
        firstDiv.setAttribute("style", "float: " + (isClearButton ? "right;" : "left;"));
        secondDiv.setAttribute("class", secondCssClass);
        thirdDiv.setAttribute("class", thirdCssClass);
        firstDiv.appendChild((nsIDOMNode)secondDiv);
        secondDiv.appendChild((nsIDOMNode)thirdDiv);
        if (isClearButton) {
            thirdDiv.appendChild((nsIDOMNode)visualDocument.createTextNode(text));
        } else {
            nsIDOMElement bDiv = visualDocument.createElement("b");
            thirdDiv.appendChild((nsIDOMNode)bDiv);
            bDiv.appendChild((nsIDOMNode)visualDocument.createTextNode(text));
        }
        return firstDiv;
    }

    private nsIDOMElement createPanelDiv(VpePageContext pageContext, Element source, nsIDOMDocument visualDocument, StyleClasses styleClasses) {
        nsIDOMElement div = visualDocument.createElement("div");
        div.setAttribute("class", styleClasses.getUploadListClass());
        div.setAttribute("style", "width:100%;height:" + this.listHeight);
        return div;
    }

    public boolean recreateAtAttrChange(VpePageContext pageContext, Element sourceElement, nsIDOMDocument visualDocument, nsIDOMElement visualNode, Object data, String name, String value) {
        return true;
    }

    private void prepareData(Element sourceElement) {
        try {
            this.listHeight = String.valueOf(ComponentUtil.parseWidthHeightValue(sourceElement.getAttribute("listHeight")));
        }
        catch (NumberFormatException numberFormatException) {
            this.listHeight = DEFAULT_LIST_HEIGHT;
        }
        try {
            this.listWidth = String.valueOf(ComponentUtil.parseWidthHeightValue(sourceElement.getAttribute("listWidth")));
        }
        catch (NumberFormatException numberFormatException) {
            this.listWidth = DEFAULT_LIST_WIDTH;
        }
        String addControlLabelAttrName = "addControlLabel";
        this.addControlLabel = sourceElement.hasAttribute(addControlLabelAttrName) ? sourceElement.getAttribute(addControlLabelAttrName) : DEFAULT_CONTROL_LABEL_VALUE;
        this.uploadControlLabel = ComponentUtil.getAttribute(sourceElement, "uploadControlLabel");
        if (ComponentUtil.isBlank(this.uploadControlLabel)) {
            this.uploadControlLabel = "Upload";
        }
        this.clearAllControlLabel = ComponentUtil.getAttribute(sourceElement, "clearAllControlLabel");
        if (ComponentUtil.isBlank(this.clearAllControlLabel)) {
            this.clearAllControlLabel = "Clear All";
        }
    }

    class StyleClasses {
        private static final String ATTR_STOP_BUTTON_CLASS = "stopButtonClass";
        private static final String ATTR_FILE_ENTRY_CONTROL_CLASS = "fileEntryControlClass";
        private static final String ATTR_FILE_ENTRY_CLASS = "fileEntryClass";
        private static final String ATTR_CLEAN_BUTTON_CLASS = "cleanButtonClass";
        private static final String ATTR_UPLOAD_BUTTON_CLASS = "uploadButtonClass";
        private static final String ATTR_UPLOAD_LIST_CLASS = "uploadListClass";
        private static final String ATTR_ADD_BUTTON_CLASS = "addButtonClass";
        private static final String POSTFIX_ENABLED = "";
        private static final String POSTFIX_DISABLED = "Disabled";
        private String addButtonClass = "rich-fileupload-button rich-fileupload-font";
        private String uploadButtonClass = "rich-fileupload-button rich-fileupload-font";
        private String cleanButtonClass = "rich-fileupload-button rich-fileupload-font";
        private String addButtonClassDiv2 = " rich-fileupload-button-content rich-fileupload-font rich-fileupload-ico rich-fileupload-ico-add";
        private String uploadButtonClass2 = "rich-fileupload-button-content rich-fileupload-font rich-fileupload-ico rich-fileupload-ico-start";
        private String cleanButtonClass2 = "rich-fileupload-button-content rich-fileupload-font rich-fileupload-ico rich-fileupload-ico-clear";
        private String uploadListClass = "rich-fileupload-list-overflow";

        public StyleClasses(Element sourceElement) {
            String uploadListClass;
            String cleanButtonClass;
            String uploadButtonClass;
            boolean disabled = "true".equalsIgnoreCase(sourceElement.getAttribute("disabled"));
            String styleAttrPostfix = disabled ? POSTFIX_DISABLED : POSTFIX_ENABLED;
            String addButtonClass = sourceElement.getAttribute(ATTR_ADD_BUTTON_CLASS + styleAttrPostfix);
            if (ComponentUtil.isNotBlank(addButtonClass)) {
                this.addButtonClass = String.valueOf(this.addButtonClass) + " " + addButtonClass;
                this.addButtonClassDiv2 = String.valueOf(this.addButtonClassDiv2) + " " + addButtonClass;
            }
            if (ComponentUtil.isNotBlank(uploadButtonClass = sourceElement.getAttribute(ATTR_UPLOAD_BUTTON_CLASS + styleAttrPostfix))) {
                this.uploadButtonClass = String.valueOf(this.uploadButtonClass) + " " + uploadButtonClass;
                this.uploadButtonClass2 = String.valueOf(this.uploadButtonClass2) + " " + uploadButtonClass;
            }
            if (ComponentUtil.isNotBlank(cleanButtonClass = sourceElement.getAttribute(ATTR_CLEAN_BUTTON_CLASS + styleAttrPostfix))) {
                this.cleanButtonClass = String.valueOf(this.cleanButtonClass) + " " + cleanButtonClass;
                this.cleanButtonClass2 = String.valueOf(this.cleanButtonClass2) + " " + cleanButtonClass;
            }
            if (ComponentUtil.isNotBlank(uploadListClass = sourceElement.getAttribute(ATTR_UPLOAD_LIST_CLASS + styleAttrPostfix))) {
                this.uploadListClass = String.valueOf(this.uploadListClass) + " " + uploadListClass;
            }
        }

        public String getAddButtonClass() {
            return this.addButtonClass;
        }

        public String getUploadButtonClass() {
            return this.uploadButtonClass;
        }

        public String getCleanButtonClass() {
            return this.cleanButtonClass;
        }

        public String getAddButtonClassDiv2() {
            return this.addButtonClassDiv2;
        }

        public String getCleanButtonClass2() {
            return this.cleanButtonClass2;
        }

        public String getUploadButtonClass2() {
            return this.uploadButtonClass2;
        }

        public String getUploadListClass() {
            return this.uploadListClass;
        }
    }
}

