/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.jst.web.kb.taglib;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.JarURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.apache.commons.io.IOUtils;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;
import org.eclipse.wst.xml.core.internal.XMLCorePlugin;
import org.eclipse.wst.xml.core.internal.catalog.Catalog;
import org.eclipse.wst.xml.core.internal.catalog.CatalogEntry;
import org.eclipse.wst.xml.core.internal.catalog.provisional.ICatalog;
import org.eclipse.wst.xml.core.internal.catalog.provisional.ICatalogElement;
import org.eclipse.wst.xml.core.internal.catalog.provisional.INextCatalog;
import org.jboss.tools.jst.web.kb.IKbProject;
import org.jboss.tools.jst.web.kb.KbProjectFactory;
import org.jboss.tools.jst.web.kb.WebKbPlugin;
import org.jboss.tools.jst.web.kb.taglib.ITagLibrary;

public class TagLibraryManager {
    private static Map<String, File> tempFiles = new ConcurrentHashMap<String, File>();

    public static ITagLibrary[] getLibraries(IProject project, String uri) {
        IKbProject kbProject = KbProjectFactory.getKbProject(project, true);
        if (kbProject == null) {
            return new ITagLibrary[0];
        }
        return uri == null ? kbProject.getProjectTagLibraries() : kbProject.getTagLibraries(uri);
    }

    public static ITagLibrary[] getLibraries(IResource resource) {
        IKbProject kbProject = KbProjectFactory.getKbProject(resource.getProject(), true);
        if (kbProject == null) {
            return new ITagLibrary[0];
        }
        return kbProject.getTagLibraries(resource.getFullPath());
    }

    public static ITagLibrary[] getLibraries(IProject project) {
        return TagLibraryManager.getLibraries(project, null);
    }

    public static File getStaticTLD(String uri) {
        try {
            if (uri != null) {
                File file;
                String id = XMLCorePlugin.getDefault().getDefaultXMLCatalog().resolveURI(uri);
                if (id == null) {
                    id = XMLCorePlugin.getDefault().getDefaultXMLCatalog().resolveSystem(uri);
                }
                if (id == null) {
                    id = XMLCorePlugin.getDefault().getDefaultXMLCatalog().resolvePublic(uri, uri);
                }
                if (id != null && (file = TagLibraryManager.convertUriToFile(id)).exists()) {
                    return file;
                }
            }
        }
        catch (IOException e) {
            WebKbPlugin.getDefault().logError(e);
        }
        return null;
    }

    public static List<File> getStaticTagLibs() {
        ArrayList<File> files = new ArrayList<File>();
        try {
            INextCatalog[] catalogs;
            INextCatalog[] iNextCatalogArray = catalogs = XMLCorePlugin.getDefault().getDefaultXMLCatalog().getNextCatalogs();
            int n = catalogs.length;
            int n2 = 0;
            while (n2 < n) {
                INextCatalog catalog = iNextCatalogArray[n2];
                ICatalog c = catalog.getReferencedCatalog();
                if (c instanceof Catalog) {
                    ICatalogElement[] elements;
                    ICatalogElement[] iCatalogElementArray = elements = ((Catalog)c).getCatalogElements();
                    int n3 = elements.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        File file;
                        CatalogEntry entry;
                        String uri;
                        ICatalogElement element = iCatalogElementArray[n4];
                        if (element instanceof CatalogEntry && (uri = (entry = (CatalogEntry)element).getURI()) != null && (uri.endsWith(".tld") || uri.endsWith(".xml") && uri.indexOf("taglib") > 0) && (uri.startsWith("file:") || uri.startsWith("jar:")) && (file = TagLibraryManager.convertUriToFile(uri)) != null) {
                            files.add(file);
                        }
                        ++n4;
                    }
                }
                ++n2;
            }
        }
        catch (IOException e) {
            WebKbPlugin.getDefault().logError(e);
        }
        return files;
    }

    private static File convertUriToFile(String uri) throws IOException {
        URLConnection c;
        File file = tempFiles.get(uri);
        if (file != null && file.exists()) {
            return file;
        }
        URL url = new URL(uri);
        String filePath = url.getFile();
        file = new File(filePath);
        if (!file.exists() && (c = url.openConnection()) instanceof JarURLConnection) {
            String name;
            JarURLConnection connection = (JarURLConnection)c;
            JarFile jar = connection.getJarFile();
            JarEntry entry = connection.getJarEntry();
            File entryFile = new File(entry.getName());
            String prefix = name = entryFile.getName();
            String sufix = null;
            int i = name.lastIndexOf(46);
            if (i > 0 && i < name.length()) {
                prefix = name.substring(0, i);
                sufix = name.substring(i);
            }
            while (prefix.length() < 3) {
                prefix = String.valueOf(prefix) + "_";
            }
            WebKbPlugin plugin = WebKbPlugin.getDefault();
            if (plugin != null) {
                IPath path = plugin.getStateLocation();
                File tmp = new File(path.toFile(), "tmp");
                tmp.mkdirs();
                file = File.createTempFile(prefix, sufix, tmp);
                file.deleteOnExit();
                InputStream in = null;
                try {
                    in = jar.getInputStream(entry);
                    FileOutputStream out = new FileOutputStream(file);
                    IOUtils.copy((InputStream)in, (OutputStream)out);
                }
                finally {
                    IOUtils.closeQuietly((InputStream)in);
                }
            }
        }
        if (file.exists()) {
            tempFiles.put(uri, file);
        } else {
            file = null;
        }
        return file;
    }
}

