/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.jst.web.kb.internal.validation;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IRegion;
import org.eclipse.wst.validation.internal.core.ValidationException;
import org.eclipse.wst.validation.internal.provisional.core.IReporter;
import org.eclipse.wst.validation.internal.provisional.core.IValidationContext;
import org.eclipse.wst.validation.internal.provisional.core.IValidator;
import org.jboss.tools.common.EclipseUtil;
import org.jboss.tools.common.el.core.ELReference;
import org.jboss.tools.common.el.core.model.ELExpression;
import org.jboss.tools.common.el.core.model.ELInstance;
import org.jboss.tools.common.el.core.model.ELInvocationExpression;
import org.jboss.tools.common.el.core.model.ELPropertyInvocation;
import org.jboss.tools.common.el.core.parser.ELParserFactory;
import org.jboss.tools.common.el.core.parser.ELParserUtil;
import org.jboss.tools.common.el.core.parser.LexicalToken;
import org.jboss.tools.common.el.core.parser.SyntaxError;
import org.jboss.tools.common.el.core.resolver.ELContext;
import org.jboss.tools.common.el.core.resolver.ELContextImpl;
import org.jboss.tools.common.el.core.resolver.ELResolution;
import org.jboss.tools.common.el.core.resolver.ELResolver;
import org.jboss.tools.common.el.core.resolver.ELResolverFactoryManager;
import org.jboss.tools.common.el.core.resolver.ELSegment;
import org.jboss.tools.common.el.core.resolver.IVariable;
import org.jboss.tools.common.el.core.resolver.JavaMemberELSegmentImpl;
import org.jboss.tools.common.el.core.resolver.SimpleELContext;
import org.jboss.tools.common.el.core.resolver.TypeInfoCollector;
import org.jboss.tools.common.java.IJavaSourceReference;
import org.jboss.tools.common.preferences.SeverityPreferences;
import org.jboss.tools.common.text.ITextSourceReference;
import org.jboss.tools.common.validation.ContextValidationHelper;
import org.jboss.tools.common.validation.EditorValidationContext;
import org.jboss.tools.common.validation.IELValidationDelegate;
import org.jboss.tools.common.validation.IPreferenceInfo;
import org.jboss.tools.common.validation.IProjectValidationContext;
import org.jboss.tools.common.validation.IStringValidator;
import org.jboss.tools.common.validation.ITypedReporter;
import org.jboss.tools.common.validation.IValidatingProjectTree;
import org.jboss.tools.common.validation.PreferenceInfoManager;
import org.jboss.tools.common.validation.SkipValidation;
import org.jboss.tools.common.validation.ValidatorManager;
import org.jboss.tools.jst.web.kb.PageContextFactory;
import org.jboss.tools.jst.web.kb.WebKbPlugin;
import org.jboss.tools.jst.web.kb.internal.KbBuilder;
import org.jboss.tools.jst.web.kb.internal.validation.ELValidationMessages;
import org.jboss.tools.jst.web.kb.internal.validation.KBValidator;
import org.jboss.tools.jst.web.kb.internal.validation.WebValidator;
import org.jboss.tools.jst.web.kb.preferences.ELSeverityPreferences;

public class ELValidator
extends WebValidator
implements IStringValidator {
    public static final String ID = "org.jboss.tools.jst.web.kb.ELValidator";
    public static final String PREFERENCE_PAGE_ID = "org.jboss.tools.jst.web.ui.preferences.ELValidatorPreferencePage";
    public static final String PROPERTY_PAGE_ID = "org.jboss.tools.jst.web.ui.properties.ELValidatorPreferencePage";
    private static final String EXTENSION_POINT_ID = "org.jboss.tools.jst.web.kb.elValidationDelegate";
    private static Set<IELValidationDelegate> DELEGATES = new HashSet<IELValidationDelegate>();
    private ELResolver[] resolvers;
    protected ELParserFactory mainFactory;
    private boolean revalidateUnresolvedELs = false;
    private boolean validateVars = true;
    private int markers;
    private static final String BUNDLE_NAME = "org.jboss.tools.jst.web.kb.internal.validation.messages";

    static {
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IExtensionPoint extensionPoint = registry.getExtensionPoint(EXTENSION_POINT_ID);
        if (extensionPoint != null) {
            IExtension[] extensions = extensionPoint.getExtensions();
            int i = 0;
            while (i < extensions.length) {
                IExtension extension = extensions[i];
                IConfigurationElement[] elements = extension.getConfigurationElements();
                int j = 0;
                while (j < elements.length) {
                    try {
                        IELValidationDelegate delegate = (IELValidationDelegate)elements[j].createExecutableExtension("class");
                        DELEGATES.add(delegate);
                    }
                    catch (CoreException e) {
                        WebKbPlugin.getDefault().logError(e);
                    }
                    ++j;
                }
                ++i;
            }
        }
    }

    public boolean isEnabled(IProject project) {
        return ELSeverityPreferences.isValidationEnabled(project) && ELSeverityPreferences.shouldValidateEL(project);
    }

    public int getMaxNumberOfMarkersPerFile(IProject project) {
        return ELSeverityPreferences.getMaxNumberOfProblemMarkersPerFile(project);
    }

    @Override
    public void init(IProject project, ContextValidationHelper validationHelper, IProjectValidationContext context, IValidator manager, IReporter reporter) {
        super.init(project, validationHelper, context, manager, reporter);
        this.setAsYouTypeValidation(false);
        this.resolvers = ELResolverFactoryManager.getInstance().getResolvers((IResource)project);
        this.mainFactory = ELParserUtil.getJbossFactory();
        this.validateVars = "enabled".equals(ELSeverityPreferences.getInstance().getProjectPreference(this.validatingProject, ELSeverityPreferences.CHECK_VARS));
    }

    public IStatus validate(Set<IFile> changedFiles, IProject project, ContextValidationHelper validationHelper, IProjectValidationContext context, ValidatorManager manager, IReporter reporter) throws ValidationException {
        this.init(project, validationHelper, context, (IValidator)manager, reporter);
        this.initRevalidationFlag();
        IWorkspaceRoot wsRoot = ResourcesPlugin.getWorkspace().getRoot();
        HashSet<IFile> filesToValidate = new HashSet<IFile>();
        boolean containsJavaOrComponentsXml = false;
        for (IFile file : changedFiles) {
            if (!this.shouldBeValidated(file) || !this.notValidatedYet((IResource)file)) continue;
            filesToValidate.add(file);
            if (containsJavaOrComponentsXml) continue;
            String fileName = file.getName().toLowerCase();
            boolean bl = containsJavaOrComponentsXml = fileName.endsWith(".java") || fileName.endsWith(".properties") || fileName.equals("components.xml");
        }
        if (containsJavaOrComponentsXml && this.revalidateUnresolvedELs) {
            Set unnamedResources = this.validationContext.getUnnamedElResources();
            for (IPath path : unnamedResources) {
                IFile file = wsRoot.getFile(path);
                if (!this.shouldBeValidated(file) || !this.notValidatedYet((IResource)file)) continue;
                filesToValidate.add(file);
            }
        }
        Set els = this.validationContext.getElsForValidation(changedFiles, false);
        this.validationContext.removeLinkedEls(filesToValidate);
        HashSet<ELReference> elsToValidate = new HashSet<ELReference>();
        if (this.revalidateUnresolvedELs) {
            int i = 0;
            for (ELReference el : els) {
                IFile resource = el.getResource();
                if (!(resource instanceof IFile) || !this.shouldBeValidated(resource) || filesToValidate.contains(resource) || !this.notValidatedYet((IResource)resource)) continue;
                if (i++ > 1000) break;
                this.validationContext.removeLinkedEl(el);
                elsToValidate.add(el);
            }
        }
        for (IFile file : filesToValidate) {
            this.validateFile(file);
        }
        for (ELReference el : elsToValidate) {
            this.validateEL(el, false, null);
            this.coreHelper.getValidationContextManager().addValidatedProject((org.jboss.tools.common.validation.IValidator)this, el.getResource().getProject());
        }
        this.validationContext.clearOldVariableNameForElValidation();
        return this.OK_STATUS;
    }

    private void initRevalidationFlag() {
        String revalidateUnresolvedELsString = ELSeverityPreferences.getInstance().getProjectPreference(this.validatingProject, ELSeverityPreferences.RE_VALIDATE_UNRESOLVED_EL);
        this.revalidateUnresolvedELs = "enabled".equals(revalidateUnresolvedELsString);
    }

    public IStatus validateAll(IProject project, ContextValidationHelper validationHelper, IProjectValidationContext context, ValidatorManager manager, IReporter reporter) throws ValidationException {
        this.init(project, validationHelper, context, (IValidator)manager, reporter);
        this.initRevalidationFlag();
        Set files = validationHelper.getProjectSetRegisteredFiles();
        HashSet<IFile> filesToValidate = new HashSet<IFile>();
        for (IFile file : files) {
            if (this.shouldBeValidated(file)) {
                if (!this.notValidatedYet((IResource)file)) continue;
                filesToValidate.add(file);
                continue;
            }
            this.validationContext.removeUnnamedElResource(file.getFullPath());
        }
        for (IFile file : filesToValidate) {
            this.validateFile(file);
        }
        return this.OK_STATUS;
    }

    public void validate(IValidator validatorManager, IProject rootProject, Collection<IRegion> dirtyRegions, IValidationContext helper, IReporter reporter, EditorValidationContext validationContext, IProjectValidationContext projectContext, IFile file) {
        ELContext elContext;
        this.init(rootProject, null, projectContext, validatorManager, reporter);
        this.setAsYouTypeValidation(true);
        ++this.asYouTypeTimestamp;
        this.document = validationContext.getDocument();
        if (dirtyRegions.size() == 1) {
            IRegion region = dirtyRegions.iterator().next();
            try {
                String s = this.document.get(region.getOffset(), region.getLength());
                if (s.indexOf("#{") < 0 && s.indexOf("${") < 0) {
                    return;
                }
            }
            catch (BadLocationException e) {
                WebKbPlugin.getDefault().logError(e);
            }
        }
        if ((elContext = PageContextFactory.createPageContext(this.document, false)) != null) {
            elContext.setDirty(true);
            for (IRegion region : dirtyRegions) {
                Collection regionReferences = elContext.getELReferences(region);
                for (ELReference elReference : regionReferences) {
                    this.validateEL(elReference, true, elContext);
                }
                this.disableProblemAnnotations(region, reporter);
            }
            if (reporter instanceof ITypedReporter) {
                ((ITypedReporter)reporter).addTypeForRegion(this.getProblemType());
            }
        }
    }

    private void validateFile(IFile file) {
        if (this.reporter.isCancelled() || !this.shouldFileBeValidated(file)) {
            return;
        }
        this.displaySubtask(ELValidationMessages.VALIDATING_EL_FILE, new String[]{file.getProject().getName(), file.getName()});
        this.coreHelper.getValidationContextManager().addValidatedProject((org.jboss.tools.common.validation.IValidator)this, file.getProject());
        this.removeAllMessagesFromResource((IResource)file);
        this.markers = 0;
        ELContext context = PageContextFactory.createPageContext(file);
        if (context != null) {
            ELReference[] references = context.getELReferences();
            int i = 0;
            while (i < references.length) {
                if (this.markers < this.getMaxNumberOfMarkersPerFile(file.getProject())) {
                    this.validateEL(references[i], false, context);
                }
                ++i;
            }
        }
    }

    private void validateEL(ELReference el, boolean asYouType, ELContext context) {
        if (asYouType || !this.reporter.isCancelled() && this.shouldBeValidated(el.getResource())) {
            this.displaySubtask(ELValidationMessages.VALIDATING_EL_FILE, new String[]{el.getResource().getProject().getName(), el.getResource().getName()});
            if (!asYouType) {
                el.deleteMarkers();
            }
            if (context != null && !el.getSyntaxErrors().isEmpty() && !this.isDollarExpressionInXML(el)) {
                for (SyntaxError error : el.getSyntaxErrors()) {
                    ++this.markers;
                    IJavaSourceReference reference = this.getJavaReference(el.getResource(), el.getStartPosition() + error.getPosition(), 1);
                    if (reference == null) {
                        if (asYouType) {
                            this.addMessage((IResource)el.getResource(), el.getStartPosition() + error.getPosition(), 1, ELSeverityPreferences.EL_SYNTAX_ERROR, ELValidationMessages.EL_SYNTAX_ERROR, new String[]{error.getProblem()});
                            continue;
                        }
                        this.addError(ELValidationMessages.EL_SYNTAX_ERROR, ELSeverityPreferences.EL_SYNTAX_ERROR, new String[]{error.getProblem()}, el.getLineNumber(), 1, el.getStartPosition() + error.getPosition(), (IResource)context.getResource());
                        continue;
                    }
                    if (asYouType) {
                        this.addMessage((IResource)el.getResource(), (ITextSourceReference)reference, ELSeverityPreferences.EL_SYNTAX_ERROR, ELValidationMessages.EL_SYNTAX_ERROR, new String[]{error.getProblem()});
                        continue;
                    }
                    this.addError(ELValidationMessages.EL_SYNTAX_ERROR, ELSeverityPreferences.EL_SYNTAX_ERROR, new String[]{error.getProblem()}, (ITextSourceReference)reference, (IResource)context.getResource());
                }
            }
            ELExpression[] eLExpressionArray = el.getEl();
            int n = eLExpressionArray.length;
            int n2 = 0;
            while (n2 < n) {
                ELExpression expresion = eLExpressionArray[n2];
                this.validateELExpression(el, expresion, asYouType, context);
                ++n2;
            }
        }
    }

    private boolean isDollarExpressionInXML(ELReference el) {
        String ext = el.getResource().getFileExtension();
        return "xml".equals(ext) && this.isDollarExpression(el);
    }

    private boolean isDollarExpression(ELReference el) {
        List is = el.getELModel().getInstances();
        for (ELInstance i : is) {
            if (!i.getFirstToken().getText().equals("${")) continue;
            return true;
        }
        return false;
    }

    private void validateELExpression(ELReference elReference, ELExpression el, boolean asYouType, ELContext context) {
        List es = el.getInvocations();
        for (ELInvocationExpression token : es) {
            this.validateElOperand(elReference, token, asYouType, context);
        }
    }

    private void validateElOperand(ELReference elReference, ELInvocationExpression operandToken, boolean asYouType, ELContext context) {
        ELSegment segment2;
        IFile file = elReference.getResource();
        int documnetOffset = elReference.getStartPosition();
        String operand = operandToken.getText();
        if (operand.trim().length() == 0) {
            return;
        }
        String varName = operand;
        int offsetOfVarName = documnetOffset + operandToken.getFirstToken().getStart();
        int lengthOfVarName = varName.length();
        boolean unresolvedTokenIsVariable = false;
        ELResolution resolution = null;
        if (context == null) {
            context = PageContextFactory.createPageContext(file);
        }
        if (context == null) {
            context = new SimpleELContext();
            context.setResource(file);
            context.setElResolvers(this.resolvers);
        }
        int maxNumberOfResolvedSegments = -1;
        int maxNumberOfDetectedSegments = -1;
        List vars = null;
        ELContextImpl c = null;
        if (!this.validateVars && context instanceof ELContextImpl) {
            c = (ELContextImpl)context;
            vars = c.getAllVars();
            c.setAllVars(new ArrayList());
        }
        int i = 0;
        while (i < this.resolvers.length) {
            ELResolution elResolution;
            if (this.resolvers[i].getClass().getAnnotation(SkipValidation.class) == null && (elResolution = this.resolvers[i].resolve(context, (ELExpression)operandToken, documnetOffset)) != null) {
                int segmentsNumber;
                if (!asYouType) {
                    for (ELSegment segment2 : elResolution.getSegments()) {
                        IResource resource = segment2.getResource();
                        if (!(resource instanceof IFile)) continue;
                        this.validationContext.addLinkedEl(resource.getFullPath().toString(), elReference);
                    }
                }
                if (elResolution.isResolved()) {
                    resolution = elResolution;
                    break;
                }
                int number = elResolution.getNumberOfResolvedSegments();
                if (number > maxNumberOfResolvedSegments) {
                    maxNumberOfResolvedSegments = number;
                    maxNumberOfDetectedSegments = elResolution.getSegments().size();
                    resolution = elResolution;
                } else if (number == maxNumberOfResolvedSegments && (segmentsNumber = elResolution.getSegments().size()) > maxNumberOfDetectedSegments) {
                    maxNumberOfDetectedSegments = segmentsNumber;
                    resolution = elResolution;
                }
            }
            ++i;
        }
        if (c != null) {
            c.setAllVars(vars);
        }
        if (resolution == null) {
            return;
        }
        if (!asYouType && !resolution.isResolved()) {
            Set<String> names = this.findVariableNames(operandToken);
            for (String name : names) {
                this.validationContext.addLinkedEl(name, elReference);
            }
        }
        List segments = resolution.getSegments();
        ArrayList usedVariables = new ArrayList();
        for (ELSegment segment2 : segments) {
            JavaMemberELSegmentImpl javaSegment;
            if (!segment2.getVariables().isEmpty()) {
                usedVariables.addAll(segment2.getVariables());
            }
            if (!(segment2 instanceof JavaMemberELSegmentImpl) || (javaSegment = (JavaMemberELSegmentImpl)segment2).getUnpairedGettersOrSetters().isEmpty()) continue;
            TypeInfoCollector.MethodInfo unpairedMethod = (TypeInfoCollector.MethodInfo)javaSegment.getUnpairedGettersOrSetters().values().iterator().next();
            String methodName = unpairedMethod.getName();
            String propertyName = (String)javaSegment.getUnpairedGettersOrSetters().keySet().iterator().next();
            String missingMethodName = ELValidationMessages.EL_VALIDATOR_SETTER;
            String existedMethodName = ELValidationMessages.EL_VALIDATOR_GETTER;
            if (methodName.startsWith("s")) {
                missingMethodName = existedMethodName;
                existedMethodName = ELValidationMessages.EL_VALIDATOR_SETTER;
            }
            int startPosition = documnetOffset + operandToken.getStartPosition();
            int length = operandToken.getLength();
            int startPr = operand.indexOf(propertyName);
            if (startPr > -1) {
                startPosition += startPr;
                length = propertyName.length();
            }
            IJavaSourceReference reference = this.getJavaReference(file, startPosition, length);
            IMarker marker = null;
            if (reference != null) {
                if (asYouType) {
                    this.addMessage((IResource)file, (ITextSourceReference)reference, ELSeverityPreferences.UNPAIRED_GETTER_OR_SETTER, ELValidationMessages.UNPAIRED_GETTER_OR_SETTER, new String[]{propertyName, existedMethodName, missingMethodName});
                } else {
                    marker = this.addError(ELValidationMessages.UNPAIRED_GETTER_OR_SETTER, ELSeverityPreferences.UNPAIRED_GETTER_OR_SETTER, new String[]{propertyName, existedMethodName, missingMethodName}, (ITextSourceReference)reference, (IResource)file);
                    elReference.addMarker(marker);
                }
            } else if (asYouType) {
                this.addMessage((IResource)file, startPosition, length, ELSeverityPreferences.UNPAIRED_GETTER_OR_SETTER, ELValidationMessages.UNPAIRED_GETTER_OR_SETTER, new String[]{propertyName, existedMethodName, missingMethodName});
            } else {
                marker = this.addError(ELValidationMessages.UNPAIRED_GETTER_OR_SETTER, ELSeverityPreferences.UNPAIRED_GETTER_OR_SETTER, new String[]{propertyName, existedMethodName, missingMethodName}, elReference.getLineNumber(), length, startPosition, (IResource)file);
                elReference.addMarker(marker);
            }
            if (marker == null) continue;
            ++this.markers;
        }
        if (!asYouType) {
            for (IVariable variable : usedVariables) {
                this.validationContext.addLinkedEl(variable.getName(), elReference);
            }
        }
        if (resolution.isResolved() || !resolution.isValidatable()) {
            return;
        }
        segment2 = resolution.getUnresolvedSegment();
        if (segment2 == null) {
            return;
        }
        LexicalToken token = segment2.getToken();
        if (token == null) {
            WebKbPlugin.getDefault().logError("The token from unresolved segment is null. EL: [" + operand + "]");
        }
        if ((varName = token.getText()) == null) {
            return;
        }
        offsetOfVarName = documnetOffset + token.getStart();
        int n = lengthOfVarName = varName == null ? 0 : varName.length();
        if (usedVariables.isEmpty()) {
            unresolvedTokenIsVariable = true;
        }
        IJavaSourceReference javaReference = this.getJavaReference(file, offsetOfVarName, lengthOfVarName);
        IMarker marker = null;
        String message = ELValidationMessages.UNKNOWN_EL_VARIABLE_PROPERTY_NAME;
        String preference = ELSeverityPreferences.UNKNOWN_EL_VARIABLE_PROPERTY_NAME;
        if (unresolvedTokenIsVariable) {
            message = ELValidationMessages.UNKNOWN_EL_VARIABLE_NAME;
            preference = ELSeverityPreferences.UNKNOWN_EL_VARIABLE_NAME;
        }
        if (javaReference == null) {
            if (asYouType) {
                this.addMessage((IResource)file, offsetOfVarName, lengthOfVarName, preference, message, new String[]{varName});
            } else {
                marker = this.addError(message, preference, new String[]{varName}, elReference.getLineNumber(), lengthOfVarName, offsetOfVarName, (IResource)file);
            }
        } else if (asYouType) {
            this.addMessage((IResource)file, (ITextSourceReference)javaReference, preference, message, new String[]{varName});
        } else {
            marker = this.addError(message, preference, new String[]{varName}, (ITextSourceReference)javaReference, (IResource)file);
        }
        if (marker != null) {
            if (!asYouType) {
                elReference.addMarker(marker);
            }
            ++this.markers;
        }
    }

    IJavaSourceReference getJavaReference(final IFile file, final int startPosition, final int length) {
        ICompilationUnit u;
        IJavaElement el = null;
        if (file.getName().endsWith(".java") && (u = EclipseUtil.getCompilationUnit((IFile)file)) != null) {
            try {
                el = u.getElementAt(startPosition);
            }
            catch (CoreException e) {
                WebKbPlugin.getDefault().logError(e);
            }
        }
        if (el instanceof IMember) {
            final IMember member = (IMember)el;
            return new IJavaSourceReference(){

                public int getStartPosition() {
                    return startPosition;
                }

                public int getLength() {
                    return length;
                }

                public IResource getResource() {
                    return file;
                }

                public IMember getSourceMember() {
                    return member;
                }

                public IJavaElement getSourceElement() {
                    return member;
                }
            };
        }
        return null;
    }

    private Set<String> findVariableNames(ELInvocationExpression invocationExpression) {
        HashSet<String> names = new HashSet<String>();
        while (invocationExpression != null) {
            String name;
            if (invocationExpression instanceof ELPropertyInvocation && (name = ((ELPropertyInvocation)invocationExpression).getQualifiedName()) != null) {
                names.add(name);
            }
            invocationExpression = invocationExpression.getLeft();
        }
        return names;
    }

    protected String getPreference(IProject project, String preferenceKey) {
        return ELSeverityPreferences.getInstance().getProjectPreference(project, preferenceKey);
    }

    public String getId() {
        return ID;
    }

    public String getBuilderId() {
        return KbBuilder.BUILDER_ID;
    }

    public IValidatingProjectTree getValidatingProjects(IProject project) {
        int max = 0;
        IValidatingProjectTree result = null;
        for (IELValidationDelegate delegate : DELEGATES) {
            IValidatingProjectTree tree;
            if (!delegate.shouldValidate(project) || (tree = delegate.getValidatingProjects(project)).getAllProjects().size() <= max) continue;
            max = tree.getAllProjects().size();
            result = tree;
        }
        return result;
    }

    public boolean shouldValidate(IProject project) {
        return this.shouldValidate(project, false);
    }

    public boolean shouldValidateAsYouType(IProject project) {
        return this.shouldValidate(project, true);
    }

    public boolean shouldValidate(IProject project, boolean asYouType) {
        boolean result = false;
        try {
            if (project.isAccessible() && this.isEnabled(project) && (asYouType || this.validateBuilderOrder(project))) {
                for (IELValidationDelegate delegate : DELEGATES) {
                    if (!delegate.shouldValidate(project)) continue;
                    result = true;
                }
            }
        }
        catch (CoreException e) {
            WebKbPlugin.getDefault().logError(e);
        }
        return result;
    }

    private boolean validateBuilderOrder(IProject project) throws CoreException {
        return KBValidator.validateBuilderOrder(project, this.getBuilderId(), this.getId(), (SeverityPreferences)ELSeverityPreferences.getInstance());
    }

    @Override
    protected boolean shouldValidateJavaSources() {
        return true;
    }

    protected String getMessageBundleName() {
        return BUNDLE_NAME;
    }

    public void registerPreferenceInfo() {
        PreferenceInfoManager.register((String)this.getProblemType(), (IPreferenceInfo)new ELPreferenceInfo());
    }

    class ELPreferenceInfo
    implements IPreferenceInfo {
        ELPreferenceInfo() {
        }

        public String getPreferencePageId() {
            return ELValidator.PREFERENCE_PAGE_ID;
        }

        public String getPropertyPageId() {
            return ELValidator.PROPERTY_PAGE_ID;
        }

        public String getPluginId() {
            return "org.jboss.tools.jst.web.kb";
        }
    }
}

